/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.internal.upgrade.datastore;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.cooperation2.Cooperation2;
import org.sonatype.nexus.common.cooperation2.Cooperation2Factory;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.ExternalTaskState;
import org.sonatype.nexus.scheduling.PeriodicJobService;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.TaskState;
import org.sonatype.nexus.scheduling.UpgradeTaskScheduler;
import org.sonatype.nexus.scheduling.events.TaskEventStopped;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedCanceled;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedDone;
import org.sonatype.nexus.scheduling.events.TaskEventStoppedFailed;
import org.sonatype.nexus.scheduling.internal.upgrade.datastore.UpgradeTaskData;
import org.sonatype.nexus.scheduling.internal.upgrade.datastore.UpgradeTaskStore;

@Priority(value=0x7FFFFFFF)
@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
public class QueuingUpgradeTaskScheduler
extends StateGuardLifecycleSupport
implements EventAware,
EventAware.Asynchronous,
UpgradeTaskScheduler {
    private final boolean checkRequiresMigration;
    private final Cooperation2 cooperation;
    private final Duration delayOnStart;
    private final PeriodicJobService periodicJobService;
    private final TaskScheduler taskScheduler;
    private final UpgradeTaskStore upgradeTaskStore;

    @Inject
    public QueuingUpgradeTaskScheduler(PeriodicJobService periodicJobService, TaskScheduler taskScheduler, UpgradeTaskStore upgradeTaskStore, @Named(value="${nexus.upgrade.tasks.checkOnStartup:-true}") @Named(value="${nexus.upgrade.tasks.checkOnStartup:-true}") boolean checkRequiresMigration, @Named(value="${nexus.upgrade.tasks.delay:-10s}") @Named(value="${nexus.upgrade.tasks.delay:-10s}") Duration delayOnStart, Cooperation2Factory cooperationFactory) {
        this.periodicJobService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.upgradeTaskStore = (UpgradeTaskStore)((Object)Preconditions.checkNotNull((Object)((Object)upgradeTaskStore)));
        this.checkRequiresMigration = checkRequiresMigration;
        this.delayOnStart = (Duration)Preconditions.checkNotNull((Object)delayOnStart);
        this.cooperation = ((Cooperation2Factory)Preconditions.checkNotNull((Object)cooperationFactory)).configure().build("reschedule-upgrade-task");
    }

    @Override
    public void schedule(TaskConfiguration configuration) {
        this.upgradeTaskStore.insert(new UpgradeTaskData(configuration.getId(), configuration.asMap()));
        if (this.isStarted()) {
            this.maybeStartQueue();
        }
    }

    protected void doStart() throws Exception {
        if (!this.checkRequiresMigration) {
            this.log.warn("Configured not to reschedule failed upgrade tasks. This may lead to missing features or bugs.");
            return;
        }
        this.periodicJobService.startUsing();
        this.periodicJobService.runOnce(this::maybeStartQueue, (int)this.delayOnStart.getSeconds());
    }

    protected void doStop() throws Exception {
        if (this.checkRequiresMigration) {
            this.periodicJobService.stopUsing();
        }
    }

    @Subscribe
    public void on(TaskEventStopped event) {
        this.log.debug("on event: {}", (Object)event);
        TaskInfo taskInfo = event.getTaskInfo();
        if (event instanceof TaskEventStoppedFailed && this.upgradeTaskStore.markFailed(taskInfo.getId()) > 0) {
            this.log.error("Upgrade task failed: {}. Queue will be restarted on startup.", (Object)taskInfo.getName());
        } else if (event instanceof TaskEventStoppedCanceled && this.upgradeTaskStore.markCanceled(taskInfo.getId()) > 0) {
            this.log.error("Upgrade task cancelled: {}. Queue will be restarted on startup.", (Object)taskInfo.getName());
        } else if (event instanceof TaskEventStoppedDone && this.upgradeTaskStore.deleteByTaskId(taskInfo.getId()) > 0) {
            this.log.debug("Task {} completed.", (Object)taskInfo);
            this.maybeStartQueue();
        }
    }

    @Guarded(by={"STARTED"})
    protected void maybeStartQueue() {
        try {
            this.cooperation.on(() -> {
                Optional<UpgradeTaskData> next = this.upgradeTaskStore.next();
                if (!next.isPresent()) {
                    return null;
                }
                if (this.notRunningAndNotDone(next.get())) {
                    this.scheduleTask(next.get());
                }
                return null;
            }).checkFunction(Optional::empty).cooperate("queue", new String[0]);
        }
        catch (Exception e) {
            this.log.error("An error occurred while starting the upgrade task queue.", (Throwable)e);
        }
    }

    private TaskInfo scheduleTask(UpgradeTaskData task) {
        Optional<TaskInfo> taskInfo = this.upgradeTaskStore.read(task.getId()).flatMap(this::getExistingTask);
        String taskName = QueuingUpgradeTaskScheduler.extractName(task);
        try {
            if (taskInfo.isPresent()) {
                if (this.notRunningAndNotDone(taskInfo)) {
                    this.log.info("Re-running failed upgrade task {}", (Object)taskName);
                    taskInfo.get().runNow();
                }
                this.log.debug("Task already running for {}", (Object)taskName);
                return taskInfo.get();
            }
            TaskConfiguration config = new TaskConfiguration();
            this.log.info("Running failed upgrade task {}", (Object)taskName);
            config.addAll(task.getConfiguration());
            TaskInfo result = this.taskScheduler.submit(config);
            task.setTaskId(result.getId());
            this.upgradeTaskStore.update(task);
            return result;
        }
        catch (Exception e) {
            this.log.error("Failed to restart upgrade task: {}", (Object)taskName, (Object)e);
            return null;
        }
    }

    private boolean notRunningAndNotDone(UpgradeTaskData upgradetask) {
        this.log.trace("Checking state of taskId {}", (Object)upgradetask.getId());
        return this.notRunningAndNotDone(this.getExistingTask(upgradetask));
    }

    private boolean notRunningAndNotDone(Optional<TaskInfo> upgradeTask) {
        return upgradeTask.map(this.taskScheduler::toExternalTaskState).map(ExternalTaskState::getState).map(state -> !state.isRunning() && !TaskState.OK.equals(state)).orElse(true);
    }

    private Optional<TaskInfo> getExistingTask(UpgradeTaskData upgradeTask) {
        return Optional.ofNullable(this.taskScheduler.getTaskById(upgradeTask.getTaskId()));
    }

    private static String extractName(UpgradeTaskData task) {
        TaskConfiguration configuration = new TaskConfiguration();
        configuration.addAll(task.getConfiguration());
        return configuration.getName();
    }

    @Override
    public TaskConfiguration createTaskConfigurationInstance(String typeId) {
        return this.taskScheduler.createTaskConfigurationInstance(typeId);
    }
}

