/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.internal.resources;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.rest.Page;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.api.TaskXO;
import org.sonatype.nexus.scheduling.internal.resources.doc.TasksApiResourceDoc;

@FeatureFlag(name="nexus.datastore.clustered.enabled", inverse=true, enabledByDefault=true)
@Named
@Singleton
@Path(value="/v1/tasks")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class TasksApiResource
extends ComponentSupport
implements Resource,
TasksApiResourceDoc {
    public static final String RESOURCE_URI = "/v1/tasks";
    private static final String TRIGGER_SOURCE = "REST API";
    private final TaskScheduler taskScheduler;

    @Inject
    public TasksApiResource(TaskScheduler taskScheduler) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
    }

    @Override
    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tasks:read"})
    public Page<TaskXO> getTasks(@QueryParam(value="type") String type) {
        List taskXOs = this.taskScheduler.listsTasks().stream().filter(taskInfo -> taskInfo.getConfiguration().isVisible()).filter(taskInfo -> TasksApiResource.typeParameterMatches(type, taskInfo)).map(taskInfo -> TaskXO.fromTaskInfo(taskInfo, this.taskScheduler.toExternalTaskState((TaskInfo)taskInfo))).collect(Collectors.toList());
        return new Page(taskXOs, null);
    }

    @Override
    @GET
    @Path(value="/{id}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tasks:read"})
    public TaskXO getTaskById(@PathParam(value="id") String id) {
        TaskInfo task = this.getTaskInfo(id);
        return TaskXO.fromTaskInfo(task, this.taskScheduler.toExternalTaskState(task));
    }

    @Override
    @POST
    @Path(value="/{id}/run")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tasks:start"})
    public void run(@PathParam(value="id") String id) {
        try {
            TaskInfo taskInfo = this.getTaskInfo(id);
            if (!taskInfo.getConfiguration().isEnabled()) {
                throw new NotAllowedException(String.format("Task %s is disabled", id), new String[0]);
            }
            taskInfo.runNow(TRIGGER_SOURCE);
        }
        catch (NotAllowedException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("error running task with id {}", (Object)id, (Object)e);
            throw new WebApplicationException(String.format("Error running task %s", id), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Override
    @POST
    @Path(value="/{id}/stop")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:tasks:stop"})
    public void stop(@PathParam(value="id") String id) {
        try {
            TaskInfo taskInfo = this.getTaskInfo(id);
            Future<?> taskFuture = taskInfo.getCurrentState().getFuture();
            if (taskFuture == null) {
                throw new WebApplicationException(String.format("Task %s is not running", id), Response.Status.CONFLICT);
            }
            if (!taskFuture.cancel(false)) {
                throw new WebApplicationException(String.format("Unable to stop task %s", id), Response.Status.CONFLICT);
            }
        }
        catch (WebApplicationException webApplicationException) {
            throw webApplicationException;
        }
        catch (Exception e) {
            this.log.error("error stopping task with id {}", (Object)id, (Object)e);
            throw new WebApplicationException(String.format("Error running task %s", id), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private TaskInfo getTaskInfo(String id) {
        return Optional.ofNullable(this.taskScheduler.getTaskById(id)).filter(taskInfo -> taskInfo.getConfiguration().isVisible()).orElseThrow(() -> new NotFoundException("Unable to locate task with id " + id));
    }

    private static boolean typeParameterMatches(String type, TaskInfo taskInfo) {
        return type == null || type.isEmpty() || type.equals(taskInfo.getTypeId());
    }
}

