/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.constraints;

import com.google.common.base.Preconditions;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintValidatorContext;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.constraints.CronExpression;
import org.sonatype.nexus.scheduling.schedule.ScheduleFactory;
import org.sonatype.nexus.validation.ConstraintValidatorSupport;

@Named
public class CronExpressionValidator
extends ConstraintValidatorSupport<CronExpression, String> {
    private final ScheduleFactory scheduleFactory;

    @Inject
    public CronExpressionValidator(TaskScheduler taskScheduler) {
        Preconditions.checkNotNull((Object)taskScheduler);
        this.scheduleFactory = taskScheduler.getScheduleFactory();
    }

    public void initialize(CronExpression annotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        try {
            this.scheduleFactory.cron(new Date(), value);
        }
        catch (IllegalArgumentException e) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.getEscapeHelper().stripJavaEl(e.getMessage())).addConstraintViolation();
            return false;
        }
        return true;
    }
}

