/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling.api;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.scheduling.ExternalTaskState;
import org.sonatype.nexus.scheduling.TaskInfo;

public class TaskXO {
    private String id;
    private String name;
    private String type;
    private String message;
    private String currentState;
    private String lastRunResult;
    private Date nextRun;
    private Date lastRun;

    public static TaskXO fromTaskInfo(TaskInfo taskInfo, ExternalTaskState externalTaskState) {
        TaskXO taskXO = new TaskXO();
        taskXO.setId(taskInfo.getId());
        taskXO.setName(taskInfo.getName());
        taskXO.setType(taskInfo.getTypeId());
        taskXO.setMessage(taskInfo.getMessage());
        if (externalTaskState.getState().isRunning() && StringUtils.isNotBlank((CharSequence)externalTaskState.getProgress())) {
            taskXO.setCurrentState(String.valueOf(externalTaskState.getState().toString()) + ": " + externalTaskState.getProgress());
        } else {
            taskXO.setCurrentState(externalTaskState.getState().toString());
        }
        taskXO.setNextRun(taskInfo.getCurrentState().getNextRun());
        if (externalTaskState.getLastEndState() != null) {
            taskXO.setLastRunResult(externalTaskState.getLastEndState().toString());
        }
        taskXO.setLastRun(externalTaskState.getLastRunStarted());
        return taskXO;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(String currentState) {
        this.currentState = currentState;
    }

    public String getLastRunResult() {
        return this.lastRunResult;
    }

    public void setLastRunResult(String lastRunResult) {
        this.lastRunResult = lastRunResult;
    }

    public Date getNextRun() {
        return this.nextRun;
    }

    public void setNextRun(Date nextRun) {
        this.nextRun = nextRun;
    }

    public Date getLastRun() {
        return this.lastRun;
    }

    public void setLastRun(Date lastRun) {
        this.lastRun = lastRun;
    }

    public String toString() {
        return "TaskXO(id:'" + this.id + '\'' + ", name:'" + this.name + '\'' + ", type:'" + this.type + '\'' + ", message:'" + this.message + '\'' + ", currentState:'" + this.currentState + '\'' + ", lastRunResult:'" + this.lastRunResult + '\'' + ", nextRun:" + this.nextRun + ", lastRun:" + this.lastRun + ')';
    }
}

