/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.spi.TaskResultStateStore;

@Named
@Singleton
public class TaskUtils
extends ComponentSupport {
    private final Provider<TaskScheduler> taskSchedulerProvider;
    private final TaskResultStateStore taskResultStateStore;

    @Inject
    public TaskUtils(Provider<TaskScheduler> taskSchedulerProvider, TaskResultStateStore taskResultStateStoreProvider) {
        this.taskSchedulerProvider = (Provider)Preconditions.checkNotNull(taskSchedulerProvider);
        this.taskResultStateStore = taskResultStateStoreProvider;
    }

    public void checkForConflictingTasks(String taskId, String taskName, List<String> conflictingTypeIds, Map<String, List<String>> conflictingConfiguration) {
        Set incompatibleTasks = ((TaskScheduler)this.taskSchedulerProvider.get()).listsTasks().stream().filter(taskInfo -> this.isConflictingTask(taskId, (TaskInfo)taskInfo, conflictingTypeIds, conflictingConfiguration)).collect(Collectors.toSet());
        String names = incompatibleTasks.stream().map(TaskInfo::getName).collect(Collectors.joining(","));
        if (!incompatibleTasks.isEmpty()) {
            throw new IllegalStateException("Cannot start task '" + taskName + "' there is at least one other task (" + names + ") running that is conflicting, please restart this task once the other(s) complete.");
        }
    }

    private boolean isConflictingTask(String currentTaskId, TaskInfo taskInfo, List<String> conflictingTypeIds, Map<String, List<String>> conflictingConfiguration) {
        if (!conflictingTypeIds.contains(taskInfo.getTypeId())) {
            return false;
        }
        if (currentTaskId.equals(taskInfo.getId())) {
            return false;
        }
        if (!this.isTaskRunning(taskInfo)) {
            return false;
        }
        return conflictingConfiguration.entrySet().stream().anyMatch(entry -> ((List)entry.getValue()).contains(taskInfo.getConfiguration().getString((String)entry.getKey())));
    }

    private boolean isTaskRunning(TaskInfo taskInfo) {
        if (this.taskResultStateStore.isSupported()) {
            this.log.debug("Checking state store for status of {}", (Object)taskInfo.getId());
            return this.taskResultStateStore.getState(taskInfo).map(state -> state.getState().isRunning()).orElse(false);
        }
        return taskInfo.getCurrentState().getState().isRunning();
    }
}

