/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

public enum TaskState {
    WAITING(Group.WAITING, "Waiting"),
    RUNNING_STARTING(Group.RUNNING, "Starting"),
    RUNNING_BLOCKED(Group.RUNNING, "Blocked"),
    RUNNING(Group.RUNNING, "Running"),
    RUNNING_CANCELED(Group.RUNNING, "Canceled"),
    OK(Group.DONE, "Done"),
    FAILED(Group.DONE, "Done - Failed"),
    CANCELED(Group.DONE, "Done - Canceled"),
    INTERRUPTED(Group.DONE, "Done - Interrupted");

    private final Group group;
    private final String description;

    private TaskState(Group group, String description) {
        this.group = group;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isIn(Group group) {
        return this.group == group;
    }

    public boolean isWaiting() {
        return this.isIn(Group.WAITING);
    }

    public boolean isRunning() {
        return this.isIn(Group.RUNNING);
    }

    public boolean isDone() {
        return this.isIn(Group.DONE);
    }

    public static enum Group {
        WAITING,
        RUNNING,
        DONE;

    }
}

