/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.scheduling.CurrentState;
import org.sonatype.nexus.scheduling.LastRunState;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.TaskState;
import org.sonatype.nexus.scheduling.schedule.Schedule;
import org.sonatype.nexus.scheduling.schedule.ScheduleDeserializer;
import org.sonatype.nexus.scheduling.schedule.ScheduleSerializer;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportTaskData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="taskExport")
@Singleton
public class TaskExport
extends JsonExporter
implements ExportConfigData,
ImportTaskData {
    private final TaskScheduler taskScheduler;

    @Inject
    public TaskExport(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export Tasks data to {}", (Object)file);
        List<TaskInfo> tasks = this.taskScheduler.listsTasks();
        this.exportToJson(tasks, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring Tasks data from {}", (Object)file);
        List<TaskInfo> defaultTasks = this.taskScheduler.listsTasks();
        defaultTasks.forEach(TaskInfo::remove);
        List tasks = this.importFromJson(file, TaskInfoData.class);
        tasks.forEach(task -> {
            TaskInfo taskInfo = this.taskScheduler.scheduleTask(task.getConfiguration(), task.getSchedule());
        });
    }

    public static class CurrentStateData
    implements CurrentState {
        private TaskState state;
        private Date nextRun;

        @Override
        public TaskState getState() {
            return this.state;
        }

        @Override
        public Date getNextRun() {
            return this.nextRun;
        }

        @Override
        public Date getRunStarted() {
            return null;
        }

        @Override
        public TaskState getRunState() {
            return null;
        }

        @Override
        public Future<?> getFuture() {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TaskInfoData
    implements TaskInfo {
        private TaskConfiguration configuration;
        @JsonSerialize(using=ScheduleSerializer.class)
        @JsonDeserialize(using=ScheduleDeserializer.class)
        private Schedule schedule;
        private Object lastResult;
        private final Map<String, Object> context = new HashMap<String, Object>();

        @Override
        public String getId() {
            return this.configuration.getId();
        }

        @Override
        public String getName() {
            return this.configuration.getName();
        }

        @Override
        public String getTypeId() {
            return this.configuration.getTypeId();
        }

        @Override
        public String getMessage() {
            return this.configuration.getMessage();
        }

        @Override
        public TaskConfiguration getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(TaskConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public Schedule getSchedule() {
            return this.schedule;
        }

        public void setSchedule(Schedule schedule) {
            this.schedule = schedule;
        }

        @Override
        public CurrentState getCurrentState() {
            return new CurrentStateData();
        }

        @Override
        public Object getLastResult() {
            return this.lastResult;
        }

        @Override
        public LastRunState getLastRunState() {
            return this.configuration.getLastRunState();
        }

        @Override
        public boolean remove() {
            return true;
        }

        @Override
        public TaskInfo runNow(String triggerSource) {
            return this;
        }

        @Override
        public String getTriggerSource() {
            return null;
        }

        @Override
        public Map<String, Object> getContext() {
            return this.context;
        }
    }
}

