/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.scheduling;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonatype.nexus.scheduling.LastRunState;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskState;

public class ExternalTaskState {
    private final TaskState state;
    private final TaskState lastEndState;
    private final Date lastRunStarted;
    private final Long lastRunDuration;
    private final Date nextFireTime;
    private final String progress;

    public ExternalTaskState(TaskState state, Date nextFireTime, @Nullable TaskState lastEndState, @Nullable Date lastRunStarted, @Nullable Long lastRunDuration, @Nullable String progress) {
        this.state = (TaskState)((Object)Preconditions.checkNotNull((Object)((Object)state)));
        this.nextFireTime = nextFireTime;
        this.lastEndState = lastEndState;
        this.lastRunStarted = lastRunStarted;
        this.lastRunDuration = lastRunDuration;
        this.progress = progress;
    }

    public ExternalTaskState(TaskInfo taskInfo) {
        this(taskInfo.getCurrentState().getState(), taskInfo.getCurrentState().getNextRun(), Optional.ofNullable(taskInfo.getLastRunState()).map(LastRunState::getEndState).orElse(null), Optional.ofNullable(taskInfo.getLastRunState()).map(LastRunState::getRunStarted).orElse(null), Optional.ofNullable(taskInfo.getLastRunState()).map(LastRunState::getRunDuration).orElse(null), taskInfo.getConfiguration().getProgress());
    }

    public Date getNextFireTime() {
        return this.nextFireTime;
    }

    public TaskState getState() {
        return this.state;
    }

    @Nullable
    public TaskState getLastEndState() {
        return this.lastEndState;
    }

    @Nullable
    public Date getLastRunStarted() {
        return this.lastRunStarted;
    }

    @Nullable
    public Long getLastRunDuration() {
        return this.lastRunDuration;
    }

    @Nullable
    public String getProgress() {
        return this.progress;
    }
}

