/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.bower.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.bower.internal.BowerFacetUtils;
import org.sonatype.nexus.repository.bower.internal.BowerResolver;

@Named
@Singleton
public class NexusBowerResolver
extends ComponentSupport
implements BowerResolver {
    private static final Pattern URL_PATTERN = Pattern.compile("nexus\\+(http|https)://([^/\\s]+?)(/[^/\\s]+?)?/repository/([^/\\s]+?)/([^/\\s]+?)", 2);

    @Override
    public boolean canHandle(String packageUrl) {
        Preconditions.checkNotNull((Object)packageUrl);
        return URL_PATTERN.matcher(packageUrl).matches();
    }

    @Override
    public String getVersionsUrl(String packageUrl, String pkg) {
        Preconditions.checkNotNull((Object)packageUrl);
        Preconditions.checkNotNull((Object)pkg);
        if (this.canHandle(packageUrl)) {
            return String.valueOf(packageUrl.substring(6)) + "/versions.json";
        }
        throw new IllegalStateException();
    }

    @Override
    public String getTarballUrl(String packageUrl, String pkg, String version) {
        Preconditions.checkNotNull((Object)packageUrl);
        Preconditions.checkNotNull((Object)pkg);
        if (this.canHandle(packageUrl)) {
            return String.valueOf(packageUrl.substring(6)) + "/" + version + "/package.tar.gz";
        }
        throw new IllegalStateException();
    }

    @Override
    public Collection<String> getVersions(InputStreamSupplier contentSupplier) throws IOException {
        Preconditions.checkNotNull((Object)contentSupplier);
        TypeReference<List<String>> typeRef = new TypeReference<List<String>>(){};
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = contentSupplier.get();){
            return (Collection)BowerFacetUtils.mapper.readValue(in, (TypeReference)typeRef);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

