/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.orient.internal.importtask;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.RepositoryImportHelper;
import com.sonatype.nexus.exportimport.internal.ExportImportFeature;
import com.sonatype.nexus.exportimport.internal.FilenameUtil;
import com.sonatype.nexus.exportimport.internal.importtask.ImportDeltaFileService;
import com.sonatype.nexus.exportimport.internal.importtask.ImportTagsService;
import com.sonatype.nexus.exportimport.internal.importtask.ImportValidation;
import com.sonatype.nexus.exportimport.internal.importtask.RepositoryImportService;
import com.sonatype.nexus.exportimport.internal.importtask.RepositoryImportSource;
import com.sonatype.nexus.exportimport.model.AssetFileAttributes;
import com.sonatype.nexus.exportimport.model.AssetFileAttributesNX2;
import com.sonatype.nexus.exportimport.orient.internal.importtask.OrientImportAttributesService;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.importtask.ImportResult;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.upload.UploadManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.security.ClientInfoProvider;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Priority(value=0x7FFFFFFF)
public class OrientRepositoryImportService
extends ComponentSupport
implements RepositoryImportService {
    private final UploadManager uploadManager;
    private final LicenseFeatureVerifier licenseFeatureVerifier;
    private final ExportImportFeature exportImportFeature;
    private final RepositoryManager repositoryManager;
    private final ImportDeltaFileService importDeltaFileService;
    private final List<ImportValidation> importValidations;
    private final OrientImportAttributesService importAttributesService;
    private final ImportTagsService importTagsService;
    private final FilenameUtil filenameUtil;
    private final ClientInfoProvider clientInfoProvider;
    private final boolean skipArtifactoryMetadata;

    @Inject
    public OrientRepositoryImportService(UploadManager uploadManager, ExportImportFeature exportImportFeature, LicenseFeatureVerifier licenseFeatureVerifier, RepositoryManager repositoryManager, ImportDeltaFileService importDeltaFileService, OrientImportAttributesService importAttributesService, List<ImportValidation> importValidations, ImportTagsService importTagsService, FilenameUtil filenameUtil, ClientInfoProvider clientInfoProvider, @Named(value="${nexus.import.skipartifactorymetadata:-true}") @Named(value="${nexus.import.skipartifactorymetadata:-true}") boolean skipArtifactoryMetadata) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.uploadManager = (UploadManager)Preconditions.checkNotNull((Object)uploadManager);
        this.exportImportFeature = (ExportImportFeature)((Object)Preconditions.checkNotNull((Object)((Object)exportImportFeature)));
        this.licenseFeatureVerifier = (LicenseFeatureVerifier)Preconditions.checkNotNull((Object)licenseFeatureVerifier);
        this.importDeltaFileService = (ImportDeltaFileService)((Object)Preconditions.checkNotNull((Object)((Object)importDeltaFileService)));
        this.importAttributesService = (OrientImportAttributesService)((Object)Preconditions.checkNotNull((Object)((Object)importAttributesService)));
        this.importValidations = (List)Preconditions.checkNotNull(importValidations);
        this.importTagsService = (ImportTagsService)((Object)Preconditions.checkNotNull((Object)((Object)importTagsService)));
        this.filenameUtil = (FilenameUtil)Preconditions.checkNotNull((Object)filenameUtil);
        this.clientInfoProvider = (ClientInfoProvider)Preconditions.checkNotNull((Object)clientInfoProvider);
        this.skipArtifactoryMetadata = skipArtifactoryMetadata;
    }

    @Override
    public void doImport(String sourceDirectory, String repositoryName, Integer batchSize, boolean hardLinkEnabled, BooleanSupplier shouldStopFunction) {
        Repository repository = this.repositoryManager.get(repositoryName);
        try {
            if (!this.licenseFeatureVerifier.verify((Feature)this.exportImportFeature)) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Repository import is not licensed!");
            } else if (repository == null) {
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Repository {} not found, can't perform import.", (Object)repositoryName);
            } else {
                RepositoryImportSource source = new RepositoryImportSource(sourceDirectory);
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Checking prerequisites for import of {} into repository {}", (Object)source, (Object)repositoryName);
                if (this.prerequisitesMet(source, repository, hardLinkEnabled)) {
                    this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Import tags from export");
                    this.importTagsService.importTags(new File(sourceDirectory, ".nexus"));
                    this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Starting import of {} into repository {}", (Object)source, (Object)repositoryName);
                    this.log.debug("Import batch size set to: {}", (Object)batchSize);
                    this.walkImportDirectory(source, repository, batchSize, hardLinkEnabled, shouldStopFunction);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Import of %s into repository %s failed", sourceDirectory, repositoryName), e);
        }
    }

    private void walkImportDirectory(RepositoryImportSource source, Repository repository, int batchSize, boolean hardLinkEnabled, BooleanSupplier shouldStopFunction) throws IOException {
        ImportResult importResult = new ImportResult(repository, new ArrayList());
        source.walk(input -> {
            if (shouldStopFunction.getAsBoolean()) {
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Task cancelled, stopping processing");
                return FileVisitResult.TERMINATE;
            }
            if (importResult.getFileAssets().size() > batchSize - 1) {
                try {
                    this.uploadManager.handleAfterImport(importResult);
                    importResult.getFileAssets().clear();
                    this.log.debug("Batch cleared");
                }
                catch (IOException iOException) {
                    this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Error during batch processing");
                }
            }
            File file = input.toAbsolutePath().toFile();
            String filePath = RepositoryImportHelper.parseFilePath(file.getAbsolutePath(), source.path());
            String assetName = this.filenameUtil.filePathToAssetName(filePath);
            File attributes = new File(source.path(), ".nexus/" + filePath);
            try {
                if (!RepositoryImportHelper.isFileImportable(file, this.skipArtifactoryMetadata)) {
                    this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping {} because it is either a configuration file, a hidden file or a directory.", (Object)file.getAbsolutePath());
                    FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                    return fileVisitResult;
                }
                if (this.importDeltaFileService.isAlreadyInDeltaFile(file, attributes, RepositoryImportHelper.getLastUpdatedTimestamp(file))) {
                    this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping {} as it has already been imported.", (Object)file.getAbsolutePath());
                    FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                    return fileVisitResult;
                }
                try {
                    this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Importing {}", (Object)file.getAbsolutePath());
                    AssetFileAttributesNX2 fileAttributesNx2 = this.importAttributesService.getImportFileAttributesNx2(file, source.path());
                    AssetFileAttributes fileAttributesNx3 = this.importAttributesService.getImportFileAttributesNx3(file, source.path());
                    if (fileAttributesNx3 != null) {
                        String createdByIp = fileAttributesNx3.getCreatedByIP();
                        String createdBy = fileAttributesNx3.getCreatedBy();
                        if (createdByIp == null || createdBy == null) {
                            this.log.warn("Client information is not available for this asset {}, using default values", (Object)fileAttributesNx3.getAssetName());
                            createdByIp = createdByIp == null ? "127.0.0.1" : createdByIp;
                            createdBy = createdBy == null ? "system" : createdBy;
                        }
                        this.clientInfoProvider.setClientInfo(createdByIp, createdBy);
                    }
                    TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).throwing(IOException.class).run(() -> {
                        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                        Content content = this.uploadManager.handle(new ImportFileConfiguration(repository, file, assetName, hardLinkEnabled));
                        if (content != null) {
                            Asset asset = (Asset)content.getAttributes().get(Asset.class);
                            this.importAttributesService.importAttributes(fileAttributesNx3, fileAttributesNx2, asset, repository, tx);
                        }
                        this.importDeltaFileService.appendToDeltaFile(file, attributes, RepositoryImportHelper.getLastUpdatedTimestamp(file));
                        importResult.getFileAssets().add(new ImportResult.FileAsset(file, assetName));
                    });
                }
                catch (Exception e) {
                    importResult.getFileAssets().add(new ImportResult.FileAsset(file, assetName));
                    this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Import of file {} into repository {} failed", new Object[]{file, repository.getName(), e});
                }
            }
            finally {
                this.clientInfoProvider.unsetClientInfo();
            }
            return FileVisitResult.CONTINUE;
        });
        if (shouldStopFunction.getAsBoolean()) {
            this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Task cancelled, stopping processing");
            return;
        }
        this.uploadManager.handleAfterImport(importResult);
    }

    private boolean prerequisitesMet(RepositoryImportSource source, Repository repository, boolean hardLinkEnabled) {
        return this.importValidations.stream().allMatch(prereq -> prereq.check(source, repository, hardLinkEnabled));
    }
}

