/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.orient.internal.importtask;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.ObjectMapperProvider;
import com.sonatype.nexus.exportimport.RepositoryImportHelper;
import com.sonatype.nexus.exportimport.model.AssetFileAttributes;
import com.sonatype.nexus.exportimport.model.AssetFileAttributesNX2;
import com.sonatype.nexus.tags.service.TagService;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportPostProcessor;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageTx;

@Named
@Singleton
public class OrientImportAttributesService
extends ComponentSupport {
    private static final String CHECKSUM_ATTRIBUTE = "checksum";
    private final ObjectMapper objectMapper;
    private final TagService tagService;
    private final Map<String, ImportPostProcessor> importAdditionalAttributeProcessors;

    @Inject
    public OrientImportAttributesService(TagService tagService, ObjectMapperProvider objectMapperProvider, Map<String, ImportPostProcessor> importAdditionalAttributeProcessors) {
        this.tagService = (TagService)Preconditions.checkNotNull((Object)tagService);
        this.importAdditionalAttributeProcessors = (Map)Preconditions.checkNotNull(importAdditionalAttributeProcessors);
        this.objectMapper = ((ObjectMapperProvider)Preconditions.checkNotNull((Object)objectMapperProvider)).get();
    }

    public void importAttributes(String sourceDirectory, File currentUpload, Asset asset, Repository repository, StorageTx tx) {
        AssetFileAttributesNX2 importFileAttributesNx2 = this.getImportFileAttributesNx2(currentUpload, sourceDirectory);
        AssetFileAttributes importFileAttributesNx3 = this.getImportFileAttributesNx3(currentUpload, sourceDirectory);
        this.importAttributes(importFileAttributesNx3, importFileAttributesNx2, asset, repository, tx);
    }

    public void importAttributes(@Nullable AssetFileAttributes importFileAttributesNx3, @Nullable AssetFileAttributesNX2 importFileAttributesNx2, Asset asset, Repository repository, StorageTx tx) {
        if (importFileAttributesNx2 != null) {
            this.updateAsset(importFileAttributesNx2, asset, tx);
        } else if (importFileAttributesNx3 != null) {
            this.updateAssetAndComponent(importFileAttributesNx3, asset, repository, tx);
        }
        ImportPostProcessor importPostProcessor = this.importAdditionalAttributeProcessors.get(repository.getFormat().toString());
        if (importPostProcessor != null) {
            importPostProcessor.attributePostProcessing(asset, tx, repository);
        }
    }

    private static String getValidSourceDirectory(String sourceDirectory) {
        return sourceDirectory.endsWith(File.separator) ? sourceDirectory : String.valueOf(sourceDirectory) + File.separator;
    }

    public AssetFileAttributes getImportFileAttributesNx3(File file, String sourceDirectory) {
        String validSourceDirectory = OrientImportAttributesService.getValidSourceDirectory(sourceDirectory);
        File attributesFile = new File(RepositoryImportHelper.toAttributePath(file.getAbsolutePath(), validSourceDirectory));
        if (attributesFile.exists()) {
            try {
                return (AssetFileAttributes)this.objectMapper.readValue(attributesFile, AssetFileAttributes.class);
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "error reading NXRM 3 attributes file {}", (Object)attributesFile.getAbsolutePath(), (Object)e);
                }
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "error reading NXRM 3 attributes file {}: {}", (Object)attributesFile.getAbsolutePath(), (Object)e.getMessage());
            }
        }
        return null;
    }

    public AssetFileAttributesNX2 getImportFileAttributesNx2(File file, String sourceDirectory) {
        String validSourceDirectory = OrientImportAttributesService.getValidSourceDirectory(sourceDirectory);
        File attributesFile = new File(RepositoryImportHelper.toNxrm2AttributePath(file.getAbsolutePath(), validSourceDirectory));
        if (attributesFile.exists()) {
            try {
                return (AssetFileAttributesNX2)this.objectMapper.readValue(attributesFile, AssetFileAttributesNX2.class);
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "error reading NXRM 2 attributes file {}", (Object)attributesFile.getAbsolutePath(), (Object)e);
                }
                this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "error reading NXRM 2 attributes file {}: {}", (Object)attributesFile.getAbsolutePath(), (Object)e.getMessage());
            }
        }
        return null;
    }

    private void updateAsset(AssetFileAttributesNX2 importFileAttributesNX2, Asset asset, StorageTx storageTx) {
        boolean touched = false;
        NestedAttributesMap contentAttributes = asset.attributes().child("content");
        if (importFileAttributesNX2.getCreated() != null) {
            asset.blobCreated(new DateTime((Object)importFileAttributesNX2.getCreated()));
            touched = true;
        }
        if (importFileAttributesNX2.getModified() != null) {
            asset.blobUpdated(new DateTime((Object)importFileAttributesNX2.getModified()));
            contentAttributes.set("last_modified", (Object)new Date(importFileAttributesNX2.getModified()));
            touched = true;
        }
        if (importFileAttributesNX2.getLastRequested() != null) {
            asset.lastDownloaded(new DateTime((Object)importFileAttributesNX2.getLastRequested()));
            touched = true;
        }
        if (touched) {
            storageTx.saveAsset(asset);
        }
    }

    private void updateAssetAndComponent(AssetFileAttributes importFileAttributes, Asset asset, Repository repository, StorageTx tx) {
        boolean assetTouched = false;
        Map<String, Object> assetAttributes = importFileAttributes.getAssetAttributes();
        if (assetAttributes != null) {
            asset.attributes(this.getAssetAttributes(asset, assetAttributes));
            assetTouched = true;
        } else {
            this.log.warn(TaskLoggingMarkers.TASK_LOG_ONLY, "Not applying asset attributes, they could not be located.");
        }
        if (importFileAttributes.getCreatedTimestamp() != null) {
            asset.blobCreated(new DateTime((Object)importFileAttributes.getCreatedTimestamp()));
            assetTouched = true;
        }
        if (importFileAttributes.getLastUpdatedTimestamp() != null) {
            asset.blobUpdated(new DateTime((Object)importFileAttributes.getLastUpdatedTimestamp()));
            assetTouched = true;
        }
        if (importFileAttributes.getLastDownloadedTimestamp() != null) {
            asset.lastDownloaded(new DateTime((Object)importFileAttributes.getLastDownloadedTimestamp()));
            assetTouched = true;
        }
        if (Objects.nonNull(importFileAttributes.getCreatedBy())) {
            asset.createdBy(importFileAttributes.getCreatedBy());
            assetTouched = true;
        }
        if (Objects.nonNull(importFileAttributes.getCreatedByIP())) {
            asset.createdByIp(importFileAttributes.getCreatedByIP());
            assetTouched = true;
        }
        if (assetTouched) {
            tx.saveAsset(asset);
        }
        if (asset.componentId() != null) {
            List<String> componentTags;
            Component component = tx.findComponent(asset.componentId());
            if (component == null) {
                this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Component related to the asset with EntityId {} not found", (Object)asset.componentId());
                return;
            }
            Map<String, Object> componentAttributes = importFileAttributes.getComponentAttributes();
            if (componentAttributes != null) {
                NestedAttributesMap attrMap = new NestedAttributesMap("attributes", componentAttributes);
                if (component.attributes().size() == 0) {
                    component.attributes(attrMap);
                    tx.saveComponent(component);
                }
            } else {
                this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Not applying component attributes for this component, they could not be located.");
            }
            if ((componentTags = importFileAttributes.getComponentTags()) != null) {
                this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Found {} tags associated to component {}", (Object)componentTags.size(), (Object)component);
                componentTags.forEach(tag -> {
                    if (this.tagService.get(tag) == null) {
                        this.log.error("{} is assigned a tag that is not yet created {}, skipping assignment", (Object)importFileAttributes.getAssetName(), tag);
                    } else {
                        this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Found tag {}, associating to component {}", tag, (Object)component);
                        this.tagService.associateById(tag, repository, component.getEntityMetadata().getId());
                    }
                });
            } else {
                this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Not applying component tag associations for this asset, they could not be located.");
            }
        } else {
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Asset {} did not have a componentId", (Object)asset.name());
        }
    }

    private NestedAttributesMap getAssetAttributes(Asset asset, Map<String, Object> assetAttributes) {
        if (assetAttributes.get(CHECKSUM_ATTRIBUTE) == null) {
            Object checksum;
            Object object = checksum = asset.attributes() == null ? null : asset.attributes().get(CHECKSUM_ATTRIBUTE);
            if (checksum != null) {
                assetAttributes.put(CHECKSUM_ATTRIBUTE, checksum);
            }
        }
        return new NestedAttributesMap("attributes", assetAttributes);
    }
}

