/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.importtask;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.RepositoryImportHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.function.Function;
import org.sonatype.goodies.common.ComponentSupport;

public class RepositoryImportSource
extends ComponentSupport {
    private final String sourceDirectory;

    public RepositoryImportSource(String sourceDirectory) {
        this.sourceDirectory = (String)Preconditions.checkNotNull((Object)sourceDirectory);
    }

    public void walk(Function<Path, FileVisitResult> func) throws IOException {
        File file = new File(this.sourceDirectory);
        if (!file.isDirectory()) {
            this.log.error("Can't import {}: not a directory", (Object)file);
        } else {
            Files.walkFileTree(file.toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, new RepositoryImportFileVisitor(func, this.sourceDirectory));
        }
    }

    public String path() {
        return this.sourceDirectory;
    }

    public String toString() {
        return this.sourceDirectory;
    }

    private static class RepositoryImportFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Function<Path, FileVisitResult> func;
        private final String baseDirectory;

        RepositoryImportFileVisitor(Function<Path, FileVisitResult> func, String baseDirectory) {
            this.func = (Function)Preconditions.checkNotNull(func);
            this.baseDirectory = (String)Preconditions.checkNotNull((Object)baseDirectory);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            String relativePath = RepositoryImportHelper.parseFilePath(dir.toAbsolutePath().toString(), this.baseDirectory);
            if (relativePath.startsWith(".") || relativePath.contains("/.")) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return super.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            return this.func.apply(path);
        }
    }
}

