/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.exporttask.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.exportimport.datastore.ExportAttributesService;
import com.sonatype.nexus.exportimport.internal.ExportImportFeature;
import com.sonatype.nexus.exportimport.internal.FilenameUtil;
import com.sonatype.nexus.exportimport.internal.exporttask.ExportDeltaFileService;
import com.sonatype.nexus.exportimport.internal.exporttask.ExportTagsService;
import com.sonatype.nexus.exportimport.internal.exporttask.ExportValidation;
import com.sonatype.nexus.exportimport.internal.exporttask.InstanceDetailsExportService;
import com.sonatype.nexus.exportimport.internal.exporttask.RepositoryExportServiceSupport;
import java.io.File;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.time.DateHelper;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.export.ExportAssetFilter;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
public class RepositoryExportServiceImpl
extends RepositoryExportServiceSupport {
    private final ExportAttributesService exportAttributesService;
    private final ExportDeltaFileService exportDeltaFileService;
    private final int pageSize;
    private final Map<String, ExportAssetFilter> exportAssetFilters;
    private final FilenameUtil filenameUtil;

    @Inject
    public RepositoryExportServiceImpl(LicenseFeatureVerifier licenseFeatureVerifier, ExportImportFeature exportImportFeature, ExportAttributesService exportAttributesService, InstanceDetailsExportService instanceDetailsExportService, RepositoryManager repositoryManager, ExportDeltaFileService exportDeltaFileService, List<ExportValidation> exportValidations, @Named(value="${nexus.export.assetPageSize:-1000}") @Named(value="${nexus.export.assetPageSize:-1000}") int pageSize, ExportTagsService exportTagsService, Map<String, ExportAssetFilter> exportAssetFilters, FilenameUtil filenameUtil) {
        super(licenseFeatureVerifier, exportImportFeature, repositoryManager, exportDeltaFileService, instanceDetailsExportService, exportValidations, exportTagsService);
        this.exportDeltaFileService = (ExportDeltaFileService)((Object)Preconditions.checkNotNull((Object)((Object)exportDeltaFileService)));
        this.exportAttributesService = (ExportAttributesService)((Object)Preconditions.checkNotNull((Object)((Object)exportAttributesService)));
        this.pageSize = pageSize;
        this.exportAssetFilters = exportAssetFilters;
        this.filenameUtil = (FilenameUtil)Preconditions.checkNotNull((Object)filenameUtil);
    }

    @Override
    protected void walkAssets(Repository repository, String targetDirectory, BooleanSupplier shouldStopFunction, BiPredicate<OffsetDateTime, OffsetDateTime> notRecentlyUsedFilter) {
        File baseDirectory = new File(targetDirectory);
        FluentAssets assets = ((ContentFacet)repository.facet(ContentFacet.class)).assets();
        Continuation nextPage = assets.browse(this.pageSize, null);
        while (!nextPage.isEmpty()) {
            if (!this.walkPage(repository, (Continuation<FluentAsset>)nextPage, baseDirectory, shouldStopFunction, this.convert(notRecentlyUsedFilter))) break;
            nextPage = assets.browse(this.pageSize, nextPage.nextContinuationToken());
        }
    }

    private boolean walkPage(Repository repository, Continuation<FluentAsset> assets, File baseDirectory, BooleanSupplier shouldStopFunction, Predicate<FluentAsset> notRecentlyUsedFilter) {
        for (FluentAsset asset : assets) {
            if (shouldStopFunction.getAsBoolean()) {
                this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Task cancelled, stopping processing");
                return false;
            }
            String repositoryFormat = repository.getFormat().toString();
            ExportAssetFilter exportAssetFilter = this.exportAssetFilters.get(repositoryFormat);
            String exportAssetPath = asset.path();
            if (exportAssetFilter != null) {
                exportAssetPath = exportAssetFilter.getAssetExportPath(asset);
            }
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Asset Export Path: {}", (Object)exportAssetPath);
            String validFilename = this.filenameUtil.assetNameToFilePath(exportAssetPath);
            File target = new File(baseDirectory, validFilename);
            File attributes = new File(baseDirectory, ".nexus/" + validFilename);
            if (!notRecentlyUsedFilter.test(asset)) {
                this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Asset {} recently used skipping.", (Object)exportAssetPath);
                continue;
            }
            if (this.exportDeltaFileService.isAlreadyInDeltaFile(target, attributes, this.lastUpdated((Asset)asset).getMillis())) {
                this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping {} as it has already been exported.", (Object)target);
                continue;
            }
            if (exportAssetFilter != null && exportAssetFilter.shouldSkipAsset(asset)) {
                this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping {}.", (Object)exportAssetPath);
                continue;
            }
            this.exportAsset(repository, asset, target, attributes);
            if (exportAssetFilter != null && exportAssetFilter.shouldSkipAttributes(asset)) {
                this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Skipping Attribute {}.", (Object)exportAssetPath);
                continue;
            }
            this.exportAttributesService.exportAttributes(attributes, asset);
        }
        return true;
    }

    private void exportAsset(Repository repository, FluentAsset asset, File target, File attributes) {
        asset.blob().ifPresent(blob -> this.exportBlob(repository, target, attributes, blob.blobRef(), asset.path(), DateHelper.toDateTime((OffsetDateTime)blob.blobCreated())));
    }

    @Override
    protected Optional<Blob> getBlob(Repository repository, BlobRef blobRef) {
        return ((ContentFacet)repository.facet(ContentFacet.class)).blobs().blob(blobRef);
    }

    private Predicate<FluentAsset> convert(BiPredicate<OffsetDateTime, OffsetDateTime> notRecentlyUsedFilter) {
        return asset -> notRecentlyUsedFilter.test(asset.blob().map(AssetBlob::blobCreated).orElse(null), asset.lastDownloaded().orElse(null));
    }

    private DateTime lastUpdated(Asset asset) {
        return asset.blob().map(AssetBlob::blobCreated).map(DateHelper::toDateTime).orElseGet(DateTime::new);
    }
}

