/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.exporttask.datastore;

import com.sonatype.nexus.exportimport.internal.exporttask.DiskService;
import com.sonatype.nexus.exportimport.internal.exporttask.DiskSpaceExportValidationSupport;
import com.sonatype.nexus.exportimport.internal.exporttask.ExportDeltaFileService;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.entity.Continuation;
import org.sonatype.nexus.common.time.DateHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;

@Named
@Singleton
public class DiskSpaceExportValidation
extends DiskSpaceExportValidationSupport {
    private final int assetPageSize;

    @Inject
    public DiskSpaceExportValidation(@Named(value="${nexus.exportimport.checkDiskSpace:-true}") @Named(value="${nexus.exportimport.checkDiskSpace:-true}") boolean enabled, @Named(value="${nexus.export.assetPageSize:-1000}") @Named(value="${nexus.export.assetPageSize:-1000}") int assetPageSize, DiskService diskService, ExportDeltaFileService exportDeltaFileService) {
        super(enabled, diskService, exportDeltaFileService);
        this.assetPageSize = assetPageSize;
    }

    @Override
    protected long totalBytesRequired(String targetDirectory, Repository repository) {
        FluentAssets assets = ((ContentFacet)repository.facet(ContentFacet.class)).assets();
        Continuation nextPage = assets.browse(this.assetPageSize, null);
        long total = 0L;
        while (!nextPage.isEmpty()) {
            total += nextPage.stream().filter(asset -> !this.isAssetAlreadyExported(targetDirectory, asset.path(), this.lastUpdated((Asset)asset))).map(Asset::blob).filter(Optional::isPresent).map(Optional::get).mapToLong(AssetBlob::blobSize).sum();
            nextPage = assets.browse(this.assetPageSize, nextPage.nextContinuationToken());
        }
        return total;
    }

    private DateTime lastUpdated(Asset asset) {
        return asset.blob().map(AssetBlob::blobCreated).map(DateHelper::toDateTime).orElseGet(DateTime::new);
    }
}

