/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal.exporttask;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationVersion;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

@Named
@Singleton
public class InstanceDetailsExportService
extends ComponentSupport {
    private NodeAccess nodeAccess;
    private ApplicationVersion applicationVersion;
    private static final String INSTANCE_DETAILS = "date:%s" + System.lineSeparator() + "nexus_repository_manager_version:%s" + System.lineSeparator() + "nexus_repository_manager_instance_id:%s" + System.lineSeparator() + "repository_name:%s" + System.lineSeparator();

    @Inject
    public InstanceDetailsExportService(NodeAccess nodeAccess, ApplicationVersion applicationVersion) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.applicationVersion = (ApplicationVersion)Preconditions.checkNotNull((Object)applicationVersion);
    }

    public void exportInstanceDetails(String repositoryName, String targetDirectory) {
        String instaceDetailsContent = String.format(INSTANCE_DETAILS, System.currentTimeMillis(), this.applicationVersion.getVersion(), this.nodeAccess.getClusterId(), repositoryName);
        File target = new File(targetDirectory, "instance_details.txt");
        try {
            Files.createDirectories(target.getParentFile().toPath(), new FileAttribute[0]);
            FileUtils.writeStringToFile((File)target, (String)instaceDetailsContent);
        }
        catch (IOException e) {
            this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Could not write instance details to file {}", (Object)target.getAbsolutePath(), (Object)e);
        }
    }
}

