/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.internal;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class FilenameUtil {
    private final Map<String, String> charMap = new HashMap<String, String>();

    public FilenameUtil() {
        this.charMap.put("<", "&#60");
        this.charMap.put(">", "&#62");
        this.charMap.put(":", "&#58");
        this.charMap.put("\"", "&#34");
        this.charMap.put("\\", "&#92");
        this.charMap.put("|", "&#124");
        this.charMap.put("?", "&#63");
        this.charMap.put("*", "&#42");
    }

    public String assetNameToFilePath(String assetName) {
        String assetFilename = assetName;
        for (Map.Entry<String, String> entry : this.charMap.entrySet()) {
            assetFilename = assetFilename.replace(entry.getKey(), entry.getValue());
        }
        return assetFilename;
    }

    public String filePathToAssetName(String filePath) {
        String assetFilename = filePath;
        for (Map.Entry<String, String> entry : this.charMap.entrySet()) {
            assetFilename = assetFilename.replace(entry.getValue(), entry.getKey());
        }
        return assetFilename;
    }
}

