/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport.datastore;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.exportimport.ObjectMapperProvider;
import com.sonatype.nexus.exportimport.model.AssetFileAttributes;
import com.sonatype.nexus.tags.Tag;
import com.sonatype.nexus.tags.TagStore;
import com.sonatype.nexus.tags.datastore.ComponentTag;
import com.sonatype.nexus.tags.datastore.ComponentTagStoreManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Iso8601Date;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;

@Named
@Singleton
public class ExportAttributesService
extends ComponentSupport {
    private static final String FORWARD_SLASH = "/";
    static final String CHECKSUM = "checksum";
    static final String ASSET_KIND = "asset_kind";
    static final String CONTENT = "content";
    private final ObjectMapper objectMapper;
    private final ComponentTagStoreManager componentTagStoreManager;
    private final TagStore tagStore;
    private final int tagLimit;

    @Inject
    public ExportAttributesService(ObjectMapperProvider objectMapper, ComponentTagStoreManager componentTagStoreManager, TagStore tagStore, @Named(value="${nexus.export.browseTagsLimit:-1000}") @Named(value="${nexus.export.browseTagsLimit:-1000}") int tagLimit) {
        this.objectMapper = ((ObjectMapperProvider)Preconditions.checkNotNull((Object)objectMapper)).get();
        this.componentTagStoreManager = (ComponentTagStoreManager)Preconditions.checkNotNull((Object)componentTagStoreManager);
        this.tagStore = (TagStore)Preconditions.checkNotNull((Object)tagStore);
        this.tagLimit = tagLimit;
    }

    public void exportAttributes(AssetFileAttributes attributes, FluentAsset asset) {
        attributes.setAssetName(StringUtils.stripStart((String)asset.path(), (String)FORWARD_SLASH));
        attributes.setAssetAttributes(this.addAttributesForBackwardCompatibility(asset));
        attributes.setComponentTags(new ArrayList<String>());
        this.setCreatedAndUpdatedTimestampsIfPresent(attributes, (Asset)asset);
        this.setLastDownloadedTimeIfPresent(attributes, (Asset)asset);
        this.setCreatedByIfPresent(attributes, (Asset)asset);
        this.setCreatedByIPIfPresent(attributes, (Asset)asset);
        this.setComponentRelatedAttributes(asset, attributes);
    }

    public void exportAttributes(File attributesFile, FluentAsset asset) {
        AssetFileAttributes attributes = new AssetFileAttributes();
        this.exportAttributes(attributes, asset);
        try {
            Files.createDirectories(attributesFile.getParentFile().toPath(), new FileAttribute[0]);
            FileUtils.writeStringToFile((File)attributesFile, (String)this.objectMapper.writeValueAsString((Object)attributes));
        }
        catch (IOException e) {
            this.log.error(TaskLoggingMarkers.TASK_LOG_ONLY, "Could not write properties to file {}", (Object)attributesFile.getAbsolutePath(), (Object)e);
        }
    }

    private Map<String, Object> addAttributesForBackwardCompatibility(FluentAsset asset) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(asset.attributes().backing());
        this.getChecksums(asset).ifPresent(checksums -> {
            Map map2 = attributes.put(CHECKSUM, checksums);
        });
        this.setAssetKind(attributes, asset);
        this.setLastModified(asset, attributes);
        return attributes;
    }

    private void setLastModified(FluentAsset asset, Map<String, Object> attributes) {
        Repository repository = asset.repository();
        if ("proxy".equals(repository.getType().getValue())) {
            Optional.ofNullable(this.toDate(asset.attributes(CONTENT).get("last_modified"))).ifPresent(lastModified -> {
                ImmutableMap immutableMap = attributes.put(CONTENT, ImmutableMap.of((Object)"last_modified", (Object)lastModified));
            });
        } else {
            this.getBlobCreated((Asset)asset).ifPresent(dateTime -> {
                ImmutableMap immutableMap = attributes.put(CONTENT, ImmutableMap.of((Object)"last_modified", (Object)dateTime));
            });
        }
    }

    private void setAssetKind(Map<String, Object> attributes, FluentAsset asset) {
        String formatName = asset.repository().getFormat().getValue();
        Object formatAttributes = attributes.get(formatName);
        if (formatAttributes != null) {
            ((Map)formatAttributes).put(ASSET_KIND, asset.kind());
        }
    }

    private Optional<Map<String, String>> getChecksums(FluentAsset asset) {
        return asset.blob().map(AssetBlob::checksums);
    }

    private void setComponentRelatedAttributes(FluentAsset asset, AssetFileAttributes exportAttributes) {
        Optional component = asset.component();
        if (component.isPresent()) {
            exportAttributes.setComponentAttributes(((Component)component.get()).attributes().backing());
            this.setTagsIfPresent(exportAttributes, (Component)component.get(), asset);
        } else {
            this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Component related to the asset '{}' not found", (Object)asset.path());
        }
    }

    private void setTagsIfPresent(AssetFileAttributes exportAttributes, Component component, FluentAsset asset) {
        List<String> tagNames = this.tagStore.getByIds(this.getTagIds(asset, component)).stream().map(Tag::name).collect(Collectors.toList());
        if (!tagNames.isEmpty()) {
            exportAttributes.setComponentTags(tagNames);
        }
    }

    private Set<Integer> getTagIds(FluentAsset asset, Component component) {
        return this.componentTagStoreManager.getStoreForRepository(asset.repository()).browseComponentTags(component, this.tagLimit, null).stream().map(ComponentTag::getTagId).collect(Collectors.toSet());
    }

    private void setCreatedAndUpdatedTimestampsIfPresent(AssetFileAttributes exportAttributes, Asset asset) {
        exportAttributes.setCreatedTimestamp(Date.from(asset.created().toInstant()));
        this.getBlobCreated(asset).ifPresent(dateTime -> exportAttributes.setLastUpdatedTimestamp((Date)dateTime));
    }

    private void setCreatedByIfPresent(AssetFileAttributes exportAttributes, Asset asset) {
        asset.blob().flatMap(AssetBlob::createdBy).ifPresent(exportAttributes::setCreatedBy);
    }

    private void setCreatedByIPIfPresent(AssetFileAttributes exportAttributes, Asset asset) {
        asset.blob().flatMap(AssetBlob::createdByIp).ifPresent(exportAttributes::setCreatedByIP);
    }

    private Optional<Date> getBlobCreated(Asset asset) {
        return asset.blob().map(AssetBlob::blobCreated).map(OffsetDateTime::toInstant).map(Date::from);
    }

    private void setLastDownloadedTimeIfPresent(AssetFileAttributes exportAttributes, Asset asset) {
        asset.lastDownloaded().map(OffsetDateTime::toInstant).map(Date::from).ifPresent(exportAttributes::setLastDownloadedTimestamp);
    }

    @Nullable
    private Date toDate(Object date) {
        if (date instanceof Date) {
            return (Date)date;
        }
        if (!(date instanceof String)) {
            this.log.debug("Found non-date or string: {}", date);
            return null;
        }
        try {
            return Iso8601Date.parse((String)((String)date));
        }
        catch (ParseException parseException) {
            this.log.warn("Failed to parse date: {}", date);
            return null;
        }
    }
}

