/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;

public class RepositoryImportHelper {
    private static String ARTIFACTORY_METADATA_FOLDER_SUFFIX = "artifactory-metadata";

    private RepositoryImportHelper() {
    }

    public static boolean isFileImportable(File file, boolean skipArtifactoryMetadata) {
        return !file.getName().startsWith(".") && (!skipArtifactoryMetadata || !file.getParent().endsWith(ARTIFACTORY_METADATA_FOLDER_SUFFIX));
    }

    public static String parseFilePath(String path, String sourceDirectory) {
        String result = path.substring(sourceDirectory.endsWith(File.separator) ? sourceDirectory.length() - 1 : sourceDirectory.length());
        if (result.startsWith("/") || result.startsWith("\\")) {
            result = result.substring(1);
        }
        return result.replace("\\", "/");
    }

    public static String toNxrm2AttributePath(String path, String sourceDirectory) {
        return RepositoryImportHelper.attributePath(path, sourceDirectory, ".nexus", "attributes");
    }

    public static String toAttributePath(String path, String sourceDirectory) {
        return RepositoryImportHelper.attributePath(path, sourceDirectory, ".nexus");
    }

    private static String attributePath(String path, String sourceDirectory, String ... subDirectories) {
        StringBuilder newPath = new StringBuilder(sourceDirectory);
        Arrays.stream(subDirectories).forEach(subDirectory -> newPath.append("/").append((String)subDirectory));
        newPath.append("/").append(RepositoryImportHelper.parseFilePath(path, sourceDirectory));
        return new File(newPath.toString()).getAbsolutePath();
    }

    public static long getLastUpdatedTimestamp(File file) throws IOException {
        return Files.getLastModifiedTime(file.toPath(), new LinkOption[0]).toMillis();
    }
}

