/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.exportimport;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.sonatype.nexus.exportimport.internal.importtask.AssetAttributeMapObjectDeserializer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Named
public class ObjectMapperProvider {
    public static final String DATE_PATTERN = "'nxrm-date-'yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ObjectMapperProvider() {
        this.objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(DATE_PATTERN));
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule("DateConverter");
        module.addDeserializer(Object.class, (JsonDeserializer)new AssetAttributeMapObjectDeserializer(DATE_PATTERN));
        this.objectMapper.registerModule((Module)module);
    }

    public ObjectMapper get() {
        return this.objectMapper;
    }
}

