/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.IOException;
import java.io.Writer;
import org.apache.tomcat.util.security.Escape;

public class XMLWriter {
    public static final int OPENING = 0;
    public static final int CLOSING = 1;
    public static final int NO_CONTENT = 2;
    protected StringBuilder buffer = new StringBuilder();
    protected final Writer writer;
    protected boolean lastWriteWasOpen;

    public XMLWriter() {
        this(null);
    }

    public XMLWriter(Writer writer) {
        this.writer = writer;
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void writeProperty(String namespace, String name, String value) {
        this.writeElement(namespace, name, 0);
        this.buffer.append(value);
        this.writeElement(namespace, name, 1);
    }

    public void writeElement(String namespace, String name, int type) {
        this.writeElement(namespace, null, name, type);
    }

    public void writeElement(String namespace, String namespaceInfo, String name, int type) {
        if (namespace != null && !namespace.isEmpty()) {
            switch (type) {
                case 0: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    if (namespaceInfo != null) {
                        this.buffer.append("<").append(namespace).append(":").append(name).append(" xmlns:").append(namespace).append("=\"").append(namespaceInfo).append("\">");
                    } else {
                        this.buffer.append("<").append(namespace).append(":").append(name).append(">");
                    }
                    this.lastWriteWasOpen = true;
                    break;
                }
                case 1: {
                    this.buffer.append("</").append(namespace).append(":").append(name).append(">\n");
                    this.lastWriteWasOpen = false;
                    break;
                }
                default: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    if (namespaceInfo != null) {
                        this.buffer.append("<").append(namespace).append(":").append(name).append(" xmlns:").append(namespace).append("=\"").append(namespaceInfo).append("\"/>\n");
                    } else {
                        this.buffer.append("<").append(namespace).append(":").append(name).append("/>\n");
                    }
                    this.lastWriteWasOpen = false;
                    break;
                }
            }
        } else if (namespaceInfo != null && !namespaceInfo.isEmpty()) {
            switch (type) {
                case 0: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    this.buffer.append("<").append(name).append(" xmlns=\"").append(namespaceInfo).append("\">");
                    this.lastWriteWasOpen = true;
                    break;
                }
                case 1: {
                    this.buffer.append("</").append(name).append(">\n");
                    this.lastWriteWasOpen = false;
                    break;
                }
                default: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    this.buffer.append("<").append(name).append(" xmlns=\"").append(namespaceInfo).append("\"/>\n");
                    this.lastWriteWasOpen = false;
                    break;
                }
            }
        } else {
            switch (type) {
                case 0: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    this.buffer.append("<").append(name).append(">");
                    this.lastWriteWasOpen = true;
                    break;
                }
                case 1: {
                    this.buffer.append("</").append(name).append(">\n");
                    this.lastWriteWasOpen = false;
                    break;
                }
                default: {
                    if (this.lastWriteWasOpen) {
                        this.buffer.append('\n');
                    }
                    this.buffer.append("<").append(name).append("/>\n");
                    this.lastWriteWasOpen = false;
                }
            }
        }
    }

    public void writeText(String text) {
        this.buffer.append(Escape.xml((String)text));
    }

    public void writeRaw(String raw) {
        this.buffer.append(raw);
    }

    public void writeData(String data) {
        this.buffer.append("<![CDATA[").append(data).append("]]>");
    }

    public void writeXMLHeader() {
        this.buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
    }

    public void sendData() throws IOException {
        if (this.writer != null) {
            this.writer.write(this.buffer.toString());
            this.buffer = new StringBuilder();
        }
    }
}

