/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import si.nevensrok.common.utils.NumberUtil;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.matches.Series;
import si.nevensrok.jtekma.common.rules.CompetitorType;

public final class MatchPointUtil {
    private MatchPointUtil() {
    }

    public static boolean haveMatchPointsChanged(Collection<MatchPoint> currentPoints, Collection<MatchPoint> newPoints) {
        if (currentPoints == newPoints) {
            return false;
        }
        if (currentPoints == null || newPoints == null) {
            return true;
        }
        LinkedList<MatchPoint> remainingPoints = new LinkedList<MatchPoint>(newPoints);
        for (MatchPoint currentMatchPoint : currentPoints) {
            MatchPoint newMatchPoint = MatchPointUtil.findPoints(remainingPoints, currentMatchPoint.getPointType(), currentMatchPoint.getCompetitor(), currentMatchPoint.getRound(), currentMatchPoint.getJudge(), currentMatchPoint.getSeries(), currentMatchPoint.getAttack(), currentMatchPoint.getPart());
            float point1 = ((Float)ObjectUtil.ifNull((Object)currentMatchPoint.getPoints(), (Object)Float.valueOf(0.0f))).floatValue();
            float point2 = 0.0f;
            if (newMatchPoint != null) {
                remainingPoints.remove(newMatchPoint);
                point2 = ((Float)ObjectUtil.ifNull((Object)newMatchPoint.getPoints(), (Object)Float.valueOf(0.0f))).floatValue();
            }
            if (NumberUtil.areFloatsEqual((float)point1, (float)point2, (float)0.001f)) continue;
            return true;
        }
        for (MatchPoint matchPoint : remainingPoints) {
            float point = ((Float)ObjectUtil.ifNull((Object)matchPoint.getPoints(), (Object)Float.valueOf(0.0f))).floatValue();
            if (!(point > 0.0f)) continue;
            return true;
        }
        return false;
    }

    private static MatchPoint findPoints(Collection<MatchPoint> matchPoints, PointType pointType, CompetitorType competitorType, Integer round, Integer judge, Series series, Integer attack, Integer part) {
        for (MatchPoint matchPoint : matchPoints) {
            if (!Objects.equals(matchPoint.getPointType(), pointType) || !Objects.equals(matchPoint.getCompetitor(), competitorType) || !Objects.equals(matchPoint.getRound(), round) || !Objects.equals(matchPoint.getJudge(), judge) || !Objects.equals(matchPoint.getSeries(), series) || !Objects.equals(matchPoint.getAttack(), attack) || !Objects.equals(matchPoint.getPart(), part)) continue;
            return matchPoint;
        }
        return null;
    }
}

