/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.httpserver;

import java.net.InetSocketAddress;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.DisposableBean;
import si.nevensrok.common.threads.GroupThreadFactory;
import si.nevensrok.jtekma.tabla.httpserver.TablaInfoHttpHandler;
import si.nevensrok.jtekma.tabla.httpserver.TablaMainHttpHandler;

public class HttpServer
implements DisposableBean {
    private com.sun.net.httpserver.HttpServer httpServer = null;
    private TablaMainHttpHandler tablaMainHttpHandler;
    private TablaInfoHttpHandler tablaInfoHttpHandler;
    private int port = 0;

    public void setTablaMainHttpHandler(TablaMainHttpHandler tablaMainHttpHandler) {
        this.tablaMainHttpHandler = tablaMainHttpHandler;
    }

    public void setTablaInfoHttpHandler(TablaInfoHttpHandler tablaInfoHttpHandler) {
        this.tablaInfoHttpHandler = tablaInfoHttpHandler;
    }

    public void destroy() throws Exception {
        this.stop();
    }

    public void start(int port) throws Exception {
        this.httpServer = com.sun.net.httpserver.HttpServer.create(new InetSocketAddress(port), 0);
        GroupThreadFactory threadFactory = new GroupThreadFactory("HttpServer-" + port);
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>(4096);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(8, 8, 60L, TimeUnit.SECONDS, workQueue, (ThreadFactory)threadFactory);
        this.httpServer.setExecutor(threadPoolExecutor);
        this.httpServer.createContext("/", this.tablaMainHttpHandler);
        this.httpServer.createContext("/info", this.tablaInfoHttpHandler);
        this.httpServer.start();
        this.port = port;
    }

    public void stop() {
        if (this.httpServer == null) {
            return;
        }
        this.httpServer.stop(0);
        this.httpServer = null;
        this.port = 0;
    }

    public boolean isRunning() {
        return this.httpServer != null;
    }

    public int getPort() {
        return this.port;
    }
}

