/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.fw.TimeTracker;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class HosekomiPanel
extends JPanel {
    private JLabel timeLabel = new JLabel("00");
    private JPanel oldTimesPanel = new JPanel();
    private JLabel[] oldTimesLabels = new JLabel[4];
    private MatchData matchData;
    private TimeTracker timeTracker;

    public HosekomiPanel() {
        this.setLayout(null);
        this.add(this.timeLabel);
        this.add(this.oldTimesPanel);
        this.timeLabel.setFont(Constants.FONT);
        this.timeLabel.setHorizontalAlignment(0);
        this.oldTimesPanel.setLayout(new GridLayout(1, this.oldTimesLabels.length));
        for (int i = 0; i < this.oldTimesLabels.length; ++i) {
            this.oldTimesLabels[i] = new JLabel("00");
            this.oldTimesLabels[i].setFont(Constants.FONT);
            this.oldTimesLabels[i].setHorizontalAlignment(0);
            this.oldTimesPanel.add(this.oldTimesLabels[i]);
        }
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTimeTracker(TimeTracker timeTracker) {
        this.timeTracker = timeTracker;
    }

    public void redrawElements() {
        if (this.matchData.getTableType() == TableType.FIGHT || this.matchData.getTableType() == TableType.NEWAZA) {
            long time = this.matchData.getHosekomiTime() / 1000L;
            this.timeLabel.setText(Constants.SECONDS_NUMBER_FORMAT.format(time));
            for (int i = 0; i < this.oldTimesLabels.length; ++i) {
                long lastTime = this.matchData.getLastHosekomis()[i] / 1000L;
                this.oldTimesLabels[i].setText(Constants.SECONDS_NUMBER_FORMAT.format(lastTime));
            }
        } else {
            this.timeLabel.setText("");
            for (JLabel label : this.oldTimesLabels) {
                label.setText("");
            }
        }
        if (this.timeTracker.isHosekomiRunning()) {
            this.setBackground(Constants.TIME_RUNNING_BG_COLOR);
            this.timeLabel.setForeground(Constants.TIME_RUNNING_FG_COLOR);
        } else {
            this.setBackground(Constants.INFO_BG_COLOR);
            this.timeLabel.setForeground(Constants.INFO_FG_COLOR);
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int timeHeight = (int)Math.floor((float)height * 0.8f);
        this.timeLabel.setSize(width, timeHeight);
        this.timeLabel.setLocation(0, 0);
        FontSizeUtil.refitFontSize(Constants.FONT, this.timeLabel);
        this.oldTimesPanel.setLocation(0, timeHeight);
        this.oldTimesPanel.setSize(width, height - timeHeight);
        for (JLabel label : this.oldTimesLabels) {
            FontSizeUtil.refitFontSize(Constants.FONT, label);
        }
        this.repaint();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.timeLabel != null) {
            this.timeLabel.setBackground(bg);
        }
        if (this.oldTimesPanel != null) {
            this.oldTimesPanel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.timeLabel != null) {
            this.timeLabel.setForeground(fg);
        }
        if (this.oldTimesPanel != null) {
            this.oldTimesPanel.setForeground(fg);
        }
        if (this.oldTimesLabels != null) {
            for (JLabel label : this.oldTimesLabels) {
                if (label == null) continue;
                label.setForeground(fg);
            }
        }
    }
}

