/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.Color;
import java.awt.EventQueue;
import javax.swing.JPanel;
import si.nevensrok.common.threads.ThreadUtil;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Duo2023Points;
import si.nevensrok.jtekma.tabla.common.DuoPoints;
import si.nevensrok.jtekma.tabla.common.DuoPresentationPoints;
import si.nevensrok.jtekma.tabla.common.FightPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.NewazaPoints;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.TextSource;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.horizontal.NamePanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo.DuoFieldSelector;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo.DuoPointsPanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo2023.Duo2023FieldSelector;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo2023.Duo2023PointsPanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.duopresentation.DuoPresentationPointsPanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.fights.FightPointsPanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.newaza.NewazaPointsPanel;

public class CompetitorPanel
extends JPanel {
    private NamePanel namePanel = new NamePanel();
    private FightPointsPanel fightPointsPanel;
    private DuoPointsPanel duoPointsPanel;
    private Duo2023PointsPanel duo2023PointsPanel;
    private NewazaPointsPanel newazaPointsPanel;
    private DuoPresentationPointsPanel duoPresentationPointsPanel;
    private MatchData matchData;

    public CompetitorPanel(CompetitorType competitorType) {
        this.fightPointsPanel = new FightPointsPanel(competitorType);
        this.duoPointsPanel = new DuoPointsPanel(competitorType);
        this.duo2023PointsPanel = new Duo2023PointsPanel(competitorType);
        this.newazaPointsPanel = new NewazaPointsPanel(competitorType);
        this.duoPresentationPointsPanel = new DuoPresentationPointsPanel();
        this.setLayout(null);
        this.add(this.namePanel);
        this.add(this.fightPointsPanel);
        this.add(this.duoPointsPanel);
        this.add(this.duo2023PointsPanel);
        this.add(this.newazaPointsPanel);
        this.add(this.duoPresentationPointsPanel);
    }

    public void setFightPoints(FightPoints fightPoints) {
        this.fightPointsPanel.setFightPoints(fightPoints);
    }

    public void setDuoPoints(DuoPoints duoPoints) {
        this.duoPointsPanel.setDuoPoints(duoPoints);
    }

    public void setDuo2023Points(Duo2023Points duo2023Points) {
        this.duo2023PointsPanel.setDuo2023Points(duo2023Points);
    }

    public void setDuoPresentationPoints(DuoPresentationPoints duoPresentationPoints) {
        this.duoPresentationPointsPanel.setDuoPresentationPoints(duoPresentationPoints);
    }

    public void setNewazaPoints(NewazaPoints newazaPoints) {
        this.newazaPointsPanel.setNewazaPoints(newazaPoints);
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
        this.fightPointsPanel.setMatchData(matchData);
        this.duoPointsPanel.setMatchData(matchData);
        this.newazaPointsPanel.setMatchData(matchData);
        this.duo2023PointsPanel.setMatchData(matchData);
        this.duoPresentationPointsPanel.setMatchData(matchData);
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.fightPointsPanel.setTablaManager(tablaManager);
        this.newazaPointsPanel.setTablaManager(tablaManager);
        this.duoPointsPanel.setTablaManager(tablaManager);
        this.duo2023PointsPanel.setTablaManager(tablaManager);
        this.duoPresentationPointsPanel.setTablaManager(tablaManager);
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        this.duoPointsPanel.setWindowKeyListener(windowKeyListener);
        this.duo2023PointsPanel.setWindowKeyListener(windowKeyListener);
        this.duoPresentationPointsPanel.setWindowKeyListener(windowKeyListener);
    }

    public void setDuoFieldSelector(DuoFieldSelector duoFieldSelector) {
        this.duoPointsPanel.setDuoFieldSelector(duoFieldSelector);
        this.duoPresentationPointsPanel.setDuoFieldSelector();
    }

    public void setDuo2023FieldSelector(Duo2023FieldSelector duo2023FieldSelector) {
        this.duo2023PointsPanel.setDuoFieldSelector(duo2023FieldSelector);
    }

    public void setTextSource(TextSource textSource) {
        this.fightPointsPanel.setTextSource(textSource);
        this.newazaPointsPanel.setTextSource(textSource);
    }

    public void setCompetitorName(String name) {
        this.namePanel.setCompetitorName(name);
    }

    public void setCompetitorClub(String club) {
        this.namePanel.setCompetitorClub(club);
    }

    public void setPoints(float points) {
        if (this.matchData.getTableType() == TableType.FIGHT) {
            this.fightPointsPanel.setPoints(points);
        } else if (this.matchData.getTableType() == TableType.DUO) {
            this.duoPointsPanel.setPoints(points);
        } else if (this.matchData.getTableType() == TableType.DUO2023) {
            this.duo2023PointsPanel.setPoints(points);
        } else if (this.matchData.getTableType() == TableType.NEWAZA) {
            this.newazaPointsPanel.setPoints(points);
        } else if (this.matchData.getTableType() == TableType.DUO_PRESENTATION) {
            this.duoPresentationPointsPanel.setPoints(points);
        }
    }

    public void resetDuoPoints() {
        this.duoPointsPanel.resetPoints();
        this.duo2023PointsPanel.resetPoints();
        this.duoPresentationPointsPanel.resetPoints();
    }

    public void recalculateDuoPoints() {
        this.duoPointsPanel.recalculateRoundPoints();
    }

    public void selectFirstDuoField() {
        if (this.matchData.getTableType() == TableType.DUO) {
            this.duoPointsPanel.selectFirstField();
        } else if (this.matchData.getTableType() == TableType.DUO2023) {
            this.duo2023PointsPanel.selectFirstField();
        } else if (this.matchData.getTableType() == TableType.DUO_PRESENTATION) {
            this.duoPresentationPointsPanel.selectFirstField();
        }
    }

    public void selectDuoField(int index) {
        if (this.matchData.getTableType() == TableType.DUO) {
            this.duoPointsPanel.selectField(index);
        } else if (this.matchData.getTableType() == TableType.DUO2023) {
            this.duo2023PointsPanel.selectField(index);
        }
    }

    public int getSelectedDuoField() {
        if (this.matchData.getTableType() == TableType.DUO) {
            return this.duoPointsPanel.getSelectedField();
        }
        if (this.matchData.getTableType() == TableType.DUO2023) {
            return this.duo2023PointsPanel.getSelectedField();
        }
        return 0;
    }

    public void redrawElements() {
        int width = this.getWidth();
        int height = this.getHeight();
        int offsetTop = (int)Math.round((double)height * 0.05);
        int namePanelWidth = (int)Math.floor((float)width * 0.6f);
        this.namePanel.setLocation(0, offsetTop);
        this.namePanel.setSize(namePanelWidth, height - offsetTop);
        int pointsPanelWidth = width - namePanelWidth;
        if (this.matchData.getTableType() == TableType.FIGHT) {
            this.fightPointsPanel.setLocation(namePanelWidth, offsetTop);
            this.fightPointsPanel.setSize(pointsPanelWidth, height - offsetTop);
            this.newazaPointsPanel.setLocation(0, 0);
            this.newazaPointsPanel.setSize(0, 0);
            this.duoPointsPanel.setLocation(0, 0);
            this.duoPointsPanel.setSize(0, 0);
            this.duo2023PointsPanel.setLocation(0, 0);
            this.duo2023PointsPanel.setSize(0, 0);
            this.duoPresentationPointsPanel.setLocation(0, 0);
            this.duoPresentationPointsPanel.setSize(0, 0);
        } else if (this.matchData.getTableType() == TableType.DUO) {
            this.duoPointsPanel.setLocation(namePanelWidth, offsetTop);
            this.duoPointsPanel.setSize(pointsPanelWidth, height - offsetTop);
            this.fightPointsPanel.setLocation(0, 0);
            this.fightPointsPanel.setSize(0, 0);
            this.newazaPointsPanel.setLocation(0, 0);
            this.newazaPointsPanel.setSize(0, 0);
            this.duo2023PointsPanel.setLocation(0, 0);
            this.duo2023PointsPanel.setSize(0, 0);
            this.duoPresentationPointsPanel.setLocation(0, 0);
            this.duoPresentationPointsPanel.setSize(0, 0);
        } else if (this.matchData.getTableType() == TableType.NEWAZA) {
            this.newazaPointsPanel.setLocation(namePanelWidth, offsetTop);
            this.newazaPointsPanel.setSize(pointsPanelWidth, height - offsetTop);
            this.fightPointsPanel.setLocation(0, 0);
            this.fightPointsPanel.setSize(0, 0);
            this.duoPointsPanel.setLocation(0, 0);
            this.duoPointsPanel.setSize(0, 0);
            this.duo2023PointsPanel.setLocation(0, 0);
            this.duo2023PointsPanel.setSize(0, 0);
            this.duoPresentationPointsPanel.setLocation(0, 0);
            this.duoPresentationPointsPanel.setSize(0, 0);
        } else if (this.matchData.getTableType() == TableType.DUO2023) {
            this.duo2023PointsPanel.setLocation(namePanelWidth, offsetTop);
            this.duo2023PointsPanel.setSize(pointsPanelWidth, height - offsetTop);
            this.newazaPointsPanel.setLocation(0, 0);
            this.newazaPointsPanel.setSize(0, 0);
            this.fightPointsPanel.setLocation(0, 0);
            this.fightPointsPanel.setSize(0, 0);
            this.duoPointsPanel.setLocation(0, 0);
            this.duoPointsPanel.setSize(0, 0);
            this.duoPresentationPointsPanel.setLocation(0, 0);
            this.duoPresentationPointsPanel.setSize(0, 0);
        } else if (this.matchData.getTableType() == TableType.DUO_PRESENTATION) {
            this.duoPresentationPointsPanel.setLocation(namePanelWidth, offsetTop);
            this.duoPresentationPointsPanel.setSize(pointsPanelWidth, height - offsetTop);
            this.newazaPointsPanel.setLocation(0, 0);
            this.newazaPointsPanel.setSize(0, 0);
            this.fightPointsPanel.setLocation(0, 0);
            this.fightPointsPanel.setSize(0, 0);
            this.duoPointsPanel.setLocation(0, 0);
            this.duoPointsPanel.setSize(0, 0);
            this.duo2023PointsPanel.setLocation(0, 0);
            this.duo2023PointsPanel.setSize(0, 0);
        }
        this.namePanel.redrawElements();
        if (this.matchData.getTableType() == TableType.FIGHT) {
            this.fightPointsPanel.redrawElements();
        } else if (this.matchData.getTableType() == TableType.DUO) {
            this.duoPointsPanel.redrawElements();
        } else if (this.matchData.getTableType() == TableType.DUO2023) {
            this.duo2023PointsPanel.redrawElements();
        } else if (this.matchData.getTableType() == TableType.NEWAZA) {
            this.newazaPointsPanel.redrawElements();
        } else if (this.matchData.getTableType() == TableType.DUO_PRESENTATION) {
            this.duoPresentationPointsPanel.redrawElements();
        }
        ThreadUtil.runInBackground((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CompetitorPanel.this.namePanel.redrawElements();
                        if (CompetitorPanel.this.matchData.getTableType() == TableType.FIGHT) {
                            CompetitorPanel.this.fightPointsPanel.redrawElements();
                        } else if (CompetitorPanel.this.matchData.getTableType() == TableType.DUO) {
                            CompetitorPanel.this.duoPointsPanel.redrawElements();
                        } else if (CompetitorPanel.this.matchData.getTableType() == TableType.DUO2023) {
                            CompetitorPanel.this.duo2023PointsPanel.redrawElements();
                        } else if (CompetitorPanel.this.matchData.getTableType() == TableType.NEWAZA) {
                            CompetitorPanel.this.newazaPointsPanel.redrawElements();
                        } else if (CompetitorPanel.this.matchData.getTableType() == TableType.DUO_PRESENTATION) {
                            CompetitorPanel.this.duoPresentationPointsPanel.redrawElements();
                        }
                        CompetitorPanel.this.repaint();
                    }
                });
            }
        });
        this.repaint();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.namePanel != null) {
            this.namePanel.setBackground(bg);
        }
        if (this.fightPointsPanel != null) {
            this.fightPointsPanel.setBackground(bg);
        }
        if (this.duoPointsPanel != null) {
            this.duoPointsPanel.setBackground(bg);
        }
        if (this.duo2023PointsPanel != null) {
            this.duo2023PointsPanel.setBackground(bg);
        }
        if (this.newazaPointsPanel != null) {
            this.newazaPointsPanel.setBackground(bg);
        }
        if (this.duoPresentationPointsPanel != null) {
            this.duoPresentationPointsPanel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.namePanel != null) {
            this.namePanel.setForeground(fg);
        }
        if (this.fightPointsPanel != null) {
            this.fightPointsPanel.setForeground(fg);
        }
        if (this.duoPointsPanel != null) {
            this.duoPointsPanel.setForeground(fg);
        }
        if (this.duo2023PointsPanel != null) {
            this.duo2023PointsPanel.setForeground(fg);
        }
        if (this.newazaPointsPanel != null) {
            this.newazaPointsPanel.setForeground(fg);
        }
        if (this.duoPresentationPointsPanel != null) {
            this.duoPresentationPointsPanel.setForeground(fg);
        }
    }
}

