/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.CustomTimeTracker;
import si.nevensrok.jtekma.tabla.fw.TimerUpdateCallback;
import si.nevensrok.jtekma.tabla.gui.TablaWindow;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class TimerDialog
extends JDialog
implements InitializingBean,
DisposableBean,
ApplicationContextAware {
    private static final long serialVersionUID = 1140581719772646108L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TimerDialog.class);
    private static final NumberFormat SECONDS_NUMBER_FORMAT = new DecimalFormat("00");
    private static final Font ARROWS_FONT = new Font("Serif", 1, 80);
    private static final Font TIME_FONT = new Font("Serif", 1, 120);
    private static final Color BG_COLOR = Color.WHITE;
    private static final Color FG_COLOR = Color.BLACK;
    private final TablaWindow tablaWindow;
    private ApplicationContext applicationContext;
    private MatchData matchData;
    private final JLabel timeLabel = new JLabel("0:00");
    private boolean countUp = true;
    private final CustomTimeTracker upTimeTracker;
    private final CustomTimeTracker downTimeTracker;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void afterPropertiesSet() throws Exception {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TimerDialog.this.upTimeTracker.stopTime();
                TimerDialog.this.downTimeTracker.stopTime();
            }
        });
    }

    public void destroy() throws Exception {
        if (this.upTimeTracker != null) {
            this.upTimeTracker.destroy();
        }
        if (this.downTimeTracker != null) {
            this.downTimeTracker.destroy();
        }
    }

    public TimerDialog(TablaWindow tablaWindow) {
        super((Window)tablaWindow, Dialog.ModalityType.APPLICATION_MODAL);
        final TimerDialog dialog = this;
        this.tablaWindow = tablaWindow;
        this.upTimeTracker = new CustomTimeTracker(true);
        this.downTimeTracker = new CustomTimeTracker(false);
        this.downTimeTracker.setTime(120000);
        this.upTimeTracker.setTimerUpdateCallback(new TimerUpdateCallback(){

            @Override
            public void updateTime(int time) {
                if (TimerDialog.this.countUp) {
                    TimerDialog.this.displayTime(time);
                }
            }
        });
        this.downTimeTracker.setTimerUpdateCallback(new TimerUpdateCallback(){

            @Override
            public void updateTime(int time) {
                if (!TimerDialog.this.countUp) {
                    TimerDialog.this.displayTime(time);
                }
            }
        });
        this.setDefaultCloseOperation(1);
        this.setBackground(BG_COLOR);
        this.setForeground(FG_COLOR);
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setBackground(BG_COLOR);
        topPanel.setForeground(FG_COLOR);
        this.add((Component)topPanel, "North");
        topPanel.setLayout(new GridLayout(1, 2, 10, 10));
        JLabel countUpLabel = new JLabel("\u21d1");
        countUpLabel.setFont(ARROWS_FONT);
        countUpLabel.setVerticalAlignment(0);
        countUpLabel.setHorizontalAlignment(0);
        countUpLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 3));
        countUpLabel.setBackground(BG_COLOR);
        countUpLabel.setForeground(FG_COLOR);
        topPanel.add(countUpLabel);
        countUpLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!TimerDialog.this.countUp) {
                    TimerDialog.this.countUp = true;
                    TimerDialog.this.downTimeTracker.stopTime();
                    TimerDialog.this.displayTime(TimerDialog.this.upTimeTracker.getTime());
                }
            }
        });
        JLabel countDownLabel = new JLabel("\u21d3");
        countDownLabel.setFont(ARROWS_FONT);
        countDownLabel.setVerticalAlignment(0);
        countDownLabel.setHorizontalAlignment(0);
        countDownLabel.setBorder(BorderFactory.createLineBorder(Color.BLACK, 3));
        countDownLabel.setBackground(BG_COLOR);
        countDownLabel.setForeground(FG_COLOR);
        topPanel.add(countDownLabel);
        countDownLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TimerDialog.this.countUp) {
                    TimerDialog.this.countUp = false;
                    TimerDialog.this.upTimeTracker.stopTime();
                    TimerDialog.this.displayTime(TimerDialog.this.downTimeTracker.getTime());
                }
            }
        });
        this.timeLabel.setFont(TIME_FONT);
        this.timeLabel.setVerticalAlignment(0);
        this.timeLabel.setHorizontalAlignment(0);
        this.timeLabel.setBackground(BG_COLOR);
        this.timeLabel.setForeground(FG_COLOR);
        this.timeLabel.setOpaque(true);
        this.add((Component)this.timeLabel, "Center");
        this.timeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    if (TimerDialog.this.countUp) {
                        TimerDialog.this.upTimeTracker.startStopTime();
                    } else {
                        TimerDialog.this.downTimeTracker.startStopTime();
                    }
                } else {
                    TimerDialog.this.upTimeTracker.stopTime();
                    TimerDialog.this.downTimeTracker.stopTime();
                    int time = TimerDialog.this.countUp ? TimerDialog.this.upTimeTracker.getTime() / 1000 : TimerDialog.this.downTimeTracker.getTime() / 1000;
                    int minutes = time / 60;
                    int seconds = time % 60;
                    String timeText = String.valueOf(minutes) + ":" + SECONDS_NUMBER_FORMAT.format(seconds);
                    timeText = JOptionPane.showInputDialog(dialog, TimerDialog.this.getLanguageText("text.enterInjuryTime"), timeText);
                    if (timeText != null) {
                        try {
                            String[] parts = timeText.split(":");
                            if (parts.length > 1) {
                                minutes = Integer.parseInt(parts[0].trim());
                                seconds = Integer.parseInt(parts[1].trim());
                            } else {
                                minutes = 0;
                                seconds = Integer.parseInt(parts[0].trim());
                            }
                            time = (minutes * 60 + seconds) * 1000;
                            if (TimerDialog.this.countUp) {
                                TimerDialog.this.upTimeTracker.setTime(time);
                            } else {
                                TimerDialog.this.downTimeTracker.setTime(time);
                            }
                            TimerDialog.this.displayTime(time);
                        }
                        catch (Exception ex) {
                            LOGGER.error("Error while parsing time", (Throwable)ex);
                        }
                    }
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    TimerDialog.this.setVisible(false);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            int width = (int)((float)this.tablaWindow.getWidth() * 0.8f);
            int height = (int)((float)this.tablaWindow.getHeight() * 0.6f);
            this.setSize(width, height);
            this.setLocationRelativeTo(this.tablaWindow);
        } else {
            this.upTimeTracker.stopTime();
            this.downTimeTracker.stopTime();
        }
        if (b) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FontSizeUtil.refitFontSize(TIME_FONT, TimerDialog.this.timeLabel);
                    TimerDialog.this.revalidate();
                    TimerDialog.this.repaint();
                }
            });
        }
        super.setVisible(b);
    }

    public void resetTime() {
        this.upTimeTracker.stopTime();
        this.downTimeTracker.stopTime();
        this.upTimeTracker.setTime(0);
        this.downTimeTracker.setTime(120000);
        if (this.countUp) {
            this.displayTime(this.upTimeTracker.getTime());
        } else {
            this.displayTime(this.downTimeTracker.getTime());
        }
    }

    private void displayTime(int time) {
        int minutes = time / 60000;
        int seconds = (time - minutes * 60000) / 1000;
        final StringBuilder timeText = new StringBuilder();
        timeText.append(minutes);
        timeText.append(":");
        if (seconds < 10) {
            timeText.append("0");
        }
        timeText.append(seconds);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimerDialog.this.timeLabel.setText(timeText.toString());
                FontSizeUtil.refitFontSize(TIME_FONT, TimerDialog.this.timeLabel);
            }
        });
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.matchData.getLocale());
    }
}

