/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.jtekma.tabla.common.MatchData;

public class HelpDialog
extends JDialog
implements ApplicationContextAware,
DisposableBean {
    private ApplicationContext applicationContext;
    private MatchData matchData;
    private JFrame tablaWindow;
    private JLabel[] labels = new JLabel[27];

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaWindow(JFrame tablaWindow) {
        this.tablaWindow = tablaWindow;
    }

    public String getLanguageText(String key) {
        return this.applicationContext.getMessage(key, null, key, this.matchData.getLocale());
    }

    public void destroy() throws Exception {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HelpDialog.this.setVisible(false);
                HelpDialog.this.dispose();
            }
        });
    }

    public HelpDialog() {
        this.setAlwaysOnTop(true);
        this.setSize(320, 40 + this.labels.length * 20);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel(new GridLayout(this.labels.length, 1, 5, 5));
        this.add((Component)mainPanel, "Center");
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new JLabel();
            mainPanel.add(this.labels[i]);
        }
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    HelpDialog.this.setVisible(false);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(this.tablaWindow);
            this.setTitle(this.getLanguageText("title.help"));
            for (int i = 0; i < this.labels.length; ++i) {
                this.labels[i].setText(this.getLanguageText("help." + i));
            }
        }
        super.setVisible(b);
    }
}

