/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.fw;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import si.nevensrok.jtekma.tabla.gui.InjuryTimeCounter;

public class InjuryTimeTracker
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(InjuryTimeTracker.class);
    private InjuryTimeCounter injuryTimeCounter;
    private int time = 0;
    private final Object timeMonitor = new Object();
    private Thread timeThread = null;

    public InjuryTimeTracker(InjuryTimeCounter injuryTimeCounter) {
        this.injuryTimeCounter = injuryTimeCounter;
    }

    public void destroy() throws Exception {
        this.timeThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startStopTime() {
        Object object = this.timeMonitor;
        synchronized (object) {
            if (this.timeThread == null) {
                this.timeThread = new Thread("Time thread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Starting time thread");
                        }
                        long startTime = System.currentTimeMillis();
                        while (InjuryTimeTracker.this.timeThread == this) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            long endTime = System.currentTimeMillis();
                            long timeDiff = endTime - startTime;
                            Object object = InjuryTimeTracker.this.timeMonitor;
                            synchronized (object) {
                                if (InjuryTimeTracker.this.timeThread == this) {
                                    InjuryTimeTracker.this.time = (int)((long)InjuryTimeTracker.this.time + timeDiff);
                                    InjuryTimeTracker.this.injuryTimeCounter.displayTime(InjuryTimeTracker.this.time);
                                }
                            }
                            startTime = endTime;
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Stopping time thread");
                        }
                    }
                };
                this.timeThread.setDaemon(true);
                this.timeThread.start();
            } else {
                this.timeThread = null;
                this.injuryTimeCounter.displayTime(this.time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTime() {
        Object object = this.timeMonitor;
        synchronized (object) {
            this.timeThread = null;
        }
    }

    public boolean isTimeRunning() {
        return this.timeThread != null;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }
}

