/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.fw;

import java.awt.EventQueue;
import java.util.Set;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.DuoPresentationPoint;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchFinishData;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.PointDetail;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.fw.TablaServiceClient;
import si.nevensrok.jtekma.tabla.gui.InfoWindow;
import si.nevensrok.jtekma.tabla.gui.TablaWindow;

public class FinishMatchOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(FinishMatchOperation.class);
    private Thread thread;
    private InfoWindow infoWindow;
    private Match match;
    private DuoPresentation duoPresentation;
    private Set<MatchPoint> matchPoints;
    private Set<DuoPresentationPoint> duoPresentationPoints;
    private Set<PointDetail> pointDetails;
    private Integer fightTimeLeft;
    private Integer injuryTime1;
    private Integer injuryTime2;
    private MatchData matchData;
    private TablaServiceClient tablaService;
    private Credentials credentials;
    private TablaManager tablaManager;
    private TablaWindow tablaWindow;

    public FinishMatchOperation(final Object matchMonitor) {
        this.thread = new Thread("Send match data thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    while (!FinishMatchOperation.this.infoWindow.isVisible()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    boolean dataSent = false;
                    for (int i = 0; i < 3; ++i) {
                        try {
                            if (FinishMatchOperation.this.infoWindow.isOperationCanceled()) break;
                            FinishMatchOperation.this.infoWindow.setCurrentAttempt(i + 1);
                            MatchFinishData matchFinishData = new MatchFinishData();
                            matchFinishData.setMatch(FinishMatchOperation.this.match);
                            matchFinishData.setDuoPresentation(FinishMatchOperation.this.duoPresentation);
                            matchFinishData.setMatchPoints(FinishMatchOperation.this.matchPoints);
                            matchFinishData.setDuoPresentationPoints(FinishMatchOperation.this.duoPresentationPoints);
                            matchFinishData.setPointDetails(FinishMatchOperation.this.pointDetails);
                            matchFinishData.setFightTimeLeft(FinishMatchOperation.this.fightTimeLeft);
                            matchFinishData.setInjuryTime1(FinishMatchOperation.this.injuryTime1);
                            matchFinishData.setInjuryTime2(FinishMatchOperation.this.injuryTime2);
                            matchFinishData.setChallengesWon1(Integer.valueOf(FinishMatchOperation.this.matchData.getChallengesWon1()));
                            matchFinishData.setChallengesWon2(Integer.valueOf(FinishMatchOperation.this.matchData.getChallengesWon2()));
                            matchFinishData.setChallengesLost1(Integer.valueOf(FinishMatchOperation.this.matchData.getChallengesLost1()));
                            matchFinishData.setChallengesLost2(Integer.valueOf(FinishMatchOperation.this.matchData.getChallengesLost2()));
                            FinishMatchOperation.this.tablaService.finishMatch(FinishMatchOperation.this.credentials, matchFinishData);
                            Object object = matchMonitor;
                            synchronized (object) {
                                FinishMatchOperation.this.matchData.setMatch(null);
                                FinishMatchOperation.this.matchData.setDuoPresentation(null);
                            }
                            FinishMatchOperation.this.tablaManager.resetTable();
                            dataSent = true;
                            break;
                        }
                        catch (Exception e) {
                            LOGGER.error("Error while finishing match", (Throwable)e);
                            continue;
                        }
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FinishMatchOperation.this.tablaWindow.setEnabled(true);
                            FinishMatchOperation.this.infoWindow.setVisible(false);
                            FinishMatchOperation.this.infoWindow.dispose();
                            FinishMatchOperation.this.tablaWindow.requestFocus();
                        }
                    });
                    if (!dataSent) {
                        FinishMatchOperation.this.matchData.setMatch(FinishMatchOperation.this.match);
                        if (!FinishMatchOperation.this.infoWindow.isOperationCanceled()) {
                            JOptionPane.showMessageDialog(FinishMatchOperation.this.tablaWindow, FinishMatchOperation.this.tablaManager.getLanguageText("text.errorFinishing"), FinishMatchOperation.this.tablaManager.getLanguageText("title.error"), 0);
                        }
                    }
                }
                finally {
                    FinishMatchOperation.this.tablaManager.setFinishingMatch(false);
                }
            }
        };
    }

    public void setInfoWindow(InfoWindow infoWindow) {
        this.infoWindow = infoWindow;
    }

    public void setMatch(Match match) {
        this.match = match;
    }

    public void setDuoPresentation(DuoPresentation duoPresentation) {
        this.duoPresentation = duoPresentation;
    }

    public void setMatchPoints(Set<MatchPoint> matchPoints) {
        this.matchPoints = matchPoints;
    }

    public void setDuoPresentationPoints(Set<DuoPresentationPoint> duoPresentationPoints) {
        this.duoPresentationPoints = duoPresentationPoints;
    }

    public void setPointDetails(Set<PointDetail> pointDetails) {
        this.pointDetails = pointDetails;
    }

    public void setFightTimeLeft(Integer fightTimeLeft) {
        this.fightTimeLeft = fightTimeLeft;
    }

    public void setInjuryTime1(Integer injuryTime1) {
        this.injuryTime1 = injuryTime1;
    }

    public void setInjuryTime2(Integer injuryTime2) {
        this.injuryTime2 = injuryTime2;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaService(TablaServiceClient tablaService) {
        this.tablaService = tablaService;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    public void setTablaWindow(TablaWindow tablaWindow) {
        this.tablaWindow = tablaWindow;
    }

    public void execute() {
        this.thread.start();
    }
}

