/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.fw;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import si.nevensrok.jtekma.tabla.fw.TimerUpdateCallback;

public class CustomTimeTracker
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomTimeTracker.class);
    private final boolean countUp;
    private int time = 0;
    private TimerUpdateCallback timerUpdateCallback;
    private final Object timeMonitor = new Object();
    private Thread timeThread = null;

    public CustomTimeTracker(boolean countUp) {
        this.countUp = countUp;
    }

    public void setTimerUpdateCallback(TimerUpdateCallback timerUpdateCallback) {
        this.timerUpdateCallback = timerUpdateCallback;
    }

    public void destroy() throws Exception {
        this.timeThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startStopTime() {
        Object object = this.timeMonitor;
        synchronized (object) {
            if (this.timeThread == null) {
                this.timeThread = new Thread("Time thread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Starting time thread");
                        }
                        long startTime = System.currentTimeMillis();
                        while (CustomTimeTracker.this.timeThread == this) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            long endTime = System.currentTimeMillis();
                            long timeDiff = endTime - startTime;
                            Object object = CustomTimeTracker.this.timeMonitor;
                            synchronized (object) {
                                if (CustomTimeTracker.this.timeThread == this) {
                                    if (CustomTimeTracker.this.countUp) {
                                        CustomTimeTracker.this.time = (int)((long)CustomTimeTracker.this.time + timeDiff);
                                    } else {
                                        CustomTimeTracker.this.time = (int)((long)CustomTimeTracker.this.time - timeDiff);
                                        if (CustomTimeTracker.this.time <= 0) {
                                            CustomTimeTracker.this.time = 0;
                                            CustomTimeTracker.this.timeThread = null;
                                        }
                                    }
                                    if (CustomTimeTracker.this.timerUpdateCallback != null) {
                                        CustomTimeTracker.this.timerUpdateCallback.updateTime(CustomTimeTracker.this.time);
                                    }
                                }
                            }
                            startTime = endTime;
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Stopping time thread");
                        }
                    }
                };
                this.timeThread.setDaemon(true);
                this.timeThread.start();
            } else {
                this.timeThread = null;
                if (this.timerUpdateCallback != null) {
                    this.timerUpdateCallback.updateTime(this.time);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTime() {
        Object object = this.timeMonitor;
        synchronized (object) {
            this.timeThread = null;
        }
    }

    public boolean isTimeRunning() {
        return this.timeThread != null;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }
}

