(function() {
    let view = definePackage("jtekma.view");

    view.table = class Table extends view.main {

        constructor(rows) {
            super("table");
            if (isArray(rows)) {
                if (rows.length > 0) {
                    this.setHeader(rows[0]);
                }
                if (rows.length > 1) {
                    this.setData(rows.splice(1, rows.length - 1));
                }
            }
        }

        setHeader(columns) {
            if (!isArray(columns)) {
                throw new Error("Provided columns is not array");
            }
            if (!isArray(this.content)) {
                this.content = [];
            }
            if (this.content.length < 1) {
                this.addContent(new view.thead([]));
            }
            if (!isObject(this.content[0]) || this.content[0].tag != "thead") {
                throw new Error("Table first row is not element with tag thead");
            }
            if (this.content[0].content.length < 1) {
                this.content[0].addContent(new view.tr([]));
            }
            if (!isObject(this.content[0].content[0]) || this.content[0].content[0].tag != "tr") {
                throw new Error("Table head first row is not element with tag tr");
            }
            this.content[0].content[0].setContent([]);
            for (let column of columns) {
                if (isNull(column)) {
                    this.content[0].content[0].addContent(new view.th(""));
                }
                else if (isString(column)) {
                    this.content[0].content[0].addContent(new view.th(column));
                }
                else if (isObject(column) && column.tag == "th") {
                    this.content[0].content[0].addContent(column);
                }
                else {
                    throw new Error("Unknown column data");
                }
            }
            if (this.drawn) {
                this.draw();
            }
        }

        setData(rows) {
            if (!isArray(rows)) {
                throw new Error("Provided rows is not array");
            }
            if (!isArray(this.content)) {
                this.content = [];
            }
            if (this.content.length < 1) {
                this.addContent(new view.thead([]));
            }
            if (this.content.length < 2) {
                this.addContent(new view.tbody([]));
            }
            this.content[1].content = [];
            if (!isObject(this.content[1]) || this.content[1].tag != "tbody") {
                throw new Error("Table second row is not element with tag tbody");
            }
            for (let row of rows) {
                if (!isArray(row)) {
                    throw new Error("Row data is not array");
                }
                let rowView = new view.tr([]);
                this.content[1].addContent(rowView);
                for (let column of row) {
                    if (isNull(column)) {
                        rowView.addContent(new view.td(""));
                    }
                    else if (isString(column)) {
                        rowView.addContent(new view.td(column));
                    }
                    else if (isObject(column) && column.tag == "td") {
                        rowView.addContent(column);
                    }
                    else {
                        throw new Error("Unknown column data");
                    }
                }
            }
            if (this.drawn) {
                this.draw();
            }
        }

        addData(columns) {
            if (!isArray(columns)) {
                throw new Error("Provided columns is not array");
            }
            if (!isArray(this.content)) {
                this.content = [];
            }
            if (this.content.length < 1) {
                this.addContent(new view.thead([]));
            }
            if (this.content.length < 2) {
                this.addContent(new view.tbody([]));
            }
            let rowView = new view.tr([]);
            this.content[1].addContent(rowView);
            for (let column of columns) {
                if (isNull(column)) {
                    rowView.addContent(new view.td(""));
                }
                else if (isString(column)) {
                    rowView.addContent(new view.td(column));
                }
                else if (isObject(column) && column.tag == "td") {
                    rowView.addContent(column);
                }
                else {
                    throw new Error("Unknown column data");
                }
            }
            if (this.drawn) {
                this.draw();
            }
        }

    };

})();