(function() {
    let view = definePackage("jtekma.view");

    view.input = class Input extends view.main {

        constructor(type, value) {
            super("input");
            this.attributes.type = type;

            if (!isTextEmpty(value)) {
                this.attributes.value = value;
            }
        }

        getValue() {
            return this.el.value;
        }

        setValue(val) {
            this.el.value = val;
        }

        clear() {
            this.el.value = "";
        }

        setName(name) {
            this.setAttribute("name", name);
        }

        setDisabled(disabled) {
            if (disabled) {
                this.setAttribute("disabled", disabled);
            }
            else {
                this.removeAttribute("disabled");
            }
        }

        setReadonly(readonly) {
            if (readonly) {
                this.setAttribute("readonly", readonly);
            }
            else {
                this.removeAttribute("readonly");
            }
        }

        onChange(callback) {
            this.addEventListener("change", callback);
        }

    };

})();