(function() {
    let view = definePackage("jtekma.view");

    view.CategoryListDisplay = class CategoryListDisplay extends view.main {

        constructor(categoryListData) {
            super("div");
            if (isNotNull(categoryListData) && isNotNull(categoryListData.categoryData)) {
                for (let categoryData of categoryListData.categoryData) {
                    if (isNotNull(categoryData)) {
                        this.addContent(new view.CategoryDisplay(categoryData));
                    }
                }
            }
        }

    };

    view.CategoryDisplay = class CategoryDisplay extends view.main {

        constructor(categoryData) {
            super("div");
            this.addContent(new view.h3(categoryData.categoryName));

            if (isNotNull(categoryData.table1)) {
                if (isNotNull(categoryData.table2)) {
                    this.addContent(new view.h3(getSpringMessage("competition.table1")));
                }
                this.addContent(new view.TableDisplay(categoryData.table1));
            }
            if (isNotNull(categoryData.table2)) {
                this.addContent(new view.h3(getSpringMessage("competition.table2")));
                this.addContent(new view.TableDisplay(categoryData.table2));
            }

            if (isNotNull(categoryData.duoTable)) {
                this.addContent(new view.DuoTableDisplay(categoryData.duoTable));
            }

            if (isArray(categoryData.duoPresentations) && categoryData.duoPresentations.length > 0) {
                this.addContent(new view.DuoPresentationsDisplay(categoryData.duoPresentations));
            }

            if (isArray(categoryData.matches) && categoryData.matches.length > 0) {
                this.addContent(new view.MatchesDisplay(categoryData.treeType, categoryData.double3rdPlace, categoryData.matches));
            }

            if (isArray(categoryData.placings) && categoryData.placings.length > 0) {
                this.addContent(new view.PlacingsDisplay(categoryData.placings));
            }

            this.addContent(new view.hr());
        }

    };

    view.TableDisplay = class TableDisplay extends view.main {

        constructor(tableData) {
            super("div");

            let table = new view.table();
            table.setClass("table table-bordered table-striped");

            let headers = [];
            headers.push(getSpringMessage("competition.competitor"));

            for (let i = 0; i < tableData.rows.length; i++) {
                headers.push(String(i + 1));
            }

            headers.push(getSpringMessage("competition.wins"));
            headers.push(getSpringMessage("competition.fiWins"));
            headers.push(getSpringMessage("competition.points"));
            headers.push(getSpringMessage("competition.placing"));

            table.setHeader(headers);

            let rows = [];

            for (let tableRow of tableData.rows) {
                if (isNull(tableRow)) {
                    continue;
                }

                let row = [];
                if (isNotNull(tableRow.competitor)) {
                    row.push(tableRow.competitor.shortName + "/" + tableRow.competitor.shortClubName);
                }
                else {
                    row.push("");
                }

                if (isArray(tableRow.matches)) {
                    for (let matchData of tableRow.matches) {
                        let points = "";
                        if (isNotNull(matchData.points1)) {
                            points += String(matchData.points1);
                        }
                        points += ":";
                        if (isNotNull(matchData.points2)) {
                            points += String(matchData.points2);
                        }
                        row.push(points);
                    }
                }

                row.push(String(tableRow.wins));
                row.push(String(tableRow.fullIpponWins));
                row.push(String(tableRow.pointsGained));
                row.push(String(tableRow.placing));

                rows.push(row);
            }

            table.setData(rows);

            this.addContent(table);
        }

    };

    view.DuoTableDisplay = class DuoTableDisplay extends view.main {

        constructor(duoTableData) {
            super("div");

            let table = new view.table();
            table.setClass("table table-bordered table-striped");

            let headers = [];
            headers.push(getSpringMessage("competition.competitor"));
            headers.push(getSpringMessage("competition.round1Points"));
            headers.push(getSpringMessage("competition.round2Points"));
            headers.push(getSpringMessage("competition.round3Points"));
            headers.push(getSpringMessage("competition.varietyScorePoints"));
            headers.push(getSpringMessage("competition.points"));
            headers.push(getSpringMessage("competition.placing"));
            table.setHeader(headers);

            let rows = [];

            for (let tableRow of duoTableData.rows) {
                if (isNull(tableRow)) {
                    continue;
                }

                let row = [];
                if (isNotNull(tableRow.competitor)) {
                    row.push(tableRow.competitor.shortName + "/" + tableRow.competitor.shortClubName);
                }
                else {
                    row.push("");
                }

                row.push(String(tableRow.round1Points));
                row.push(String(tableRow.round2Points));
                row.push(String(tableRow.round3Points));
                row.push(String(tableRow.varietyScorePoints));
                row.push(String(tableRow.points));
                row.push(String(tableRow.placing));

                rows.push(row);
            }

            table.setData(rows);

            this.addContent(table);
        }

    };

    view.PlacingsDisplay = class PlacingsDisplay extends view.main {

        constructor(placingsData) {
            super("div");

            let titleDiv = new view.div(getSpringMessage("competition.placings"));
            titleDiv.addStyle("font-weight", "bold");
            this.addContent(titleDiv);

            let showWorldLevel = false;
            let showAdvanced = false;

            for (let placing of placingsData) {
                if (placing.rank == "WORLD_LEVEL") {
                    showWorldLevel = true;
                }
                else if (placing.rank == "ADVANCED") {
                    showAdvanced = true;
                }
            }

            if (showWorldLevel) {
                this.addContent(new view.div(getSpringMessage("competition.worldLevel")));
                for (let placing of placingsData) {
                    if (placing.rank == "WORLD_LEVEL") {
                        this.addContent(new view.div(String(placing.place) + ". " + placing.competitor.name + " / " + placing.competitor.clubName));
                    }
                }
                this.addContent(new view.br());
            }

            if (showAdvanced) {
                this.addContent(new view.div(getSpringMessage("competition.advancedLevel")));
                for (let placing of placingsData) {
                    if (placing.rank == "ADVANCED") {
                        this.addContent(new view.div(String(placing.place) + ". " + placing.competitor.name + " / " + placing.competitor.clubName));
                    }
                }
            }

            if (!showWorldLevel && !showAdvanced) {
                for (let placing of placingsData) {
                    this.addContent(new view.div(String(placing.place) + ". " + placing.competitor.name + " / " + placing.competitor.clubName));
                }
            }
        }

    };

})();(function() {
    let view = definePackage("jtekma.view");

    view.MatchesDisplay = class MatchesDisplay extends view.main {

        constructor(treeType, double3rdPlace, matchesData) {
            super("div");
            this.matchesData = matchesData;

            if (treeType == "TABLE2" || treeType == "TABLE3" || treeType == "TABLE4" || treeType == "TABLE5") {
                var matchesToShow = [];

                if (treeType == "TABLE2") {
                    matchesToShow.push(4);
                }
                else if (treeType == "TABLE3") {
                    matchesToShow.push(5);
                    matchesToShow.push(4);
                    matchesToShow.push(8);
                }
                else if (treeType == "TABLE4") {
                    matchesToShow.push(7);
                    matchesToShow.push(8);
                    matchesToShow.push(2);
                    matchesToShow.push(4);
                    matchesToShow.push(9);
                    matchesToShow.push(5);
                }
                else if (treeType == "TABLE5") {
                    for (let i = 1; i <= 10; i++) {
                        matchesToShow.push(i);
                    }
                }
                for (let match of matchesData) {
                    if (!matchesToShow.includes(match.number)) {
                        continue;
                    }
                    if (match.status != "WAITING" && match.status != "INQUEUE" && match.status != "INPROGRESS" && match.status != "FINISHED") {
                        continue;
                    }
                    this.addContent(new view.MatchDisplay(match));
                }
            }
            else if (treeType == "TREE4") {
                this.addClass("tree-matches");
                this.addStyle("width", "560px");
                this.addStyle("height", "330px");

                for (let i = 117; i <= 118; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 117) * 80 + 40));
                }
                for (let i = 124; i <= 124; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 124) * (-80) + 80));
                }
                //repasague
                for (let i = 123; i <= 123; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 123) * (-80) + 240));
                }
            }
            else if (treeType == "TREE8") {
                this.addClass("tree-matches");
                this.addStyle("width", "770px");
                this.addStyle("height", "560px");

                for (let i = 105; i <= 108; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 105) * 80 + 40));
                }
                for (let i = 117; i <= 118; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 117) * 160 + 80));
                }
                for (let i = 124; i <= 124; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 124) * 80 + 160));
                }
                //repasague
                for (let i = 119; i <= 120; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 119) * 80 + 390));
                }
                for (let i = 121; i <= 122; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 121) * 80 + 390));
                }
                if (!double3rdPlace) {
                    for (let i = 123; i <= 123; i++) {
                        let match = this.getMatchByNumber(i);
                        this.addContent(new view.MatchDisplay(match, 500, (i - 123) * 80 + 430));
                    }
                }
            }
            else if (treeType == "TREE16") {
                this.addClass("tree-matches");
                this.addStyle("width", "1220px");
                this.addStyle("height", "1040px");

                for (let i = 81; i <= 88; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 81) * 80 + 40));
                }
                for (let i = 105; i <= 108; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 105) * 160 + 80));
                }
                for (let i = 117; i <= 118; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 117) * 320 + 160));
                }
                for (let i = 124; i <= 124; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 740, (i - 124) * 80 + 320));
                }
                //repasague
                for (let i = 109; i <= 112; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 109) * 80 + 700));
                }
                for (let i = 113; i <= 116; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 113) * 80 + 700));
                }
                for (let i = 119; i <= 120; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 119) * 160 + 740));
                }
                for (let i = 121; i <= 122; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 740, (i - 121) * 160 + 740));
                }
                if (!double3rdPlace) {
                    for (let i = 123; i <= 123; i++) {
                        let match = this.getMatchByNumber(i);
                        this.addContent(new view.MatchDisplay(match, 980, (i - 123) * 80 + 820));
                    }
                }
            }
            else if (treeType == "TREE32") {
                this.addClass("tree-matches");
                this.addStyle("width", "1700px");
                this.addStyle("height", "2010px");

                for (let i = 33; i <= 48; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 33) * 80 + 40));
                }
                for (let i = 81; i <= 88; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 81) * 160 + 80));
                }
                for (let i = 105; i <= 108; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 105) * 320 + 160));
                }
                for (let i = 117; i <= 118; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 740, (i - 117) * 640 + 320));
                }
                for (let i = 124; i <= 124; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 980, (i - 124) * 80 + 640));
                }
                //repasague
                for (let i = 89; i <= 96; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 89) * 80 + 1360));
                }
                for (let i = 97; i <= 104; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 97) * 80 + 1360));
                }
                for (let i = 109; i <= 112; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 109) * 160 + 1400));
                }
                for (let i = 113; i <= 116; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 740, (i - 113) * 160 + 1400));
                }
                for (let i = 119; i <= 120; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 980, (i - 119) * 320 + 1480));
                }
                for (let i = 121; i <= 122; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 1220, (i - 121) * 320 + 1480));
                }
                if (!double3rdPlace) {
                    for (let i = 123; i <= 123; i++) {
                        let match = this.getMatchByNumber(i);
                        this.addContent(new view.MatchDisplay(match, 1460, (i - 123) * 80 + 1650));
                    }
                }
            }
            else if (treeType == "TREE64") {
                this.addClass("tree-matches");
                this.addStyle("width", "2200px");
                this.addStyle("height", "3960px");

                for (let i = 1; i <= 32; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 1) * 80 + 40));
                }
                for (let i = 33; i <= 48; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 33) * 160 + 80));
                }
                for (let i = 81; i <= 88; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 81) * 320 + 160));
                }
                for (let i = 105; i <= 108; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 740, (i - 105) * 640 + 320));
                }
                for (let i = 117; i <= 118; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 980, (i - 117) * 1280 + 640));
                }
                for (let i = 124; i <= 124; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 1220, (i - 124) * 80 + 1280));
                }
                //repasague
                for (let i = 49; i <= 64; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 20, (i - 49) * 80 + 2660));
                }
                for (let i = 65; i <= 80; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 260, (i - 65) * 80 + 2660));
                }
                for (let i = 89; i <= 96; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 500, (i - 89) * 160 + 2700));
                }
                for (let i = 97; i <= 104; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 740, (i - 97) * 160 + 2700));
                }
                for (let i = 109; i <= 112; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 980, (i - 109) * 320 + 2780));
                }
                for (let i = 113; i <= 116; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 1220, (i - 113) * 320 + 2780));
                }
                for (let i = 119; i <= 120; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 1460, (i - 119) * 640 + 2950));
                }
                for (let i = 121; i <= 122; i++) {
                    let match = this.getMatchByNumber(i);
                    this.addContent(new view.MatchDisplay(match, 1700, (i - 121) * 640 + 2950));
                }
                if (!double3rdPlace) {
                    for (let i = 123; i <= 123; i++) {
                        let match = this.getMatchByNumber(i);
                        this.addContent(new view.MatchDisplay(match, 1940, (i - 123) * 80 + 3260));
                    }
                }
            }
            else {
                for (let match of matchesData) {
                    if (match.status != "WAITING" && match.status != "INQUEUE" && match.status != "INPROGRESS" && match.status != "FINISHED") {
                        continue;
                    }
                    this.addContent(new view.MatchDisplay(match));
                }
            }
        }

        getMatchByNumber(number) {
            for (let match of this.matchesData) {
                if (match.number == number) {
                    return match;
                }
            }
            return null;
        }

    };

    view.MatchDisplay = class MatchDisplay extends view.main {

        constructor(matchData, left, top) {
            super("div");
            this.addClass("match");

            if (isNotNull(left) && isNotNull(top)) {
                this.addStyle("position", "absolute");
                this.addStyle("left", String(left) + "px");
                this.addStyle("top", String(top) + "px");
            }

            let header = new view.div();
            header.addClass("header");

            let badge = new view.span(matchData.shortName);
            badge.addClass("badge");
            header.addContent(badge);
            header.addContent(" ");

            let label = new view.span(getSpringMessage("match.status." + matchData.status));
            if (matchData.status == "NOTNEEDED") {
                label.addClass("label label-default");
            }
            else if (matchData.status == "WAITING") {
                label.addClass("label label-danger");
            }
            else if (matchData.status == "INQUEUE") {
                label.addClass("label label-info");
            }
            else if (matchData.status == "INPROGRESS") {
                label.addClass("label label-warning");
            }
            else if (matchData.status == "FINISHED") {
                label.addClass("label label-success");
            }
            header.addContent(label);

            this.addContent(header);

            let competitor1data = matchData.competitor1;
            let competitor1 = new view.div();
            competitor1.addClass("competitor1");
            let name1 = new view.div();
            name1.addClass("name");
            if (isNotNull(competitor1data)) {
                if (competitor1data.winner) {
                    competitor1.addClass("winner");
                }
                name1.setContent(new view.div(competitor1data.shortName + " / " + competitor1data.shortClubName));
            }
            competitor1.addContent(name1);
            let points1 = new view.div();
            points1.addClass("points");
            points1.setContentText(matchData.points1);
            competitor1.addContent(points1);
            this.addContent(competitor1);

            let competitor2data = matchData.competitor2;
            let competitor2 = new view.div();
            competitor2.addClass("competitor2");
            let name2 = new view.div();
            name2.addClass("name");
            if (isNotNull(competitor2data)) {
                if (competitor2data.winner) {
                    competitor2.addClass("winner");
                }
                name2.setContent(new view.div(competitor2data.shortName + " / " + competitor2data.shortClubName));
            }
            competitor2.addContent(name2);
            let points2 = new view.div();
            points2.addClass("points");
            points2.setContentText(matchData.points2);
            competitor2.addContent(points2);
            this.addContent(competitor2);
        }

    };

})();
(function() {
    let view = definePackage("jtekma.view");

    view.DuoPresentationsDisplay = class DuoPresentationsDisplay extends view.main {

        constructor(duoPresentationsData) {
            super("div");

            for (let duoPresentation of duoPresentationsData) {
                if (duoPresentation.status != "WAITING" && duoPresentation.status != "INQUEUE" && duoPresentation.status != "INPROGRESS" && duoPresentation.status != "FINISHED") {
                    continue;
                }
                this.addContent(new view.DuoPresentationDisplay(duoPresentation));
            }
        }

        getMatchByNumber(number) {
            for (let match of this.matchesData) {
                if (match.number == number) {
                    return match;
                }
            }
            return null;
        }

    };

    view.DuoPresentationDisplay = class DuoPresentationDisplay extends view.main {

        constructor(duoPresentationData) {
            super("div");
            this.addClass("match");

            let header = new view.div();
            header.addClass("header");

            let badge = new view.span(duoPresentationData.shortName);
            badge.addClass("badge");
            header.addContent(badge);
            header.addContent(" ");

            let label = new view.span(getSpringMessage("match.status." + duoPresentationData.status));
            if (duoPresentationData.status == "NOTNEEDED") {
                label.addClass("label label-default");
            }
            else if (duoPresentationData.status == "WAITING") {
                label.addClass("label label-danger");
            }
            else if (duoPresentationData.status == "INQUEUE") {
                label.addClass("label label-info");
            }
            else if (duoPresentationData.status == "INPROGRESS") {
                label.addClass("label label-warning");
            }
            else if (duoPresentationData.status == "FINISHED") {
                label.addClass("label label-success");
            }
            header.addContent(label);

            this.addContent(header);

            let competitorData = duoPresentationData.competitor;
            let competitor = new view.div();
            competitor.addClass("competitor1");
            let name = new view.div();
            name.addClass("name");
            if (isNotNull(competitorData)) {
                name.setContent(new view.div(competitorData.shortName + " / " + competitorData.shortClubName));
            }
            competitor.addContent(name);
            let points = new view.div();
            points.addClass("points");
            points.setContentText(duoPresentationData.points);
            competitor.addContent(points);
            this.addContent(competitor);
        }

    };

})();
(function() {
	let view = definePackage("jtekma.view");
	let restClient = definePackage("restClient");

	view.Search = class Search extends view.main {

		constructor(tatamiId) {
			super("div");
			this.addClass("row");

			let searchInputDiv = new view.div();
			searchInputDiv.addClass("col-md-9");
			this.addContent(searchInputDiv);

			this.searchInput = new view.input("text");
			this.searchInput.addStyle("width", "100%");
			this.searchInput.onChange(() => {
				this.searchData();
			})
			searchInputDiv.addContent(this.searchInput);

			let searchButtonDiv = new view.div();
			searchButtonDiv.addClass("col-md-3");
			this.addContent(searchButtonDiv);

			this.searchButton = new view.button(getSpringMessage("common.search"));
			this.searchButton.addClass("btn btn-primary");
			this.searchButton.addStyle("width", "100%");
			this.searchButton.onClick(() => {
				this.searchData();
			});
			searchButtonDiv.addContent(this.searchButton);

			this.dataDiv = new view.div();
			this.dataDiv.addClass("col-md-12");
			this.addContent(this.dataDiv);
		}

		searchData() {
			let searchString = this.searchInput.getValue();
			if (isTextEmpty(searchString)) {
				this.dataDiv.setContent("");
				this.searching = false;
				this.searchButton.setDisabled(false);
				return;
			}

			if (this.searching) {
				return;
			}
			this.searching = true;
			this.searchButton.setDisabled(true);

			this.dataDiv.setContent(getSpringMessage("common.loading"));

			let parameters = {
				"text": searchString
			};

			restClient.getJson("/search/search", parameters, null, (responseData, response) => {
				if (!this.searching) {
					return;
				}
				this.searching = false;
				this.searchButton.setDisabled(false);
				if (!response.isSuccessful()) {
					this.dataDiv.setContentText(response.errorText);
					return;
				}
				this.dataDiv.setContent(new view.CategoryListDisplay(response.data));
			});
		}

	};

})();

$(document).ready(function() {
	let view = definePackage("jtekma.view");
	let search = new view.Search();
	search.draw($("#search-div")[0]);
});
