(function() {
    var jtekma = definePackage("jtekma");
    var views = definePackage("jtekma.views");

    /*-------- Event -------*/
    views.EventEditView = Backbone.View.extend({
		"tagName": "div",
		"template": templates.getTemplate("/competition/template/edit-event"),
		"initialize": function() {
			$(this.el).attr("class","modal fade");

			var obj = this;

			this.on("show", function() {
				$("body").append(obj.el);

				$(obj.el).modal({
			    	show:false
			    });

				$(obj.el).on("hidden.bs.modal",function () {
					$(obj.el).remove();
				});

				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render": function() {
			var obj = this;

			$(this.el).html(Mustache.render(this.template,this.model.toJSON()));

			$(".btn-primary", this.el).on("click",function() {
				obj.model.set("text", $("textarea[name='event-text']", obj.el).val());
				obj.model.set("autoRemove", $("input[name='autoRemove']", obj.el).is(":checked"));
                obj.model.set("removeAt", $("input[name='removeAt']", obj.el).val());

				var url = obj.model.url() + "?tatamiId=" + jtekma.displaySettings.get("tatami").get("id");
				if (obj.model.get("id") != null) {
					url = obj.model.url() + "?eventId=" + obj.model.get("id");
				}

				$.ajax({
					"async": false,
					"url": url,
					"type": "POST",
					"contentType": "application/json; charset=utf-8",
					"data": JSON.stringify(obj.model.toJSON())
				});
				$(obj.el).modal("hide");

				jtekma.reloadData();
			});

            $("input.datetime", this.el).each(function(index) {
                var dateFormat = $(this).attr("date-format");
                var timeFormat = $(this).attr("time-format");
                if (!dateFormat) {
                    dateFormat = defaultDateFormat;
                }
                if (!timeFormat) {
                    timeFormat = defaultTimeFormat;
                }
                $(this).datetimepicker({
                    "dateFormat": dateFormat,
                    "timeFormat": timeFormat
                });
            });

			return this;
		}
	});

    /*----- Category selector ---------*/
    views.CategorySelectView = Backbone.View.extend({
        "optionTemplate": "<option value=\"{{id}}\">{{name}}</option>",
        "initialize": function() {
            this.collection.on("reset", function() {
                this.render();
            }, this);
        },
        "render": function() {
            var obj = this;
            this.collection.each(function(item, index) {
                item.on("change:show", function() {
                    obj.reloadCategories();
                });
            });

            $(this).html("");

            var categories = this.collection;

            $(this.el).change(function() {
                var categoryId = Number($(this).val());

                var category = categories.where({ "id": categoryId });
                if (category.length > 0) {
                    jtekma.displaySettings.set("category", category[0]);
                }
            });

            this.collection.each(function(item, index) {
                if (item.get("show")) {
                    $(this.el).append(Mustache.render(this.optionTemplate, item.toJSON()));
                }
            }, this);

            $(this.el).chosen({
                "search_contains": true,
                "width": "200px"
            });

            var enabledCategories = this.collection.where({ "show": true });

            if (enabledCategories.length > 0) {
                jtekma.displaySettings.set("category", enabledCategories[0]);
            }

            return this;
        },
        "reloadCategories": function() {
            var selectedCategoryId = $(this.el).val();

            $(this.el).html("");

            this.collection.each(function(item, index) {
                if (item.get("show")) {
                    $(this.el).append(Mustache.render(this.optionTemplate, item.toJSON()));
                }
            }, this);
            $("option[value='" + selectedCategoryId + "']", this.el).prop("selected", true);

            $(this.el).trigger("liszt:updated");
            $(this.el).trigger('chosen:updated');

            var enabledCategories = this.collection.where({ "show": true });

            if (enabledCategories.length > 0) {
                if (selectedCategoryId) {
                    var category = this.collection.where({ "id": Number(selectedCategoryId), "show": true });
                    if (category.length > 0) {
                        jtekma.displaySettings.set("category", category[0]);
                    }
                    else {
                        jtekma.displaySettings.set("category", enabledCategories[0]);
                    }
                }
                else {
                    jtekma.displaySettings.set("category", enabledCategories[0]);
                }
            }
        }
    });

    views.CategoryEnableView = Backbone.View.extend({
        "optionTemplate": "<li><input style=\"margin-right:5px;margin-top:-3px;\" type=\"checkbox\"{{#show}} checked=\"true\"{{/show}} categoryId=\"{{id}}\" /><label>{{name}}</label></li>",
        "initialize": function() {
            this.collection.on("reset", function() {
                this.render();
            }, this);
        },
        "render": function() {
            $(this).html("");

            var categories = this.collection;

            this.collection.each(function(item, index) {
                $(this.el).append(Mustache.render(this.optionTemplate, item.toJSON()));
            }, this);

            $("input[type='checkbox']", this.el).change(function() {
                var categoryId = Number($(this).attr("categoryId"));
                var showCategory = $(this).is(":checked");

                var category = categories.where({ "id": categoryId });
                if (category.length > 0) {
                    category[0].set("show", showCategory);
                }

                $.ajax({
                    "url": contextPath + "/competition/data/show-category/" + String(categoryId) + "/" + String(showCategory),
                    "type": "GET"
                });
            });

            $("input[type='checkbox']", this.el).on("click", function(e) {
                e.stopPropagation();
            });

            $("label", this.el).on("click", function(e) {
                $(this).parent().find("input[type='checkbox']").click();
                e.stopPropagation();
            });

            return this;
        }
    });

})();