(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

    models.Tree6TableModel = Backbone.Model.extend({
        "url": function() {
            return contextPath + "/competition/data/tree6-tables";
        },
        "defaults": {
            "rows1": null,
            "rows2": null
        }
    });

    views.Tree6TablesView = Backbone.View.extend({
        "template": templates.getTemplate("/competition/template/tree6-tables"),
        "initialize": function() {
            this.model.tree6Table.on("change", function() {
                this.renderTree6Table();
            }, this);
            this.model.matches.on("reset", function() {
                this.renderMatches();
            }, this);
            this.render();
        },
        "render": function() {
            var category = jtekma.displaySettings.get("category");

            var data = {};
            $(this.el).html(Mustache.render(this.template, data));

            return this;
        },
        "renderTree6Table": function() {
            var element = $("#tables");
            element.html("");
            this.model.tree6Table.set("num", [1,2,3]);
            var tree6TableView = new views.Tree6TableView({
                "el": element,
                "model": this.model.tree6Table
            });
            tree6TableView.render();
        },
        "renderMatches": function() {
            var category = jtekma.displaySettings.get("category");
            var treeCategoryOptions = category.get("treeCategoryOptions");

            var element = $("#knockout");
            element.html("");

            element.attr("style", "width:770px;height:320px;");
            for (var i = 7; i <= 8; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:20px;top:" + String((i - 7) * 80 + 20) + "px;"
                    }
                });
                element.append(matchView.render().el);
            }
            if (!treeCategoryOptions.double3rdPlace) {
                for (var i = 9; i <= 9; i++) {
                    var match = this.model.matches.where({ "number": i })[0];
                    var matchView = new views.MatchView({
                        "model": match,
                        "attributes": {
                            "style": "position:absolute;left:260px;top:220px;"
                        }
                    });
                    element.append(matchView.render().el);
                }
            }
            for (var i = 10; i <= 10; i++) {
                var match = this.model.matches.where({ "number": i })[0];
                var matchView = new views.MatchView({
                    "model": match,
                    "attributes": {
                        "style": "position:absolute;left:260px;top:60px;"
                    }
                });
                element.append(matchView.render().el);
            }
        }
    });

	views.Tree6TableView = Backbone.View.extend({
		"template": templates.getTemplate("/competition/template/tree6-table"),
		"initialize": function() {
			this.model.on("change", function() {
				this.render();
			}, this);
		},
		"render": function() {
			var tableData = this.model.toJSON();
			$(this.el).html(Mustache.render(this.template, tableData));
			return this;
		}
	});

})();