(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

    // placings
    models.PlacingModel = Backbone.Model.extend({
        "defaults": {
            "place": 0,
            "competitor": null
        }
    });

    models.PlacingCollection = Backbone.Collection.extend({
        "url": function() {
          return contextPath + "/competition/data/placings";
        },
        "model": models.PlacingModel
    });

    views.PlacingView = Backbone.View.extend({
        "template": templates.getTemplate("/competition/template/placings"),
        "initialize": function() {
            this.collection.on("reset",function() {
                this.render();
            }, this);
        },
        "render": function() {
            var data = {
                "placings": this.collection.toJSON()
            };
            $(this.el).html(Mustache.render(this.template, data));

            $("[rel='tooltip']", this.el).tooltip();

            return this;
        }
    });

    // duo 2023 placings
    models.Duo2023PlacingModel = Backbone.Model.extend({
        "defaults": {
            "rank": null,
            "place": 0,
            "competitor": null
        }
    });

    models.Duo2023PlacingCollection = Backbone.Collection.extend({
        "url": function() {
          return contextPath + "/competition/data/duo-2023-placings";
        },
        "model": models.Duo2023PlacingModel
    });

    views.Duo2023PlacingView = Backbone.View.extend({
        "template": templates.getTemplate("/competition/template/duo-2023-placings"),
        "initialize": function() {
            this.collection.on("reset",function() {
                this.render();
            }, this);
        },
        "render": function() {
            var data = {};

            this.collection.each(function(item, index) {
                if (item.get("rank") == "WORLD_LEVEL") {
                    if (isNull(data.worldLevel)) {
                        data.showWorldLevel = true;
                        data.worldLevel = [];
                    }
                    data.worldLevel.push(item.toJSON());
                }
                else if (item.get("rank") == "ADVANCED") {
                    if (isNull(data.advanced)) {
                        data.showAdvanced = true;
                        data.advanced = [];
                    }
                    data.advanced.push(item.toJSON());
                }
                else if (item.get("rank") == "NOVICE") {
                    if (isNull(data.novice)) {
                        data.showNovice = true;
                        data.novice = [];
                    }
                    data.novice.push(item.toJSON());
                }
            });

            $(this.el).html(Mustache.render(this.template, data));

            $("[rel='tooltip']", this.el).tooltip();

            return this;
        }
    });

})();