(function() {
    var jtekma = definePackage("jtekma");
    var views = definePackage("jtekma.views");

    var constants = definePackage("jtekma.constants");

	views.MatchDetailsView = Backbone.View.extend({
		"tagName": "div",
		"template": templates.getTemplate("/competition/template/match-details"),
		"initialize": function() {
			$(this.el).attr("class", "modal fade");

			var obj = this;

			this.on("show",function() {
				$("body").append(obj.el);

				$(obj.el).modal({
			    	show: false
			    });

				$(obj.el).on("hidden.bs.modal",function () {
					$(obj.el).remove();
				});

				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render": function() {
			var obj = this;

			$(this.el).html(Mustache.render(this.template,this.model.toJSON()));

			$.ajax({
				url: contextPath + "/competition/data/match-details/" + String(obj.model.get("id")),
				type: 'GET',
				success: function(responseData) {
					var chartType = responseData.chartType;
					var data = responseData.chartData;
					var categories = responseData.categories;
					var xAxisLabel = responseData.xAxisLabel;
					var yAxisLabel = responseData.yAxisLabel;
					var tooltipText = responseData.tooltipText;

					$("#match-points-graph").highcharts({
						chart: {
							type: chartType
						},
						title:{
							text: "",
							style: {
								display: 'none'
							}
						},
						xAxis:{
							title:{
								text: xAxisLabel
							},
							categories: categories
						},
						yAxis:{
							title:{
								text: yAxisLabel
							},
							min: 0
						},
						colors: ['#AA4643', '#4572A7'],
						tooltip: {
							formatter: function() {
								var text = tooltipText;
								text = text.replace("%s",this.series.name);
								text = text.replace("%x",this.x);
								text = text.replace("%y",this.y);
								return text;
							}
						},
						credits: {
							enabled: false
						},
						series:data
					});
				}
			});

			return this;
		}
	});

	views.MatchEditView = Backbone.View.extend({
		"tagName": "div",
		"fightTemplate": templates.getTemplate("/competition/template/edit-match-fight"),
		"duoTemplate": templates.getTemplate("/competition/template/edit-match-duo"),
		"duo2023Template": templates.getTemplate("/competition/template/edit-match-duo-2023"),
		"newazaTemplate": templates.getTemplate("/competition/template/edit-match-newaza"),
		"initialize": function() {
			$(this.el).attr("class", "modal fade");

			var obj = this;

			this.on("show",function() {
				$("body").append(obj.el);

				$(obj.el).modal({
			    	show: false
			    });

				$(obj.el).on("hidden.bs.modal", function () {
					$(obj.el).remove();
				});

				obj.render();
				$(obj.el).modal("show");
			});
		},
		"render": function() {
			var obj = this;

			function calculateFightPointsSum() {
				if (Number($("input[name='hansokumake1']",obj.el).val()) > 0) {
					$("input[name='sum1']",obj.el).val("0");
					$("input[name='sum2']",obj.el).val(constants.fullIpponPoints);
				}
				else if (Number($("input[name='hansokumake2']",obj.el).val()) > 0) {
					$("input[name='sum1']",obj.el).val(constants.fullIpponPoints);
					$("input[name='sum2']",obj.el).val("0");
				}
				else if ((Number($("input[name='ippon1_1']",obj.el).val()) > 0 || Number($("input[name='ippon1_1_3p']",obj.el).val()) > 0)
				&& (Number($("input[name='ippon1_2']",obj.el).val()) > 0 || Number($("input[name='ippon1_2_3p']",obj.el).val()) > 0)
				&& (Number($("input[name='ippon1_3']",obj.el).val()) > 0 || Number($("input[name='ippon1_3_3p']",obj.el).val()) > 0)) {
					$("input[name='sum1']",obj.el).val(constants.fullIpponPoints);
					$("input[name='sum2']",obj.el).val("0");
				}
				else if ((Number($("input[name='ippon2_1']",obj.el).val()) > 0 || Number($("input[name='ippon2_1_3p']",obj.el).val()) > 0)
				&& (Number($("input[name='ippon2_2']",obj.el).val()) > 0 || Number($("input[name='ippon2_2_3p']",obj.el).val()) > 0)
				&& (Number($("input[name='ippon2_3']",obj.el).val()) > 0 || Number($("input[name='ippon2_3_3p']",obj.el).val()) > 0)) {
					$("input[name='sum1']",obj.el).val("0");
					$("input[name='sum2']",obj.el).val(constants.fullIpponPoints);
				}
				else {
					var sum1 = Number($("input[name='wazari1']",obj.el).val())
					+ Number($("input[name='ippon1_1']",obj.el).val()) * 2
					+ Number($("input[name='ippon1_2']",obj.el).val()) * 2
					+ Number($("input[name='ippon1_3']",obj.el).val()) * 2
					+ Number($("input[name='ippon1_1_3p']",obj.el).val()) * 3
					+ Number($("input[name='ippon1_2_3p']",obj.el).val()) * 3
					+ Number($("input[name='ippon1_3_3p']",obj.el).val()) * 3;
					var sum2 = Number($("input[name='wazari2']",obj.el).val())
					+ Number($("input[name='ippon2_1']",obj.el).val()) * 2
					+ Number($("input[name='ippon2_2']",obj.el).val()) * 2
					+ Number($("input[name='ippon2_3']",obj.el).val()) * 2
					+ Number($("input[name='ippon2_1_3p']",obj.el).val()) * 3
					+ Number($("input[name='ippon2_2_3p']",obj.el).val()) * 3
					+ Number($("input[name='ippon2_3_3p']",obj.el).val()) * 3;

					$("input[name='sum1']",obj.el).val(sum1);
					$("input[name='sum2']",obj.el).val(sum2);
				}
			}

			function calculateDuoPointsSum() {
				var sum1 = 0;
				var sum2 = 0;
				for (var round = 1; round <= 5; round++) {
					var roundSum1 = 0;
					var roundSum2 = 0;
					var min1 = Number.MAX_VALUE;
					var max1 = 0;
					var min2 = Number.MAX_VALUE;
					var max2 = 0;
					for (var judge = 1; judge <= 5; judge++) {
						var points1 = Number($("[competitor='1'] [round='"+round+"'] [judge='"+judge+"'] input", obj.el).val());
						var points2 = Number($("[competitor='2'] [round='"+round+"'] [judge='"+judge+"'] input", obj.el).val());
						roundSum1 += points1;
						roundSum2 += points2;

						if (points1 > max1) {
							max1 = points1;
						}
						if (points1 < min1) {
							min1 = points1;
						}
						if (points2 > max2) {
							max2 = points2;
						}
						if (points2 < min2) {
							min2 = points2;
						}
					}
					roundSum1 -= min1 + max1;
					roundSum2 -= min2 + max2;

					sum1 += roundSum1;
					sum2 += roundSum2;
					$("[competitor='1'] [round='"+round+"'] [judge='sum'] input", obj.el).val(String(roundSum1));
					$("[competitor='2'] [round='"+round+"'] [judge='sum'] input", obj.el).val(String(roundSum2));
				}
				$("[competitor='1'] input.fightPointsSummaryInput", obj.el).val(String(sum1));
				$("[competitor='2'] input.fightPointsSummaryInput", obj.el).val(String(sum2));
			}

			function calculateNewazaPointsSum() {
				if (Number($("input[name='hansokumake1']", obj.el).val()) > 0) {
					$("input[name='sum1']",obj.el).val("0");
					$("input[name='sum2']",obj.el).val(constants.newazaFinishingMovePoints);
				}
				else if (Number($("input[name='hansokumake2']", obj.el).val()) > 0) {
					$("input[name='sum1']",obj.el).val(constants.newazaFinishingMovePoints);
					$("input[name='sum2']",obj.el).val("0");
				}
				else if (Number($("input[name='point1_100']", obj.el).val()) > 0) {
					$("input[name='sum1']",obj.el).val(constants.newazaFinishingMovePoints);
					$("input[name='sum2']",obj.el).val("0");
				}
				else if (Number($("input[name='point2_100']", obj.el).val()) > 0) {
					$("input[name='sum1']",obj.el).val("0");
					$("input[name='sum2']",obj.el).val(constants.newazaFinishingMovePoints);
				}
				else {
					var sum1 = Number($("input[name='point1_2']",obj.el).val()) * 2
					+ Number($("input[name='point1_3']",obj.el).val()) * 3
					+ Number($("input[name='point1_4']",obj.el).val()) * 4;

					var sum2 = Number($("input[name='point2_2']",obj.el).val()) * 2
					+ Number($("input[name='point2_3']",obj.el).val()) * 3
					+ Number($("input[name='point2_4']",obj.el).val()) * 4;

					$("input[name='sum1']",obj.el).val(sum1);
					$("input[name='sum2']",obj.el).val(sum2);
				}
			}

			function calculateDuo2023PointsSum() {
				var sum1 = 0;
				var sum2 = 0;

				var inputs1 = $("[competitor='1'] input.duoPresentationPointsInput", obj.el);
				var inputs2 = $("[competitor='2'] input.duoPresentationPointsInput", obj.el);

				for (var i = 0; i < inputs1.length; i++) {
					var points = Number($(inputs1[i]).val());
					if (isValidNumber(points)) {
						sum1 += points;
					}
				}
				for (var i = 0; i < inputs2.length; i++) {
					var points = Number($(inputs2[i]).val());
					if (isValidNumber(points)) {
						sum2 += points;
					}
				}

				var variety13 = Number($("[competitor='1'] input[name='varietyP3']", obj.el).val());
				if (isValidNumber(variety13)) {
					sum1 += variety13;
				}

				var variety14 = Number($("[competitor='1'] input[name='varietyP4']", obj.el).val());
				if (isValidNumber(variety14)) {
					sum1 += variety14;
				}

				var variety23 = Number($("[competitor='2'] input[name='varietyP3']", obj.el).val());
				if (isValidNumber(variety23)) {
					sum2 += variety23;
				}

				var variety24 = Number($("[competitor='2'] input[name='varietyP4']", obj.el).val());
				if (isValidNumber(variety24)) {
					sum2 += variety24;
				}

				var penalty1 = Number($("[competitor='1'] input[name='penalty']", obj.el).val());
				if (isValidNumber(penalty1)) {
					sum1 -= penalty1;
				}

				var penalty2 = Number($("[competitor='2'] input[name='penalty']", obj.el).val());
				if (isValidNumber(penalty2)) {
					sum2 -= penalty2;
				}

				$("[competitor='1'] input.fightPointsSummaryInput", obj.el).val(String(sum1));
				$("[competitor='2'] input.fightPointsSummaryInput", obj.el).val(String(sum2));
			}

			if (this.model.match.get("type") == "FIGHT") {
				$(this.el).html(Mustache.render(this.fightTemplate, this.model.points.toJSON()));

				$("input.fightPointsInput", this.el).on("change", function() {
					calculateFightPointsSum();
				});

				calculateFightPointsSum();

				$("input.fightPointsInput", this.el).spinner({
					"min": 0,
					"change": function() {
						calculateFightPointsSum();
					},
					"stop": function() {
						calculateFightPointsSum();
					}
				});
			}
			else if (this.model.match.get("type") == "DUO") {
				$(this.el).html(Mustache.render(this.duoTemplate, this.model.points.toJSON()));

				$("input.duoPointsInput", this.el).on("change",function() {
					calculateDuoPointsSum();
				});

				calculateDuoPointsSum();
			}
			else if (this.model.match.get("type") == "NEWAZA") {
				$(this.el).html(Mustache.render(this.newazaTemplate,this.model.points.toJSON()));

				$("input.newazaPointsInput", this.el).on("change",function() {
					calculateNewazaPointsSum();
				});

				calculateNewazaPointsSum();

				$("input.newazaPointsInput", this.el).spinner({
					"min":0,
					"change":function() {
						calculateNewazaPointsSum();
					},
					"stop":function() {
						calculateNewazaPointsSum();
					}
				});
			}
			else if (this.model.match.get("type") == "DUO2023") {
                $(this.el).html(Mustache.render(this.duo2023Template, this.model.points.toJSON()));

                $("[competitor='1'] input.duoPresentationPointsInput", obj.el).val("0");
                $("[competitor='2'] input.duoPresentationPointsInput", obj.el).val("0");

                for (var dpp of obj.model.points.get("points1")) {
                    $("[competitor='1'] input[judge='" + String(dpp.judge) + "'][series='" + dpp.series + "'][attack='" + String(dpp.attack) + "'][part='" + String(dpp.part) + "']", obj.el).val(dpp.points);
                }
                for (var dpp of obj.model.points.get("points2")) {
                    $("[competitor='2'] input[judge='" + String(dpp.judge) + "'][series='" + dpp.series + "'][attack='" + String(dpp.attack) + "'][part='" + String(dpp.part) + "']", obj.el).val(dpp.points);
                }

                $("[competitor='1'] input[name='varietyP3']", obj.el).val(obj.model.points.get("variety1P3"));
                $("[competitor='1'] input[name='varietyP4']", obj.el).val(obj.model.points.get("variety1P4"));
                $("[competitor='2'] input[name='varietyP3']", obj.el).val(obj.model.points.get("variety2P3"));
                $("[competitor='2'] input[name='varietyP4']", obj.el).val(obj.model.points.get("variety2P4"));

                $("[competitor='1'] input[name='penalty']", obj.el).val(obj.model.points.get("penalty1"));
                $("[competitor='2'] input[name='penalty']", obj.el).val(obj.model.points.get("penalty2"));

                $("input.duoPresentationPointsInput", this.el).on("change", function() {
					calculateDuo2023PointsSum();
                });

                $("input[name='varietyP3']", this.el).on("change", function() {
					calculateDuo2023PointsSum();
                });

                $("input[name='varietyP4']", this.el).on("change", function() {
					calculateDuo2023PointsSum();
                });

                $("input[name='penalty']", this.el).on("change", function() {
					calculateDuo2023PointsSum();
                });

				calculateDuo2023PointsSum();
            }

			$(".btn-primary", this.el).on("click",function() {
				if (obj.model.match.get("type") == "FIGHT") {
					$("input.fightPointsInput", obj.el).each(function(index, item) {
						var name = $(this).attr("name");
						var value = Math.round(Number($(this).val()));
						obj.model.points.set(name, value);
					});

					if ($("input[name='matchTime']", obj.el).val().length > 0) {
						obj.model.points.set("matchTime", Math.round(Number($("input[name='matchTime']", obj.el).val())));
					}
					else {
						obj.model.points.set("matchTime", null);
					}

					if ($("input[name='hosekomiTime']", obj.el).val().length > 0) {
						obj.model.points.set("hosekomiTime", Math.round(Number($("input[name='hosekomiTime']", obj.el).val())));
					}
					else {
						obj.model.points.set("hosekomiTime", null);
					}
				}
				else if (obj.model.match.get("type") == "DUO") {
					for (var round = 1; round <= 5; round++) {
						for (var judge = 1; judge <= 5; judge++) {
							var points1 = Number($("[competitor='1'] [round='" + round + "'] [judge='" + judge + "'] input", obj.el).val());
							var points2 = Number($("[competitor='2'] [round='" + round + "'] [judge='" + judge + "'] input", obj.el).val());
							obj.model.points.get("rounds1")[round-1].judges[judge-1].points = points1;
							obj.model.points.get("rounds2")[round-1].judges[judge-1].points = points2;
						}
					}
				}
				else if (obj.model.match.get("type") == "NEWAZA") {
					$("input.newazaPointsInput", obj.el).each(function(index, item) {
						var name = $(this).attr("name");
						var value = Math.round(Number($(this).val()));
						obj.model.points.set(name,value);
					});

					if ($("input[name='matchTime']", obj.el).val().length > 0) {
						obj.model.points.set("matchTime", Math.round(Number($("input[name='matchTime']", obj.el).val())));
					}
					else {
						obj.model.points.set("matchTime", null);
					}

					if ($("input[name='hosekomiTime']", obj.el).val().length > 0) {
						obj.model.points.set("hosekomiTime", Math.round(Number($("input[name='hosekomiTime']", obj.el).val())));
					}
					else {
						obj.model.points.set("hosekomiTime", null);
					}
				}
				else if (obj.model.match.get("type") == "DUO2023") {
                    var points1 = [];
                    var points2 = [];

                    var inputs1 = $("[competitor='1'] input.duoPresentationPointsInput", obj.el);
                    for (var i = 0; i < inputs1.length; i++) {
                        var input = $(inputs1[i]);
                        var p = Number(input.val());
                        if (isValidNumber(p)) {
                            points1.push({
                                "judge": Number(input.attr("judge")),
                                "series": input.attr("series"),
                                "attack": Number(input.attr("attack")),
                                "part": Number(input.attr("part")),
                                "points": p
                            });
                        }
                    }

                    var inputs2 = $("[competitor='2'] input.duoPresentationPointsInput", obj.el);
                    for (var i = 0; i < inputs2.length; i++) {
                        var input = $(inputs2[i]);
                        var p = Number(input.val());
                        if (isValidNumber(p)) {
                            points2.push({
                                "judge": Number(input.attr("judge")),
                                "series": input.attr("series"),
                                "attack": Number(input.attr("attack")),
                                "part": Number(input.attr("part")),
                                "points": p
                            });
                        }
                    }

                    obj.model.points.set("points1", points1);
                    obj.model.points.set("points2", points2);

                    var variety13 = Number($("[competitor='1'] input[name='varietyP3']", obj.el).val());
                    if (isValidNumber(variety13)) {
                        obj.model.points.set("variety1P3", variety13);
                    }
                    else {
                        obj.model.points.set("variety1P3", 0);
                    }

                    var variety14 = Number($("[competitor='1'] input[name='varietyP4']", obj.el).val());
                    if (isValidNumber(variety14)) {
                        obj.model.points.set("variety1P4", variety14);
                    }
                    else {
                        obj.model.points.set("variety1P4", 0);
                    }

                    var variety23 = Number($("[competitor='2'] input[name='varietyP3']", obj.el).val());
                    if (isValidNumber(variety23)) {
                        obj.model.points.set("variety2P3", variety23);
                    }
                    else {
                        obj.model.points.set("variety2P3", 0);
                    }

                    var variety24 = Number($("[competitor='2'] input[name='varietyP4']", obj.el).val());
                    if (isValidNumber(variety24)) {
                        obj.model.points.set("variety2P4", variety24);
                    }
                    else {
                        obj.model.points.set("variety2P4", 0);
                    }

                    var penalty1 = Number($("[competitor='1'] input[name='penalty']", obj.el).val());
                    if (isValidNumber(penalty1)) {
                        obj.model.points.set("penalty1", penalty1);
                    }
                    else {
                        obj.model.points.set("penalty1", 0);
                    }

                    var penalty2 = Number($("[competitor='2'] input[name='penalty']", obj.el).val());
                    if (isValidNumber(penalty2)) {
                        obj.model.points.set("penalty2", penalty2);
                    }
                    else {
                        obj.model.points.set("penalty2", 0);
                    }
				}

				if ($("input[name='injuryTime1']", obj.el).val().length > 0) {
					obj.model.points.set("injuryTime1", Math.round(Number($("input[name='injuryTime1']", obj.el).val())));
				}
				else {
					obj.model.points.set("injuryTime1", null);
				}
				if ($("input[name='injuryTime2']", obj.el).val().length > 0) {
					obj.model.points.set("injuryTime2", Math.round(Number($("input[name='injuryTime2']", obj.el).val())));
				}
				else {
					obj.model.points.set("injuryTime2",null);
				}

				if ($("input[name='challengesWon1']", obj.el).val().length > 0) {
                    obj.model.points.set("challengesWon1", Math.round(Number($("input[name='challengesWon1']", obj.el).val())));
                }
                else {
                    obj.model.points.set("challengesWon1", null);
                }
                if ($("input[name='challengesWon2']", obj.el).val().length > 0) {
                    obj.model.points.set("challengesWon2", Math.round(Number($("input[name='challengesWon2']", obj.el).val())));
                }
                else {
                    obj.model.points.set("challengesWon2", null);
                }
                if ($("input[name='challengesLost1']", obj.el).val().length > 0) {
                    obj.model.points.set("challengesLost1", Math.round(Number($("input[name='challengesLost1']", obj.el).val())));
                }
                else {
                    obj.model.points.set("challengesLost1", null);
                }
                if ($("input[name='challengesLost2']", obj.el).val().length > 0) {
                    obj.model.points.set("challengesLost2", Math.round(Number($("input[name='challengesLost2']", obj.el).val())));
                }
                else {
                    obj.model.points.set("challengesLost2", null);
                }

				obj.model.points.set("noWinner", $("input[name='noWinner']", obj.el).is(":checked"));
				obj.model.points.set("finished", $("input[name='finished']", obj.el).is(":checked"));

				$.ajax({
					"async": false,
					"url": obj.model.points.url() + "?matchId=" + obj.model.match.get("id"),
					"type": "POST",
					"contentType": "application/json; charset=utf-8",
					"data": JSON.stringify(obj.model.points.toJSON())
				});
				$(obj.el).modal("hide");
				jtekma.reloadData();
			});

			this.$el.find(".copyPoints").click(() => {
				if (obj.model.match.get("type") == "FIGHT") {
					let data = "";
					data += $("input[name='wazari1']", obj.el).val() + "\t";
					data += $("input[name='ippon1_1']", obj.el).val() + "\t";
					data += $("input[name='ippon1_2']", obj.el).val() + "\t";
					data += $("input[name='ippon1_3']", obj.el).val() + "\t";
					data += $("input[name='ippon1_1_3p']", obj.el).val() + "\t";
					data += $("input[name='ippon1_2_3p']", obj.el).val() + "\t";
					data += $("input[name='ippon1_3_3p']", obj.el).val() + "\t";
					data += $("input[name='shido1']", obj.el).val() + "\t";
					data += $("input[name='chui1']", obj.el).val() + "\t";
					data += $("input[name='hansokumake1']", obj.el).val() + "\t";
					data += $("input[name='challengesWon1']", obj.el).val() + "\t";
					data += $("input[name='challengesLost1']", obj.el).val() + "\n";

					data += $("input[name='wazari2']", obj.el).val() + "\t";
					data += $("input[name='ippon2_1']", obj.el).val() + "\t";
					data += $("input[name='ippon2_2']", obj.el).val() + "\t";
					data += $("input[name='ippon2_3']", obj.el).val() + "\t";
					data += $("input[name='ippon2_1_3p']", obj.el).val() + "\t";
					data += $("input[name='ippon2_2_3p']", obj.el).val() + "\t";
					data += $("input[name='ippon2_3_3p']", obj.el).val() + "\t";
					data += $("input[name='shido2']", obj.el).val() + "\t";
					data += $("input[name='chui2']", obj.el).val() + "\t";
					data += $("input[name='hansokumake2']", obj.el).val() + "\t";
					data += $("input[name='challengesWon2']", obj.el).val() + "\t";
					data += $("input[name='challengesLost2']", obj.el).val();

					navigator.clipboard.writeText(data);
				}
				else if (obj.model.match.get("type") == "NEWAZA") {
					let data = "";
					data += $("input[name='point1_2']", obj.el).val() + "\t";
					data += $("input[name='point1_3']", obj.el).val() + "\t";
					data += $("input[name='point1_4']", obj.el).val() + "\t";
					data += $("input[name='point1_100']", obj.el).val() + "\t";
					data += $("input[name='advantage1']", obj.el).val() + "\t";
					data += $("input[name='penalty1']", obj.el).val() + "\t";
					data += $("input[name='hansokumake1']", obj.el).val() + "\t";
					data += $("input[name='challengesWon1']", obj.el).val() + "\t";
					data += $("input[name='challengesLost1']", obj.el).val() + "\n";

					data += $("input[name='point2_2']", obj.el).val() + "\t";
					data += $("input[name='point2_3']", obj.el).val() + "\t";
					data += $("input[name='point2_4']", obj.el).val() + "\t";
					data += $("input[name='point2_100']", obj.el).val() + "\t";
					data += $("input[name='advantage2']", obj.el).val() + "\t";
					data += $("input[name='penalty2']", obj.el).val() + "\t";
					data += $("input[name='hansokumake2']", obj.el).val() + "\t";
					data += $("input[name='challengesWon2']", obj.el).val() + "\t";
					data += $("input[name='challengesLost2']", obj.el).val();

					navigator.clipboard.writeText(data);
				}
				else if (obj.model.match.get("type") == "DUO") {
					let data = "";

					for (let r = 1; r <= 5; r++) {
						for (let j = 1; j <= 5; j++) {
							data += $("[competitor='1'] [round='" + r + "'] [judge='" + j + "'] input", obj.el).val() + "\t";
						}
					}

					data += $("input[name='challengesWon1']", obj.el).val() + "\t";
					data += $("input[name='challengesLost1']", obj.el).val() + "\n";


					for (let r = 1; r <= 5; r++) {
						for (let j = 1; j <= 5; j++) {
							data += $("[competitor='2'] [round='" + r + "'] [judge='" + j + "'] input", obj.el).val() + "\t";
						}
					}

					data += $("input[name='challengesWon2']", obj.el).val() + "\t";
					data += $("input[name='challengesLost2']", obj.el).val();

					navigator.clipboard.writeText(data);
				}
				else if (obj.model.match.get("type") == "DUO2023") {
					let inputs1 = $("[competitor='1'] input.duoPresentationPointsInput", obj.el);
					let inputs2 = $("[competitor='2'] input.duoPresentationPointsInput", obj.el);

					let data = "";

					for (var i = 0; i < inputs1.length; i++) {
						data += $(inputs1[i]).val() + "\t";
					}

					data += $("[competitor='1'] input[name='varietyP3']", obj.el).val() + "\t";
					data += $("[competitor='1'] input[name='varietyP4']", obj.el).val() + "\t";
					data += $("[competitor='1'] input[name='penalty']", obj.el).val() + "\t";
					data += $("input[name='challengesWon1']", obj.el).val() + "\t";
					data += $("input[name='challengesLost1']", obj.el).val() + "\n";

					for (var i = 0; i < inputs2.length; i++) {
						data += $(inputs2[i]).val() + "\t";
					}

					data += $("[competitor='2'] input[name='varietyP3']", obj.el).val() + "\t";
					data += $("[competitor='2'] input[name='varietyP4']", obj.el).val() + "\t";
					data += $("[competitor='2'] input[name='penalty']", obj.el).val() + "\t";
					data += $("input[name='challengesWon2']", obj.el).val() + "\t";
					data += $("input[name='challengesLost2']", obj.el).val();

					navigator.clipboard.writeText(data);
				}
			});

			this.$el.find(".pastePoints").click(() => {
				if (obj.model.match.get("type") == "FIGHT") {
					let data = navigator.clipboard.readText();
					data.then((value) => {
						let rows = String(value).split("\n");
						if (rows.length != 2) {
							return;
						}

						let points1 = rows[0].split("\t");
						if (points1.length != 12) {
							return;
						}

						let points2 = rows[1].split("\t");
						if (points2.length != 12) {
							return;
						}

						$("input[name='wazari1']", obj.el).val(points1[0]);
						$("input[name='ippon1_1']", obj.el).val(points1[1]);
						$("input[name='ippon1_2']", obj.el).val(points1[2]);
						$("input[name='ippon1_3']", obj.el).val(points1[3]);
						$("input[name='ippon1_1_3p']", obj.el).val(points1[4]);
						$("input[name='ippon1_2_3p']", obj.el).val(points1[5]);
						$("input[name='ippon1_3_3p']", obj.el).val(points1[6]);
						$("input[name='shido1']", obj.el).val(points1[7]);
						$("input[name='chui1']", obj.el).val(points1[8]);
						$("input[name='hansokumake1']", obj.el).val(points1[9]);
						$("input[name='challengesWon1']", obj.el).val(points1[10]);
						$("input[name='challengesLost1']", obj.el).val(points1[11]);

						$("input[name='wazari2']", obj.el).val(points2[0]);
						$("input[name='ippon2_1']", obj.el).val(points2[1]);
						$("input[name='ippon2_2']", obj.el).val(points2[2]);
						$("input[name='ippon2_3']", obj.el).val(points2[3]);
						$("input[name='ippon2_1_3p']", obj.el).val(points2[4]);
						$("input[name='ippon2_2_3p']", obj.el).val(points2[5]);
						$("input[name='ippon2_3_3p']", obj.el).val(points2[6]);
						$("input[name='shido2']", obj.el).val(points2[7]);
						$("input[name='chui2']", obj.el).val(points2[8]);
						$("input[name='hansokumake2']", obj.el).val(points2[9]);
						$("input[name='challengesWon2']", obj.el).val(points2[10]);
						$("input[name='challengesLost2']", obj.el).val(points2[11]);

						calculateFightPointsSum();
					});
				}
				else if (obj.model.match.get("type") == "NEWAZA") {
					let data = navigator.clipboard.readText();
					data.then((value) => {
						let rows = String(value).split("\n");
						if (rows.length != 2) {
							return;
						}

						let points1 = rows[0].split("\t");
						if (points1.length != 9) {
							return;
						}

						let points2 = rows[1].split("\t");
						if (points2.length != 9) {
							return;
						}

						$("input[name='point1_2']", obj.el).val(points1[0]);
						$("input[name='point1_3']", obj.el).val(points1[1]);
						$("input[name='point1_4']", obj.el).val(points1[2]);
						$("input[name='point1_100']", obj.el).val(points1[3]);
						$("input[name='advantage1']", obj.el).val(points1[4]);
						$("input[name='penalty1']", obj.el).val(points1[5]);
						$("input[name='hansokumake1']", obj.el).val(points1[6]);
						$("input[name='challengesWon1']", obj.el).val(points1[7]);
						$("input[name='challengesLost1']", obj.el).val(points1[8]);

						$("input[name='point2_2']", obj.el).val(points2[0]);
						$("input[name='point2_3']", obj.el).val(points2[1]);
						$("input[name='point2_4']", obj.el).val(points2[2]);
						$("input[name='point2_100']", obj.el).val(points2[3]);
						$("input[name='advantage2']", obj.el).val(points2[4]);
						$("input[name='penalty2']", obj.el).val(points2[5]);
						$("input[name='hansokumake2']", obj.el).val(points2[6]);
						$("input[name='challengesWon2']", obj.el).val(points2[7]);
						$("input[name='challengesLost2']", obj.el).val(points2[8]);

						calculateNewazaPointsSum();
					});
				}
				else if (obj.model.match.get("type") == "DUO") {
					let data = navigator.clipboard.readText();
					data.then((value) => {
						let rows = String(value).split("\n");
						if (rows.length != 2) {
							return;
						}

						let points1 = rows[0].split("\t");
						if (points1.length != 27) {
							return;
						}

						let points2 = rows[1].split("\t");
						if (points2.length != 27) {
							return;
						}

						let n = 0;
						for (let r = 1; r <= 5; r++) {
							for (let j = 1; j <= 5; j++) {
								$("[competitor='1'] [round='" + r + "'] [judge='" + j + "'] input", obj.el).val(points1[n++]);
							}
						}

						$("input[name='challengesWon1']", obj.el).val(points1[25]);
						$("input[name='challengesLost1']", obj.el).val(points1[26]);

						n = 0;
						for (let r = 1; r <= 5; r++) {
							for (let j = 1; j <= 5; j++) {
								$("[competitor='2'] [round='" + r + "'] [judge='" + j + "'] input", obj.el).val(points2[n++]);
							}
						}

						$("input[name='challengesWon2']", obj.el).val(points2[25]);
						$("input[name='challengesLost2']", obj.el).val(points2[26]);

						calculateDuoPointsSum();
					});
				}
				else if (obj.model.match.get("type") == "DUO2023") {
					let data = navigator.clipboard.readText();
					data.then((value) => {
						let inputs1 = $("[competitor='1'] input.duoPresentationPointsInput", obj.el);
						let inputs2 = $("[competitor='2'] input.duoPresentationPointsInput", obj.el);

						let rows = String(value).split("\n");
						if (rows.length != 2) {
							return;
						}

						let points1 = rows[0].split("\t");
						if (points1.length != inputs1.length + 5) {
							return;
						}

						let points2 = rows[1].split("\t");
						if (points2.length != inputs2.length + 5) {
							return;
						}

						for (var i = 0; i < inputs1.length; i++) {
							$(inputs1[i]).val(points1[i]);
						}

						$("[competitor='1'] input[name='varietyP3']", obj.el).val(points1[inputs1.length]);
						$("[competitor='1'] input[name='varietyP4']", obj.el).val(points1[inputs1.length + 1]);
						$("[competitor='1'] input[name='penalty']", obj.el).val(points1[inputs1.length + 2]);
						$("input[name='challengesWon1']", obj.el).val(points1[inputs1.length + 3]);
						$("input[name='challengesLost1']", obj.el).val(points1[inputs1.length + 4]);

						for (var i = 0; i < inputs2.length; i++) {
							$(inputs2[i]).val(points2[i]);
						}

						$("[competitor='2'] input[name='varietyP3']", obj.el).val(points2[inputs2.length]);
						$("[competitor='2'] input[name='varietyP4']", obj.el).val(points2[inputs2.length + 1]);
						$("[competitor='2'] input[name='penalty']", obj.el).val(points2[inputs2.length + 2]);
						$("input[name='challengesWon2']", obj.el).val(points2[inputs2.length + 3]);
						$("input[name='challengesLost2']", obj.el).val(points2[inputs2.length + 4]);

						calculateDuo2023PointsSum();
					});
				}
			});

			this.$el.find(".flipPoints").click(() => {
				if (obj.model.match.get("type") == "FIGHT") {
					let wazari1 = $("input[name='wazari1']", obj.el).val();
					let ippon11 = $("input[name='ippon1_1']", obj.el).val();
					let ippon12 = $("input[name='ippon1_2']", obj.el).val();
					let ippon13 = $("input[name='ippon1_3']", obj.el).val();
					let ippon113p = $("input[name='ippon1_1_3p']", obj.el).val();
					let ippon123p = $("input[name='ippon1_2_3p']", obj.el).val();
					let ippon133p = $("input[name='ippon1_3_3p']", obj.el).val();
					let shido1 = $("input[name='shido1']", obj.el).val();
					let chui1 = $("input[name='chui1']", obj.el).val();
					let hansokumake1 = $("input[name='hansokumake1']", obj.el).val();
					let challengesWon1 = $("input[name='challengesWon1']", obj.el).val();
					let challengesLost1 = $("input[name='challengesLost1']", obj.el).val();

					let wazari2 = $("input[name='wazari2']", obj.el).val();
					let ippon21 = $("input[name='ippon2_1']", obj.el).val();
					let ippon22 = $("input[name='ippon2_2']", obj.el).val();
					let ippon23 = $("input[name='ippon2_3']", obj.el).val();
					let ippon213p = $("input[name='ippon2_1_3p']", obj.el).val();
					let ippon223p = $("input[name='ippon2_2_3p']", obj.el).val();
					let ippon233p = $("input[name='ippon2_3_3p']", obj.el).val();
					let shido2 = $("input[name='shido2']", obj.el).val();
					let chui2 = $("input[name='chui2']", obj.el).val();
					let hansokumake2 = $("input[name='hansokumake2']", obj.el).val();
					let challengesWon2 = $("input[name='challengesWon2']", obj.el).val();
					let challengesLost2 = $("input[name='challengesLost2']", obj.el).val();

					$("input[name='wazari1']", obj.el).val(wazari2);
					$("input[name='ippon1_1']", obj.el).val(ippon21);
					$("input[name='ippon1_2']", obj.el).val(ippon22);
					$("input[name='ippon1_3']", obj.el).val(ippon23);
					$("input[name='ippon1_1_3p']", obj.el).val(ippon213p);
					$("input[name='ippon1_2_3p']", obj.el).val(ippon223p);
					$("input[name='ippon1_3_3p']", obj.el).val(ippon233p);
					$("input[name='shido1']", obj.el).val(shido2);
					$("input[name='chui1']", obj.el).val(chui2);
					$("input[name='hansokumake1']", obj.el).val(hansokumake2);
					$("input[name='challengesWon1']", obj.el).val(challengesWon2);
					$("input[name='challengesLost1']", obj.el).val(challengesLost2);

					$("input[name='wazari2']", obj.el).val(wazari1);
					$("input[name='ippon2_1']", obj.el).val(ippon11);
					$("input[name='ippon2_2']", obj.el).val(ippon12);
					$("input[name='ippon2_3']", obj.el).val(ippon13);
					$("input[name='ippon2_1_3p']", obj.el).val(ippon113p);
					$("input[name='ippon2_2_3p']", obj.el).val(ippon123p);
					$("input[name='ippon2_3_3p']", obj.el).val(ippon133p);
					$("input[name='shido2']", obj.el).val(shido1);
					$("input[name='chui2']", obj.el).val(chui1);
					$("input[name='hansokumake2']", obj.el).val(hansokumake1);
					$("input[name='challengesWon2']", obj.el).val(challengesWon1);
					$("input[name='challengesLost2']", obj.el).val(challengesLost1);

					calculateFightPointsSum();
				}
				else if (obj.model.match.get("type") == "NEWAZA") {
					let point12 = $("input[name='point1_2']", obj.el).val();
					let point13 = $("input[name='point1_3']", obj.el).val();
					let point14 = $("input[name='point1_4']", obj.el).val();
					let point1100 = $("input[name='point1_100']", obj.el).val();
					let advantage1 = $("input[name='advantage1']", obj.el).val();
					let penalty1 = $("input[name='penalty1']", obj.el).val();
					let hansokumake1 = $("input[name='hansokumake1']", obj.el).val();
					let challengesWon1 = $("input[name='challengesWon1']", obj.el).val();
					let challengesLost1 = $("input[name='challengesLost1']", obj.el).val();

					let point22 = $("input[name='point2_2']", obj.el).val();
					let point23 = $("input[name='point2_3']", obj.el).val();
					let point24 = $("input[name='point2_4']", obj.el).val();
					let point2100 = $("input[name='point2_100']", obj.el).val();
					let advantage2 = $("input[name='advantage2']", obj.el).val();
					let penalty2 = $("input[name='penalty2']", obj.el).val();
					let hansokumake2 = $("input[name='hansokumake2']", obj.el).val();
					let challengesWon2 = $("input[name='challengesWon2']", obj.el).val();
					let challengesLost2 = $("input[name='challengesLost2']", obj.el).val();

					$("input[name='point1_2']", obj.el).val(point22);
					$("input[name='point1_3']", obj.el).val(point23);
					$("input[name='point1_4']", obj.el).val(point24);
					$("input[name='point1_100']", obj.el).val(point2100);
					$("input[name='advantage1']", obj.el).val(advantage2);
					$("input[name='penalty1']", obj.el).val(penalty2);
					$("input[name='hansokumake1']", obj.el).val(hansokumake2);
					$("input[name='challengesWon1']", obj.el).val(challengesWon2);
					$("input[name='challengesLost1']", obj.el).val(challengesLost2);

					$("input[name='point2_2']", obj.el).val(point12);
					$("input[name='point2_3']", obj.el).val(point13);
					$("input[name='point2_4']", obj.el).val(point14);
					$("input[name='point2_100']", obj.el).val(point1100);
					$("input[name='advantage2']", obj.el).val(advantage1);
					$("input[name='penalty2']", obj.el).val(penalty1);
					$("input[name='hansokumake2']", obj.el).val(hansokumake1);
					$("input[name='challengesWon2']", obj.el).val(challengesWon1);
					$("input[name='challengesLost2']", obj.el).val(challengesLost1);

					calculateNewazaPointsSum();
				}
				else if (obj.model.match.get("type") == "DUO") {
					let points1 = [];
					let points2 = [];

					for (let r = 1; r <= 5; r++) {
						points1[r - 1] = [];
						points2[r - 1] = [];
						for (let j = 1; j <= 5; j++) {
							points1[r - 1][j - 1] = $("[competitor='1'] [round='" + r + "'] [judge='" + j + "'] input", obj.el).val();
							points2[r - 1][j - 1] = $("[competitor='2'] [round='" + r + "'] [judge='" + j + "'] input", obj.el).val();
						}
					}

					for (let r = 1; r <= 5; r++) {
						for (let j = 1; j <= 5; j++) {
							$("[competitor='1'] [round='" + r + "'] [judge='" + j + "'] input", obj.el).val(points2[r - 1][j - 1]);
							$("[competitor='2'] [round='" + r + "'] [judge='" + j + "'] input", obj.el).val(points1[r - 1][j - 1]);
						}
					}

					let challengesWon1 = $("input[name='challengesWon1']", obj.el).val();
					let challengesLost1 = $("input[name='challengesLost1']", obj.el).val();

					let challengesWon2 = $("input[name='challengesWon2']", obj.el).val();
					let challengesLost2 = $("input[name='challengesLost2']", obj.el).val();

					$("input[name='challengesWon1']", obj.el).val(challengesWon2);
					$("input[name='challengesLost1']", obj.el).val(challengesLost2);

					$("input[name='challengesWon2']", obj.el).val(challengesWon1);
					$("input[name='challengesLost2']", obj.el).val(challengesLost1);

					calculateDuoPointsSum();
				}
				else if (obj.model.match.get("type") == "DUO2023") {
					let points1 = [];
					let points2 = [];

					let inputs1 = $("[competitor='1'] input.duoPresentationPointsInput", obj.el);
					let inputs2 = $("[competitor='2'] input.duoPresentationPointsInput", obj.el);

					for (var i = 0; i < inputs1.length; i++) {
						let j = $(inputs1[i]).attr("judge");
						let s = $(inputs1[i]).attr("series");
						let a = $(inputs1[i]).attr("attack");
						let p = $(inputs1[i]).attr("part");
						points1[j + "_" + s + "_" + a + "_" + p] = $(inputs1[i]).val();
					}
					for (var i = 0; i < inputs2.length; i++) {
						let j = $(inputs2[i]).attr("judge");
						let s = $(inputs2[i]).attr("series");
						let a = $(inputs2[i]).attr("attack");
						let p = $(inputs2[i]).attr("part");
						points2[j + "_" + s + "_" + a + "_" + p] = $(inputs2[i]).val();
					}

					let variety1P3 = $("[competitor='1'] input[name='varietyP3']", obj.el).val();
					let variety1P4 = $("[competitor='1'] input[name='varietyP4']", obj.el).val();
					let penalty1 = $("[competitor='1'] input[name='penalty']", obj.el).val();
					let challengesWon1 = $("input[name='challengesWon1']", obj.el).val();
					let challengesLost1 = $("input[name='challengesLost1']", obj.el).val();

					let variety2P3 = $("[competitor='2'] input[name='varietyP3']", obj.el).val();
					let variety2P4 = $("[competitor='2'] input[name='varietyP4']", obj.el).val();
					let penalty2 = $("[competitor='2'] input[name='penalty']", obj.el).val();
					let challengesWon2 = $("input[name='challengesWon2']", obj.el).val();
					let challengesLost2 = $("input[name='challengesLost2']", obj.el).val();

					for (var i = 0; i < inputs1.length; i++) {
						let j = $(inputs1[i]).attr("judge");
						let s = $(inputs1[i]).attr("series");
						let a = $(inputs1[i]).attr("attack");
						let p = $(inputs1[i]).attr("part");
						$(inputs1[i]).val(points2[j + "_" + s + "_" + a + "_" + p]);
					}
					for (var i = 0; i < inputs2.length; i++) {
						let j = $(inputs2[i]).attr("judge");
						let s = $(inputs2[i]).attr("series");
						let a = $(inputs2[i]).attr("attack");
						let p = $(inputs2[i]).attr("part");
						$(inputs2[i]).val(points1[j + "_" + s + "_" + a + "_" + p]);
					}

					$("[competitor='1'] input[name='varietyP3']", obj.el).val(variety2P3);
					$("[competitor='1'] input[name='varietyP4']", obj.el).val(variety2P4);
					$("[competitor='1'] input[name='penalty']", obj.el).val(penalty2);
					$("input[name='challengesWon1']", obj.el).val(challengesWon2);
					$("input[name='challengesLost1']", obj.el).val(challengesLost2);

					$("[competitor='2'] input[name='varietyP3']", obj.el).val(variety1P3);
					$("[competitor='2'] input[name='varietyP4']", obj.el).val(variety1P4);
					$("[competitor='2'] input[name='penalty']", obj.el).val(penalty1);
					$("input[name='challengesWon2']", obj.el).val(challengesWon1);
					$("input[name='challengesLost2']", obj.el).val(challengesLost1);

					calculateDuo2023PointsSum();
				}
			});

			this.$el.find("[rel='tooltip']").tooltip();

			return this;
		}
	});

})();