(function() {
    var jtekma = definePackage("jtekma");
    var models = definePackage("jtekma.models");
    var views = definePackage("jtekma.views");

	views.TableOrTreeView = Backbone.View.extend({
		"initialize": function() {

		},
		"render":function() {
			$(this.el).html("");

			var category = jtekma.displaySettings.get("category");
			var treeCategoryOptions = category.get("treeCategoryOptions");

			category.fetch({
				"async": false
			});

			if (category.get("type") == "FIGHTING" || category.get("type") == "DUO" || category.get("type") == "NEWAZA") {
				if ((treeCategoryOptions.treeType == "TABLE2")
						|| (treeCategoryOptions.treeType == "TABLE3")
						|| (treeCategoryOptions.treeType == "TABLE4")
						|| (treeCategoryOptions.treeType == "TABLE5")) {

					var tableModel = new models.TableModel();
					tableModel.fetch({
						"data": {
							"categoryId": category.get("id")
						},
						"async": false
					});

					if (treeCategoryOptions.treeType == "TABLE2") {
						tableModel.set("num", [1,2]);
					}
					else if (treeCategoryOptions.treeType == "TABLE3") {
						tableModel.set("num", [1,2,3]);
					}
					else if (treeCategoryOptions.treeType == "TABLE4") {
						tableModel.set("num", [1,2,3,4]);
					}
					else if (treeCategoryOptions.treeType == "TABLE5") {
						tableModel.set("num", [1,2,3,4,5]);
					}

					var tableView = new views.TableView({
						"el": $(this.el),
						"model": tableModel
					});
					tableView.render();
				}
				else if (treeCategoryOptions.treeType == "TREE6") {
					var data = {
						"tree6Table": new models.Tree6TableModel(),
						"matches": new models.MatchCollection()
					};
					new views.Tree6TablesView({
						"el": $(this.el),
						"model": data
					});
					data.tree6Table.fetch({
						"data": {
							"categoryId": category.get("id")
						},
						"reset": true
					});
					data.matches.fetch({
						"data": {
							"categoryId": category.get("id")
						},
						"reset": true
					});
				}
				else {
					var matchCollection = new models.MatchCollection();
					new views.TreeView({
						"el": $(this.el),
						"collection": matchCollection
					});
					matchCollection.fetch({
						"data": {
							"categoryId": category.get("id")
						},
						"reset": true
					});
				}
			}
			else if (category.get("type") == "DUO_2023") {
			    var data = {
			        "duoTable": new models.DuoTableModel(),
			        "matches": new models.MatchCollection()
			    };
                new views.DuoTablesView({
                    "el": $(this.el),
                    "model": data
                });
                data.duoTable.fetch({
                    "data": {
                        "categoryId": category.get("id")
                    },
                    "reset": true
                });
                data.matches.fetch({
                    "data": {
                        "categoryId": category.get("id")
                    },
                    "reset": true
                });
			}
			else { //CUSTOM
				$(this.el).text(category.get("type"));
			}

			return this;
		}
	});

})();