/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.usermodel;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.hwmf.draw.HwmfGraphics;
import org.apache.poi.hwmf.record.HwmfHeader;
import org.apache.poi.hwmf.record.HwmfPlaceableHeader;
import org.apache.poi.hwmf.record.HwmfRecord;
import org.apache.poi.hwmf.record.HwmfRecordType;
import org.apache.poi.hwmf.record.HwmfWindowing;
import org.apache.poi.util.LittleEndianInputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.Units;

public class HwmfPicture {
    private static final POILogger logger = POILogFactory.getLogger(HwmfPicture.class);
    final List<HwmfRecord> records = new ArrayList<HwmfRecord>();
    final HwmfPlaceableHeader placeableHeader;
    final HwmfHeader header;

    /*
     * Unable to fully structure code
     */
    public HwmfPicture(InputStream inputStream) throws IOException {
        super();
        bis = new BufferedInputStream(inputStream, 10000);
        leis = new LittleEndianInputStream((InputStream)bis);
        this.placeableHeader = HwmfPlaceableHeader.readHeader(leis);
        this.header = new HwmfHeader(leis);
        block2: while (true) {
            if (leis.available() < 6) {
                HwmfPicture.logger.log(7, new Object[]{"unexpected eof - wmf file was truncated"});
                break;
            }
            recordSize = leis.readUInt() * 2L;
            recordFunction = leis.readShort();
            consumedSize = 6;
            wrt = HwmfRecordType.getById(recordFunction);
            if (wrt == null) {
                throw new IOException("unexpected record type: " + recordFunction);
            }
            if (wrt == HwmfRecordType.eof) break;
            if (wrt.clazz == null) {
                throw new IOException("unsupported record type: " + recordFunction);
            }
            try {
                wr = wrt.clazz.newInstance();
                this.records.add(wr);
            }
            catch (Exception e) {
                throw (IOException)new IOException("can't create wmf record").initCause(e);
            }
            remainingSize = (int)(recordSize - (long)(consumedSize += wr.init(leis, recordSize, recordFunction)));
            if (!HwmfPicture.$assertionsDisabled && remainingSize < 0) {
                throw new AssertionError();
            }
            if (remainingSize <= 0) continue;
            i = remainingSize;
            while (true) {
                if (i > 0) ** break;
                continue block2;
                i = (int)((long)i - leis.skip((long)i));
            }
            break;
        }
    }

    public List<HwmfRecord> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    public void draw(Graphics2D ctx) {
        Dimension dim = this.getSize();
        int width = Units.pointsToPixel((double)dim.getWidth());
        int height = Units.pointsToPixel((double)dim.getHeight());
        Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, 0.0, width, height);
        this.draw(ctx, bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D ctx, Rectangle2D graphicsBounds) {
        AffineTransform at = ctx.getTransform();
        try {
            Rectangle2D wmfBounds = this.getBounds();
            ctx.translate(graphicsBounds.getX(), graphicsBounds.getY());
            ctx.scale(graphicsBounds.getWidth() / wmfBounds.getWidth(), graphicsBounds.getHeight() / wmfBounds.getHeight());
            HwmfGraphics g = new HwmfGraphics(ctx, wmfBounds);
            for (HwmfRecord r : this.records) {
                r.draw(g);
            }
        }
        finally {
            ctx.setTransform(at);
        }
    }

    public Rectangle2D getBounds() {
        if (this.placeableHeader != null) {
            return this.placeableHeader.getBounds();
        }
        HwmfWindowing.WmfSetWindowOrg wOrg = null;
        HwmfWindowing.WmfSetWindowExt wExt = null;
        for (HwmfRecord r : this.getRecords()) {
            if (wOrg != null && wExt != null) break;
            if (r instanceof HwmfWindowing.WmfSetWindowOrg) {
                wOrg = (HwmfWindowing.WmfSetWindowOrg)r;
                continue;
            }
            if (!(r instanceof HwmfWindowing.WmfSetWindowExt)) continue;
            wExt = (HwmfWindowing.WmfSetWindowExt)r;
        }
        if (wOrg == null || wExt == null) {
            throw new RuntimeException("invalid wmf file - window records are incomplete.");
        }
        return new Rectangle2D.Double(wOrg.getX(), wOrg.getY(), wExt.getWidth(), wExt.getHeight());
    }

    public HwmfPlaceableHeader getPlaceableHeader() {
        return this.placeableHeader;
    }

    public HwmfHeader getHeader() {
        return this.header;
    }

    public Dimension getSize() {
        double inch = this.placeableHeader == null ? 1440.0 : (double)this.placeableHeader.getUnitsPerInch();
        Rectangle2D bounds = this.getBounds();
        double coeff = 72.0 / inch;
        return new Dimension((int)Math.round(bounds.getWidth() * coeff), (int)Math.round(bounds.getHeight() * coeff));
    }
}

