/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.objects.ObjectCompare;
import si.nevensrok.common.utils.CollectionUtil;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryNameComparator;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.DuoTable;
import si.nevensrok.jtekma.server.web.common.search.CategoryData;
import si.nevensrok.jtekma.server.web.common.search.Duo2023Table;
import si.nevensrok.jtekma.server.web.common.search.DuoPresentation;
import si.nevensrok.jtekma.server.web.common.search.Match;
import si.nevensrok.jtekma.server.web.common.search.Placing;
import si.nevensrok.jtekma.server.web.common.search.SearchResponse;
import si.nevensrok.jtekma.server.web.common.search.Table;
import si.nevensrok.jtekma.server.web.controllers.CoreController;

@Controller
@RequestMapping(value={"/search"})
public class SearchController
extends CoreController {
    @RequestMapping
    public String base(Model model) {
        return "search/base";
    }

    /*
     * Could not resolve type clashes
     */
    @RequestMapping(value={"/search"})
    @ResponseBody
    public SearchResponse search(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="text", required=false, defaultValue="") String text) {
        SearchController.addNonCacheHeaders((HttpServletResponse)response);
        SearchResponse searchResponse = new SearchResponse();
        if (StringUtil.isEmpty((String)text)) {
            return searchResponse;
        }
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Competition competition = this.getUserData().getCompetition();
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        List<Category> categories = this.findCategories(text);
        if (CollectionUtil.isEmpty(categories)) {
            List<Competitor> competitors = this.findCompetitors(text);
            List<Competitor> couples = this.findCouples(text);
            HashMap<Long, Category> categoriesById = new HashMap<Long, Category>();
            for (Competitor competitor : competitors) {
                for (Category category : this.getManagersList().getCategoryManager().getCategoriesForCompetitor(competitor)) {
                    categoriesById.put(category.getCategoryId(), category);
                }
            }
            for (Competitor competitor : couples) {
                for (Category category : this.getManagersList().getCategoryManager().getCategoriesForCompetitor(competitor)) {
                    categoriesById.put(category.getCategoryId(), category);
                }
            }
            categories = new ArrayList(categoriesById.values());
            Collections.sort(categories, new CategoryNameComparator());
        }
        while (categories.size() > 50) {
            categories.remove(categories.size() - 1);
        }
        searchResponse.setCategoryData(new LinkedList<CategoryData>());
        for (Category category : categories) {
            TreeCategory treeCategory = null;
            if (category instanceof TreeCategory) {
                treeCategory = (TreeCategory)category;
            }
            Duo2023Category duo2023Category = null;
            if (category instanceof Duo2023Category) {
                duo2023Category = (Duo2023Category)category;
            }
            CategoryData categoryData = new CategoryData();
            categoryData.setCategoryName(category.getName());
            categoryData.setType(category.getType());
            if (treeCategory != null) {
                categoryData.setTreeType(treeCategory.getTreeType());
                categoryData.setDouble3rdPlace(treeCategory.getDouble3rdPlace());
            }
            if (duo2023Category != null) {
                categoryData.setDouble3rdPlace(duo2023Category.getDouble3rdPlace());
            }
            searchResponse.getCategoryData().add(categoryData);
            categoryData.setMatches(new LinkedList<Match>());
            List matchList = this.getManagersList().getMatchManager().getMatchesForCategory(category);
            HashMap matchPoints = new HashMap();
            for (Map.Entry entry : this.getManagersList().getMatchManager().getMatchPointsForMatches(new HashSet(matchList)).entrySet()) {
                matchPoints.put(((si.nevensrok.jtekma.common.matches.Match)entry.getKey()).getMatchId(), entry.getValue());
            }
            for (si.nevensrok.jtekma.common.matches.Match match : matchList) {
                Competitor winner;
                match.setCategory(category);
                Iterator m = new Match(match);
                if (treeCategory != null) {
                    ((Match)((Object)m)).setName(this.getTools().getMatchTool().getMatchName(locale, treeCategory, match));
                    ((Match)((Object)m)).setShortName(this.getTools().getMatchTool().getMatchShortName(treeCategory, match));
                } else if (duo2023Category != null) {
                    ((Match)((Object)m)).setName(this.getTools().getMatchTool().getMatchName(locale, duo2023Category, match));
                    ((Match)((Object)m)).setShortName(this.getTools().getMatchTool().getMatchShortName(duo2023Category, match));
                } else {
                    ((Match)((Object)m)).setName(this.getLanguageText(locale, "match.matchNum") + " " + String.valueOf(match.getFightNumber()));
                    ((Match)((Object)m)).setShortName(String.valueOf(match.getFightNumber()));
                }
                Set points = (Set)matchPoints.get(match.getMatchId());
                ((Match)((Object)m)).setPoints1(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points)));
                ((Match)((Object)m)).setPoints2(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points)));
                if (match.getStatus() == Match.Status.FINISHED && (winner = competitionRules.getMatchWinner(match, points)) != null) {
                    if (((Match)((Object)m)).getCompetitor1() != null) {
                        ((Match)((Object)m)).getCompetitor1().setWinner(winner.getCompetitorId().equals(((Match)((Object)m)).getCompetitor1().getId()));
                    }
                    if (((Match)((Object)m)).getCompetitor2() != null) {
                        ((Match)((Object)m)).getCompetitor2().setWinner(winner.getCompetitorId().equals(((Match)((Object)m)).getCompetitor2().getId()));
                    }
                }
                categoryData.getMatches().add((Match)((Object)m));
            }
            List duoPresentationList = this.getManagersList().getDuoPresentationManager().getDuoPresentationsForCategory(category);
            duoPresentationList.removeIf(dp -> dp.getGroupNumber() == null);
            HashMap duoPresentatioPoints = new HashMap();
            for (Map.Entry entry : this.getManagersList().getDuoPresentationManager().getDuoPresentationsForDuoPresentations(new HashSet(duoPresentationList)).entrySet()) {
                duoPresentatioPoints.put(((si.nevensrok.jtekma.common.matches.DuoPresentation)entry.getKey()).getDuoPresentationId(), entry.getValue());
            }
            Collections.sort(duoPresentationList, new Comparator<si.nevensrok.jtekma.common.matches.DuoPresentation>(){

                @Override
                public int compare(si.nevensrok.jtekma.common.matches.DuoPresentation o1, si.nevensrok.jtekma.common.matches.DuoPresentation o2) {
                    return new ObjectCompare().addValue(o1.getRound().ordinal(), o2.getRound().ordinal()).addValue((Comparable)o1.getGroupNumber(), (Object)o2.getGroupNumber()).addValue((Comparable)o1.getGroupPosition(), (Object)o2.getGroupPosition()).addValue((Comparable)o1.getDuoPresentationId(), (Object)o2.getDuoPresentationId()).calculateCompare();
                }
            });
            categoryData.setDuoPresentations(new LinkedList<DuoPresentation>());
            for (si.nevensrok.jtekma.common.matches.DuoPresentation duoPresentation : duoPresentationList) {
                duoPresentation.setCategory(category);
                DuoPresentation dp2 = new DuoPresentation(duoPresentation);
                dp2.setName(this.getTools().getMatchTool().generateDuoPresentationName(locale, duoPresentation));
                dp2.setShortName(this.getTools().getMatchTool().generateDuoPresentationShortName(locale, duoPresentation));
                Set points = (Set)duoPresentatioPoints.get(duoPresentation.getDuoPresentationId());
                dp2.setPoints(Float.valueOf(competitionRules.sumDuoPresentationPoints(points)));
                categoryData.getDuoPresentations().add(dp2);
            }
            categoryData.setPlacings(new LinkedList<Placing>());
            if (treeCategory != null) {
                if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE5) {
                    si.nevensrok.jtekma.common.rules.Table table = this.getManagersList().getCategoryTreeUpdateManager().getTable(category);
                    competitionRules.setPlacingsInTable(table);
                    categoryData.setTable1(new Table(table));
                } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE6) {
                    si.nevensrok.jtekma.common.rules.Table table1 = this.getManagersList().getCategoryTreeUpdateManager().getTree6Table(category, 1);
                    si.nevensrok.jtekma.common.rules.Table table2 = this.getManagersList().getCategoryTreeUpdateManager().getTree6Table(category, 2);
                    competitionRules.setPlacingsInTable(table1);
                    competitionRules.setPlacingsInTable(table2);
                    categoryData.setTable1(new Table(table1));
                    categoryData.setTable2(new Table(table2));
                }
                Map placingMap = this.getManagersList().getCategoryTreeUpdateManager().getPlacings(category);
                if (placingMap != null) {
                    for (Map.Entry entry : placingMap.entrySet()) {
                        categoryData.getPlacings().add(new Placing((Integer)entry.getValue(), new si.nevensrok.jtekma.server.web.common.search.Competitor((Competitor)entry.getKey())));
                    }
                }
            }
            if (duo2023Category != null) {
                DuoTable duoTable = this.getManagersList().getCategoryTreeUpdateManager().getDuoTable(category);
                categoryData.setDuoTable(new Duo2023Table(duoTable));
                for (Rank rank : Rank.values()) {
                    Map placingMap = this.getManagersList().getCategoryTreeUpdateManager().getPlacings(category, rank);
                    if (placingMap == null) continue;
                    for (Map.Entry entry : placingMap.entrySet()) {
                        categoryData.getPlacings().add(new Placing(rank, (Integer)entry.getValue(), new si.nevensrok.jtekma.server.web.common.search.Competitor((Competitor)entry.getKey())));
                    }
                }
            }
            Collections.sort(categoryData.getPlacings(), new Comparator<Placing>(){

                @Override
                public int compare(Placing o1, Placing o2) {
                    return new ObjectCompare().addValue((Comparable)o1.getRank(), (Object)o2.getRank()).addValue((Comparable)o1.getPlace(), (Object)o2.getPlace()).addValue((Comparable)((Object)o1.getCompetitor().getName()), (Object)o2.getCompetitor().getName()).calculateCompare();
                }
            });
        }
        return searchResponse;
    }

    private List<Competitor> findCompetitors(String text) {
        PersonCompetitor example = new PersonCompetitor();
        example.setType(Competitor.Type.COMPETITOR);
        example.setStatus(Competitor.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        dataFilter.setFilter((Filter)rootFilter);
        rootFilter.addFilter((Filter)new ExampleFilter((Object)example));
        GroupFilter nameFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)nameFilter);
        nameFilter.addFilter((Filter)new FieldFilter("name", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + text.trim() + "%")));
        nameFilter.addFilter((Filter)new FieldFilter("surname", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + text.trim() + "%")));
        nameFilter.addFilter((Filter)new FieldFilter("club.name", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + text.trim() + "%")));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        dataFilter.getSort().addField(new Sort.Field("surname", Sort.Field.Direction.ASC, false));
        dataFilter.setFetchCount(false);
        dataFilter.setItemLimit(Integer.valueOf(100));
        PageDataResult resultPage = this.getManagersList().getCompetitorManager().findForCompetition(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        return resultPage.getData();
    }

    private List<Competitor> findCouples(String text) {
        CoupleCompetitor example = new CoupleCompetitor();
        example.setType(Competitor.Type.COUPLE);
        example.setStatus(Competitor.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        dataFilter.setFilter((Filter)rootFilter);
        rootFilter.addFilter((Filter)new ExampleFilter((Object)example));
        GroupFilter nameFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)nameFilter);
        nameFilter.addFilter((Filter)new FieldFilter("name1", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + text.trim() + "%")));
        nameFilter.addFilter((Filter)new FieldFilter("surname1", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + text.trim() + "%")));
        nameFilter.addFilter((Filter)new FieldFilter("name2", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + text.trim() + "%")));
        nameFilter.addFilter((Filter)new FieldFilter("surname2", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + text.trim() + "%")));
        nameFilter.addFilter((Filter)new FieldFilter("club.name", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + text.trim() + "%")));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name1", Sort.Field.Direction.ASC, false));
        dataFilter.getSort().addField(new Sort.Field("surname1", Sort.Field.Direction.ASC, false));
        dataFilter.getSort().addField(new Sort.Field("name2", Sort.Field.Direction.ASC, false));
        dataFilter.getSort().addField(new Sort.Field("surname2", Sort.Field.Direction.ASC, false));
        dataFilter.setFetchCount(false);
        dataFilter.setItemLimit(Integer.valueOf(100));
        PageDataResult dataResult = this.getManagersList().getCompetitorManager().findForCompetition(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        return dataResult.getData();
    }

    private List<Category> findCategories(String text) {
        Category example = new Category();
        example.setName("%" + text.trim() + "%");
        example.setStatus(Category.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        dataFilter.setFetchCount(false);
        dataFilter.setItemLimit(Integer.valueOf(50));
        PageDataResult dataResult = this.getManagersList().getCategoryManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        return dataResult.getData();
    }
}

