/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.data;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.common.web.util.ControllerUtil;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryNameComparator;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.web.common.ImportDataModel;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.data.PersonCompetitorModel;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/data/person-competitors"})
@SessionAttributes(value={"personCompetitorListFilter"})
public class PersonCompetitorsController
extends CoreController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonCompetitorsController.class);

    private List<Club> getClubs() {
        Club example = new Club();
        example.setStatus(Club.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        dataFilter.setItemLimit(Integer.valueOf(1000));
        return this.getManagersList().getClubManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter).getData();
    }

    public Map<Long, String> getClubsMap() {
        LinkedHashMap<Long, String> clubsMap = new LinkedHashMap<Long, String>();
        clubsMap.put(0L, "");
        for (Club club : this.getClubs()) {
            clubsMap.put(club.getClubId(), club.getName());
        }
        return clubsMap;
    }

    @ModelAttribute(value="personCompetitorsActive")
    public Boolean getPersonCompetitorsActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="personCompetitorListFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @ModelAttribute(value="editRights")
    public Boolean getEditRights() {
        return this.hasRights(Right.COMPETITOREDIT);
    }

    @ModelAttribute(value="fileTypes")
    public Map<FileType, String> getFileTypes(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<FileType, String> importType = new LinkedHashMap<FileType, String>();
        importType.put(FileType.CSV, this.getLanguageText(locale, "filetypes.csv"));
        importType.put(FileType.ODS, this.getLanguageText(locale, "filetypes.ods"));
        importType.put(FileType.XLS, this.getLanguageText(locale, "filetypes.xls"));
        importType.put(FileType.XLSX, this.getLanguageText(locale, "filetypes.xlsx"));
        return importType;
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="personCompetitorListFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        PersonCompetitor example = new PersonCompetitor();
        example.setType(Competitor.Type.COMPETITOR);
        example.setStatus(Competitor.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        dataFilter.setFilter((Filter)rootFilter);
        rootFilter.addFilter((Filter)new ExampleFilter((Object)example));
        GroupFilter nameFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)nameFilter);
        nameFilter.addFilter((Filter)new FieldFilter("name", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + searchFilter.getSearch().trim() + "%")));
        nameFilter.addFilter((Filter)new FieldFilter("surname", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + searchFilter.getSearch().trim() + "%")));
        nameFilter.addFilter((Filter)new FieldFilter("club.name", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + searchFilter.getSearch().trim() + "%")));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        dataFilter.getSort().addField(new Sort.Field("surname", Sort.Field.Direction.ASC, false));
        dataFilter.setItemCountPerPage(searchFilter.getShowPerPage().intValue());
        dataFilter.setPage(searchFilter.getPage().intValue());
        PageDataResult resultPage = this.getManagersList().getCompetitorManager().findForCompetition(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        model.addAttribute("competitors", (Object)resultPage.getData());
        model.addAttribute("totalPages", (Object)resultPage.getPageCount(true));
        if (messageCode.equals(1)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "personCompetitors.text.added"));
        } else if (messageCode.equals(2)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "personCompetitors.text.updated"));
        } else if (messageCode.equals(3)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "personCompetitors.text.deleted"));
        } else if (messageCode.equals(4)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "personCompetitors.text.categoriesSet"));
        } else if (messageCode.equals(5)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "personCompetitors.text.imported"));
        } else if (messageCode.equals(6)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "personCompetitors.text.shortNamesReset"));
        } else if (messageCode.equals(7)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "personCompetitors.text.namesSwitched"));
        } else if (messageCode.equals(8)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "personCompetitors.text.allRemoved"));
        }
        return "data/person-competitors-list";
    }

    @MethodRight(value={Right.COMPETITOREDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="competitor") PersonCompetitorModel personCompetitorModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        personCompetitorModel.setYearOfBirth(1980);
        personCompetitorModel.setWeight(80);
        model.addAttribute("clubs", this.getClubsMap());
        return "data/person-competitors-edit";
    }

    @MethodRight(value={Right.COMPETITOREDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="competitor") @Valid PersonCompetitorModel personCompetitorModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.add(request, model, personCompetitorModel, bindingResult);
        }
        PersonCompetitor personCompetitor = new PersonCompetitor();
        ObjectUtil.copyNotNullProperties((Object)personCompetitorModel, (Object)personCompetitor);
        Club club = this.getManagersList().getClubManager().getByIdForCompetition(this.getUserData().getCompetition(), personCompetitorModel.getClubId());
        personCompetitor.setClub(club);
        if (StringUtil.isEmpty((String)personCompetitor.getShortName())) {
            personCompetitor.setShortName((!personCompetitor.getName().isEmpty() ? personCompetitor.getName().substring(0, 1) + ". " : "") + personCompetitor.getSurname());
        }
        personCompetitor.setCompetition(this.getUserData().getCompetition());
        personCompetitor.setStatus(Competitor.Status.ACTIVE);
        personCompetitor.setType(Competitor.Type.COMPETITOR);
        this.getManagersList().getCompetitorManager().createCompetitor((Competitor)personCompetitor);
        return "redirect:/data/person-competitors?messageCode=1";
    }

    @MethodRight(value={Right.COMPETITOREDIT})
    @RequestMapping(value={"/edit/{competitorId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="competitorId") Long competitorId, @ModelAttribute(value="competitor") PersonCompetitorModel personCompetitorModel, BindingResult bindingResult) {
        PersonCompetitor personCompetitor = (PersonCompetitor)this.getManagersList().getCompetitorManager().getById(competitorId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCompetitor((Competitor)personCompetitor).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)personCompetitor, (Object)personCompetitorModel);
        personCompetitorModel.setClubId(this.getManagersList().getClubManager().getClubForCompetitor((Competitor)personCompetitor).getClubId());
        model.addAttribute("clubs", this.getClubsMap());
        return "data/person-competitors-edit";
    }

    @MethodRight(value={Right.COMPETITOREDIT})
    @RequestMapping(value={"/edit/{competitorId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="competitorId") Long competitorId, @ModelAttribute(value="competitor") @Valid PersonCompetitorModel personCompetitorModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, competitorId, personCompetitorModel, bindingResult);
        }
        PersonCompetitor personCompetitor = (PersonCompetitor)this.getManagersList().getCompetitorManager().getById(competitorId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCompetitor((Competitor)personCompetitor).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)personCompetitorModel, (Object)personCompetitor);
        Club club = this.getManagersList().getClubManager().getByIdForCompetition(this.getUserData().getCompetition(), personCompetitorModel.getClubId());
        personCompetitor.setClub(club);
        if (StringUtil.isEmpty((String)personCompetitor.getShortName())) {
            personCompetitor.setShortName((!personCompetitor.getName().isEmpty() ? personCompetitor.getName().substring(0, 1) + ". " : "") + personCompetitor.getSurname());
        }
        this.getManagersList().getCompetitorManager().updateCompetitor((Competitor)personCompetitor);
        return "redirect:/data/person-competitors?messageCode=2";
    }

    @MethodRight(value={Right.COMPETITOREDIT})
    @RequestMapping(value={"/delete/{competitorId}"})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="competitorId") Long competitorId) {
        PersonCompetitor personCompetitor = (PersonCompetitor)this.getManagersList().getCompetitorManager().getById(competitorId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCompetitor((Competitor)personCompetitor).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        this.getManagersList().getCompetitorManager().deleteCompetitor((Competitor)personCompetitor);
        return "redirect:/data/person-competitors?messageCode=3";
    }

    @MethodRight(value={Right.COMPETITOREDIT})
    @RequestMapping(value={"/remove-all"})
    public String removeAll(HttpServletRequest request, Model model) {
        List competitors = this.getManagersList().getCompetitorManager().getActiveCompetitorsForCompetition(this.getUserData().getCompetition(), Competitor.Type.COMPETITOR);
        for (Competitor competitor : competitors) {
            this.getManagersList().getCompetitorManager().deleteCompetitor(competitor);
        }
        return "redirect:/data/person-competitors?messageCode=8";
    }

    @MethodRight(value={Right.COMPETITOREDIT})
    @RequestMapping(value={"/categories/{competitorId}"}, method={RequestMethod.GET})
    public String categories(HttpServletRequest request, Model model, @PathVariable(value="competitorId") Long competitorId) {
        PersonCompetitor personCompetitor = (PersonCompetitor)this.getManagersList().getCompetitorManager().getById(competitorId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCompetitor((Competitor)personCompetitor).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        model.addAttribute("competitor", (Object)personCompetitor);
        HashSet<Long> currentCategories = new HashSet<Long>();
        for (Category category : this.getManagersList().getCategoryManager().getCategoriesForCompetitor((Competitor)personCompetitor)) {
            currentCategories.add(category.getCategoryId());
        }
        model.addAttribute("currentCategories", currentCategories);
        Category example = new Category();
        example.setStatus(Category.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        PageDataResult dataResult = this.getManagersList().getCategoryManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        Collections.sort(dataResult.getData(), new CategoryNameComparator());
        model.addAttribute("categories", (Object)dataResult.getData());
        return "data/person-categories";
    }

    @MethodRight(value={Right.COMPETITOREDIT})
    @RequestMapping(value={"/categories/{competitorId}"}, method={RequestMethod.POST})
    public String categoriesPost(HttpServletRequest request, Model model, @PathVariable(value="competitorId") Long competitorId) {
        PersonCompetitor personCompetitor = (PersonCompetitor)this.getManagersList().getCompetitorManager().getById(competitorId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCompetitor((Competitor)personCompetitor).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        HashSet<Category> categories = new HashSet<Category>();
        Map parameters = request.getParameterMap();
        for (String key : parameters.keySet()) {
            if (!key.startsWith("category_")) continue;
            Long categoryId = Long.parseLong(key.split("_")[1]);
            Category category = new Category();
            category.setCategoryId(categoryId);
            categories.add(category);
        }
        this.getManagersList().getCompetitorManager().setCompetitorCategories((Competitor)personCompetitor, categories);
        return "redirect:/data/person-competitors?messageCode=4";
    }

    @MethodRight(value={Right.COMPETITOREDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.GET})
    public String importData(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel) {
        return "data/person-competitors-import";
    }

    @MethodRight(value={Right.COMPETITOREDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public String importDataPost(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        try {
            LinkedHashMap errors = new LinkedHashMap();
            List competitors = this.getManagersList().getPersonCompetitorImporter().parseCompetitors(importDataModel.getFileType(), importDataModel.getFile().getBytes(), this.getUserData().getCompetition(), errors);
            if (!errors.isEmpty()) {
                LinkedList<String> errorMessages = new LinkedList<String>();
                for (Map.Entry entry : errors.entrySet()) {
                    if (entry.getValue() == DataImportException.ErrorType.ClubNotFound) {
                        errorMessages.add(this.getLanguageText(locale, "personCompetitors.error.clubNotFound", new String[]{(String)entry.getKey()}));
                        continue;
                    }
                    if (entry.getValue() != DataImportException.ErrorType.CategoryNotFound) continue;
                    errorMessages.add(this.getLanguageText(locale, "personCompetitors.error.categoryNotFound", new String[]{(String)entry.getKey()}));
                }
                model.addAttribute("errorMessages", errorMessages);
                return this.importData(request, model, importDataModel);
            }
            this.getManagersList().getPersonCompetitorImporter().importCompetitors(this.getUserData().getCompetition(), competitors);
            return "redirect:/data/person-competitors?messageCode=5";
        }
        catch (DataImportException e) {
            if (e.getErrorType() == DataImportException.ErrorType.NoCompetitorName) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "personCompetitors.error.noCompetitorName"));
                return this.importData(request, model, importDataModel);
            }
            if (e.getErrorType() == DataImportException.ErrorType.NoCompetitorSurname) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "personCompetitors.error.noCompetitorSurname"));
                return this.importData(request, model, importDataModel);
            }
            if (e.getErrorType() == DataImportException.ErrorType.NoCompetitorClub) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "personCompetitors.error.noCompetitorClub"));
                return this.importData(request, model, importDataModel);
            }
            LOGGER.error("Error while reading person competitors data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "personCompetitors.error.importError"));
            return this.importData(request, model, importDataModel);
        }
        catch (Exception e) {
            LOGGER.error("Error while reading person competitors data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "personCompetitors.error.importError"));
            return this.importData(request, model, importDataModel);
        }
    }

    @RequestMapping(value={"/export/{fileType}"})
    public void exportData(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable(value="fileType") FileType fileType) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Competition competition = this.getUserData().getCompetition();
        String fileName = competition.getName() + "-" + this.getLanguageText(locale, "personCompetitors.export.fileName");
        if (fileType == FileType.CSV) {
            fileName = fileName + ".csv";
            response.setContentType("text/csv");
        } else if (fileType == FileType.ODS) {
            fileName = fileName + ".ods";
            response.setContentType("application/vnd.oasis.opendocument.spreadsheet");
        } else if (fileType == FileType.XLS) {
            fileName = fileName + ".xls";
            response.setContentType("application/vnd.ms-excel");
        } else if (fileType == FileType.XLSX) {
            fileName = fileName + ".xlsx";
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }
        ControllerUtil.addContentDispositionHeader((HttpServletResponse)response, (String)fileName);
        String[] header = new String[]{this.getLanguageText(locale, "personCompetitors.export.competitorName"), this.getLanguageText(locale, "personCompetitors.export.competitorSurname"), this.getLanguageText(locale, "personCompetitors.export.competitorClub"), this.getLanguageText(locale, "personCompetitors.export.competitorCategory"), this.getLanguageText(locale, "personCompetitors.export.competitorShortName"), this.getLanguageText(locale, "personCompetitors.export.competitorYearOfBirth"), this.getLanguageText(locale, "personCompetitors.export.competitorWeight")};
        List competitors = this.getManagersList().getCompetitorManager().getActiveCompetitorsForCompetition(competition, Competitor.Type.COMPETITOR);
        try {
            byte[] data = this.getManagersList().getPersonCompetitorImporter().exportCompetitors(fileType, competitors, header);
            response.getOutputStream().write(data);
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("Error writing to output stream", (Throwable)e);
        }
    }

    @MethodRight(value={Right.COMPETITOREDIT})
    @RequestMapping(value={"/reset-short-names"}, method={RequestMethod.GET})
    public String resetShortNames(HttpServletRequest request, Model model) {
        Competition competition = this.getUserData().getCompetition();
        this.getManagersList().getCompetitorManager().resetShortNames(competition, Competitor.Type.COMPETITOR);
        return "redirect:/data/person-competitors?messageCode=6";
    }

    @MethodRight(value={Right.COMPETITOREDIT})
    @RequestMapping(value={"/switch-names"}, method={RequestMethod.GET})
    public String switchNames(HttpServletRequest request, Model model) {
        Competition competition = this.getUserData().getCompetition();
        this.getManagersList().getCompetitorManager().switchNameAndSurname(competition, Competitor.Type.COMPETITOR);
        return "redirect:/data/person-competitors?messageCode=7";
    }
}

