/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryNameComparator;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.GroupDraw;
import si.nevensrok.jtekma.server.web.common.DrawRules;
import si.nevensrok.jtekma.server.web.controllers.CoreController;

@Controller
@RequestMapping(value={"/data/draw"})
public class DrawController
extends CoreController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DrawController.class);

    public List<Category> getCategoryList() {
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        rootFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)Category.Status.ACTIVE));
        HashSet<Category.Type> categoryTypes = new HashSet<Category.Type>();
        categoryTypes.add(Category.Type.FIGHTING);
        categoryTypes.add(Category.Type.DUO);
        categoryTypes.add(Category.Type.NEWAZA);
        categoryTypes.add(Category.Type.DUO_2023);
        rootFilter.addFilter((Filter)new FieldFilter("type", FieldFilter.Comparator.IN, categoryTypes));
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)rootFilter);
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        PageDataResult dataResult = this.getManagersList().getCategoryManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        Collections.sort(dataResult.getData(), new CategoryNameComparator());
        return dataResult.getData();
    }

    @ModelAttribute(value="drawActive")
    public Boolean getDrawActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="repassageTypes")
    public Map<TreeCategory.RepassageType, String> getRepassageTypes(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<TreeCategory.RepassageType, String> repassageTypes = new LinkedHashMap<TreeCategory.RepassageType, String>();
        repassageTypes.put(TreeCategory.RepassageType.NONE, this.getLanguageText(locale, "categories.repassageType.NONE"));
        repassageTypes.put(TreeCategory.RepassageType.SINGLE, this.getLanguageText(locale, "categories.repassageType.SINGLE"));
        repassageTypes.put(TreeCategory.RepassageType.DOUBLE, this.getLanguageText(locale, "categories.repassageType.DOUBLE"));
        return repassageTypes;
    }

    @ModelAttribute(value="repassageFromRoundOptions")
    public Map<Integer, String> getRepassageFromRoundOptions(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<Integer, String> repassageFromRoundOptions = new LinkedHashMap<Integer, String>();
        for (int i = 1; i <= 5; ++i) {
            repassageFromRoundOptions.put(i, this.getLanguageText(locale, "categories.repassageFromRound." + String.valueOf(i)));
        }
        return repassageFromRoundOptions;
    }

    @ModelAttribute(value="treeTypesFor2")
    public Map<TreeCategory.TreeType, String> getTreeTypesFor2(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<TreeCategory.TreeType, String> treeTypes = new LinkedHashMap<TreeCategory.TreeType, String>();
        treeTypes.put(TreeCategory.TreeType.TABLE2, this.getLanguageText(locale, "categories.treetype.TABLE2"));
        treeTypes.put(TreeCategory.TreeType.BEST_OF_3, this.getLanguageText(locale, "categories.treetype.BEST_OF_3"));
        return treeTypes;
    }

    @ModelAttribute(value="treeTypesFor4")
    public Map<TreeCategory.TreeType, String> getTreeTypesFor4(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<TreeCategory.TreeType, String> treeTypes = new LinkedHashMap<TreeCategory.TreeType, String>();
        treeTypes.put(TreeCategory.TreeType.TABLE4, this.getLanguageText(locale, "categories.treetype.TABLE4"));
        treeTypes.put(TreeCategory.TreeType.TREE4, this.getLanguageText(locale, "categories.treetype.TREE4"));
        return treeTypes;
    }

    @ModelAttribute(value="treeTypesFor5")
    public Map<TreeCategory.TreeType, String> getTreeTypesFor5(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<TreeCategory.TreeType, String> treeTypes = new LinkedHashMap<TreeCategory.TreeType, String>();
        treeTypes.put(TreeCategory.TreeType.TABLE5, this.getLanguageText(locale, "categories.treetype.TABLE5"));
        treeTypes.put(TreeCategory.TreeType.TREE8, this.getLanguageText(locale, "categories.treetype.TREE8"));
        return treeTypes;
    }

    @ModelAttribute(value="treeTypesFor6")
    public Map<TreeCategory.TreeType, String> getTreeTypesFor6(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<TreeCategory.TreeType, String> treeTypes = new LinkedHashMap<TreeCategory.TreeType, String>();
        treeTypes.put(TreeCategory.TreeType.TREE6, this.getLanguageText(locale, "categories.treetype.TREE6"));
        treeTypes.put(TreeCategory.TreeType.TREE8, this.getLanguageText(locale, "categories.treetype.TREE8"));
        return treeTypes;
    }

    @RequestMapping(method={RequestMethod.GET})
    public String list(Model model, @ModelAttribute(value="drawRules") DrawRules drawRules) {
        List<Category> categoryList = this.getCategoryList();
        model.addAttribute("categories", categoryList);
        Map competitorCount = this.getManagersList().getCategoryManager().getCategoryCompetitorCount(new HashSet<Category>(categoryList));
        model.addAttribute("competitorCount", (Object)competitorCount);
        return "data/draw";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String executeDraw(HttpServletRequest request, Model model, @ModelAttribute(value="drawRules") DrawRules drawRules) {
        LOGGER.debug("Draw rules: {}", (Object)drawRules);
        List<Category> categoryList = this.getCategoryList();
        Random random = new Random();
        for (Category category : categoryList) {
            int i;
            if (request.getParameter("category_" + category.getId().toString()) == null) continue;
            LOGGER.debug("Executing draw for category: {}", (Object)category);
            if (category instanceof TreeCategory) {
                TreeCategory treeCategory = (TreeCategory)category;
                treeCategory.setRepassageType(drawRules.getRepassageType());
                treeCategory.setDouble3rdPlace(drawRules.getDouble3rdplace());
                treeCategory.setRepassageFromRound(drawRules.getRepassageFromRound());
                HashMap<Object, Integer> draw = new HashMap<Object, Integer>();
                ArrayList competitors = new ArrayList(this.getManagersList().getCompetitorManager().getCompetitorsForCategory(category));
                int competitorCount = competitors.size();
                if (drawRules.getSameClubMeetAtLateAsPossible().booleanValue()) {
                    ArrayList<Competitor> competitorsFromClub = new ArrayList<Competitor>();
                    for (i = 1; !(i > 64 || competitors.isEmpty() && competitorsFromClub.isEmpty()); ++i) {
                        if (competitorsFromClub.isEmpty()) {
                            Competitor competitor = (Competitor)competitors.remove(random.nextInt(competitors.size()));
                            competitorsFromClub.add(competitor);
                            for (Competitor c : new LinkedList(competitors)) {
                                if (!c.getClub().equals((Object)competitor.getClub())) continue;
                                competitorsFromClub.add(c);
                                competitors.remove(c);
                            }
                        }
                        draw.put(competitorsFromClub.remove(random.nextInt(competitorsFromClub.size())), i);
                    }
                } else {
                    for (int i2 = 1; i2 <= 64 && !competitors.isEmpty(); ++i2) {
                        Competitor competitor = (Competitor)competitors.remove(random.nextInt(competitors.size()));
                        draw.put(competitor, i2);
                    }
                }
                if (competitorCount <= 1) {
                    treeCategory.setTreeType(TreeCategory.TreeType.TABLE2);
                } else if (competitorCount <= 2) {
                    treeCategory.setTreeType(drawRules.getTreeTypeFor2Competitors());
                } else if (competitorCount <= 3) {
                    treeCategory.setTreeType(TreeCategory.TreeType.TABLE3);
                } else if (competitorCount <= 4) {
                    treeCategory.setTreeType(drawRules.getTreeTypeFor4Competitors());
                    if (drawRules.getTreeTypeFor4Competitors() == TreeCategory.TreeType.TREE4) {
                        treeCategory.setDouble3rdPlace(drawRules.getDouble3rdplaceForTree4());
                    }
                } else if (competitorCount <= 5) {
                    treeCategory.setTreeType(drawRules.getTreeTypeFor5Competitors());
                    if (drawRules.getTreeTypeFor4Competitors() == TreeCategory.TreeType.TREE8) {
                        treeCategory.setDouble3rdPlace(drawRules.getDouble3rdplaceForTree5());
                    }
                } else if (competitorCount == 6) {
                    treeCategory.setTreeType(drawRules.getTreeTypeFor6Competitors());
                } else if (competitorCount <= 8) {
                    treeCategory.setTreeType(TreeCategory.TreeType.TREE8);
                } else if (competitorCount <= 16) {
                    treeCategory.setTreeType(TreeCategory.TreeType.TREE16);
                } else if (competitorCount <= 32) {
                    treeCategory.setTreeType(TreeCategory.TreeType.TREE32);
                } else if (competitorCount <= 64) {
                    treeCategory.setTreeType(TreeCategory.TreeType.TREE64);
                }
                this.getManagersList().getCategoryManager().setCategoryTreeType(treeCategory, treeCategory.getTreeType());
                this.getManagersList().getCategoryManager().setRepassageType(treeCategory, treeCategory.getRepassageType());
                this.getManagersList().getCategoryManager().setDouble3rdPlace(treeCategory, treeCategory.getDouble3rdPlace());
                this.getManagersList().getCategoryManager().setRepassageFromRound(treeCategory, treeCategory.getRepassageFromRound());
                this.getManagersList().getCategoryManager().setDraw(category, draw);
                continue;
            }
            if (!(category instanceof Duo2023Category)) continue;
            Duo2023Category duo2023Category = (Duo2023Category)category;
            duo2023Category.setDouble3rdPlace(drawRules.getDouble3rdplace());
            ArrayList competitors = new ArrayList(this.getManagersList().getCompetitorManager().getCompetitorsForCategory(category));
            int groupToAddTo = 0;
            int groupCount = 1;
            if (competitors.size() >= 19) {
                groupCount = 4;
            } else if (competitors.size() >= 13) {
                groupCount = 3;
            } else if (competitors.size() >= 7) {
                groupCount = 2;
            }
            ArrayList groups = new ArrayList(groupCount);
            for (i = 0; i < groupCount; ++i) {
                groups.add(new LinkedList());
            }
            if (drawRules.getSameClubMeetAtLateAsPossible().booleanValue()) {
                while (!competitors.isEmpty()) {
                    ArrayList<Competitor> competitorsFromClub = new ArrayList<Competitor>();
                    Competitor competitor = (Competitor)competitors.remove(random.nextInt(competitors.size()));
                    competitorsFromClub.add(competitor);
                    for (Competitor c : new LinkedList(competitors)) {
                        if (!c.getClub().equals((Object)competitor.getClub())) continue;
                        competitorsFromClub.add(c);
                        competitors.remove(c);
                    }
                    while (!competitorsFromClub.isEmpty()) {
                        Competitor c = (Competitor)competitorsFromClub.remove(random.nextInt(competitorsFromClub.size()));
                        ((List)groups.get(groupToAddTo++ % groupCount)).add(c);
                    }
                }
            } else {
                while (!competitors.isEmpty()) {
                    Competitor competitor = (Competitor)competitors.remove(random.nextInt(competitors.size()));
                    ((List)groups.get(groupToAddTo++ % groupCount)).add(competitor);
                }
            }
            HashMap<Competitor, GroupDraw> draw = new HashMap<Competitor, GroupDraw>();
            for (int i3 = 0; i3 < groupCount; ++i3) {
                int n = 1;
                for (Competitor competitor : (List)groups.get(i3)) {
                    draw.put(competitor, new GroupDraw(Integer.valueOf(n++), Integer.valueOf(i3 + 1)));
                }
            }
            this.getManagersList().getCategoryManager().setDouble3rdPlace(duo2023Category, duo2023Category.getDouble3rdPlace());
            this.getManagersList().getCategoryManager().setGroupDraw(category, draw);
        }
        model.addAttribute("drawExecuted", (Object)Boolean.TRUE);
        return this.list(model, drawRules);
    }
}

