/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.data;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.tools.SimilarDataChecker;
import si.nevensrok.jtekma.server.web.common.ImportDataModel;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.data.ClubModel;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/data/clubs"})
@SessionAttributes(value={"clubListFilter", "importClubList"})
public class ClubsController
extends CoreController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClubsController.class);

    @ModelAttribute(value="clubsActive")
    public Boolean getClubsActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="clubListFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @ModelAttribute(value="importClubList")
    public List<Club> getImportClubList() {
        return new LinkedList<Club>();
    }

    @ModelAttribute(value="editRights")
    public Boolean getEditRights() {
        return this.hasRights(Right.CLUBEDIT);
    }

    @ModelAttribute(value="fileTypes")
    public Map<FileType, String> getFileTypes(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<FileType, String> importType = new LinkedHashMap<FileType, String>();
        importType.put(FileType.CSV, this.getLanguageText(locale, "filetypes.csv"));
        importType.put(FileType.ODS, this.getLanguageText(locale, "filetypes.ods"));
        importType.put(FileType.XLS, this.getLanguageText(locale, "filetypes.xls"));
        importType.put(FileType.XLSX, this.getLanguageText(locale, "filetypes.xlsx"));
        return importType;
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="clubListFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Club example = new Club();
        example.setName("%" + searchFilter.getSearch().trim() + "%");
        example.setStatus(Club.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        dataFilter.setItemCountPerPage(searchFilter.getShowPerPage().intValue());
        dataFilter.setPage(searchFilter.getPage().intValue());
        PageDataResult dataResult = this.getManagersList().getClubManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        model.addAttribute("clubs", (Object)dataResult.getData());
        model.addAttribute("totalPages", (Object)dataResult.getPageCount(true));
        Map competitorCount = this.getManagersList().getClubManager().getClubCompetitorCount(new HashSet(dataResult.getData()));
        model.addAttribute("competitorCount", (Object)competitorCount);
        if (messageCode.equals(1)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "clubs.text.added"));
        } else if (messageCode.equals(2)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "clubs.text.updated"));
        } else if (messageCode.equals(3)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "clubs.text.deleted"));
        } else if (messageCode.equals(4)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "clubs.text.imported"));
        } else if (messageCode.equals(5)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "clubs.text.emptyRemoved"));
        } else if (messageCode.equals(6)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "clubs.text.allRemoved"));
        }
        return "data/club-list";
    }

    @MethodRight(value={Right.CLUBEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="club") ClubModel clubModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        return "data/club-edit";
    }

    @MethodRight(value={Right.CLUBEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="club") @Valid ClubModel clubModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.add(request, model, clubModel, bindingResult);
        }
        Club club = new Club();
        ObjectUtil.copyNotNullProperties((Object)clubModel, (Object)club);
        if (club.getShortName() == null || club.getShortName().isEmpty()) {
            club.setShortName(club.getName());
        }
        club.setCompetition(this.getUserData().getCompetition());
        club.setStatus(Club.Status.ACTIVE);
        club = this.getManagersList().getClubManager().createClub(club);
        return "redirect:/data/clubs?messageCode=1";
    }

    @MethodRight(value={Right.CLUBEDIT})
    @RequestMapping(value={"/edit/{clubId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="clubId") Long clubId, @ModelAttribute(value="club") ClubModel clubModel, BindingResult bindingResult) {
        Club club = this.getManagersList().getClubManager().getById(clubId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForClub(club).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)club, (Object)clubModel);
        return "data/club-edit";
    }

    @MethodRight(value={Right.CLUBEDIT})
    @RequestMapping(value={"/edit/{clubId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="clubId") Long clubId, @ModelAttribute(value="club") @Valid ClubModel clubModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, clubId, clubModel, bindingResult);
        }
        Club club = this.getManagersList().getClubManager().getById(clubId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForClub(club).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)clubModel, (Object)club);
        if (club.getShortName() == null || club.getShortName().isEmpty()) {
            club.setShortName(club.getName());
        }
        club = this.getManagersList().getClubManager().updateClub(club);
        return "redirect:/data/clubs?messageCode=2";
    }

    @MethodRight(value={Right.CLUBEDIT})
    @RequestMapping(value={"/delete/{clubId}"})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="clubId") Long clubId) {
        Club club = this.getManagersList().getClubManager().getById(clubId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForClub(club).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        this.getManagersList().getClubManager().deleteClub(club);
        return "redirect:/data/clubs?messageCode=3";
    }

    @MethodRight(value={Right.CLUBEDIT})
    @RequestMapping(value={"/remove-empty"})
    public String removeEmpty(HttpServletRequest request, Model model) {
        this.getManagersList().getClubManager().deleteEmptyClubs(this.getUserData().getCompetition());
        return "redirect:/data/clubs?messageCode=5";
    }

    @MethodRight(value={Right.CLUBEDIT})
    @RequestMapping(value={"/remove-all"})
    public String removeAll(HttpServletRequest request, Model model) {
        List clubs = this.getManagersList().getClubManager().getActiveClubForCompetition(this.getUserData().getCompetition());
        for (Club club : clubs) {
            this.getManagersList().getClubManager().deleteClub(club);
        }
        return "redirect:/data/clubs?messageCode=6";
    }

    @MethodRight(value={Right.CLUBEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.GET})
    public String importData(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel, @ModelAttribute(value="importClubList") List<Club> importClubList) {
        importClubList.clear();
        return "data/club-import";
    }

    @MethodRight(value={Right.CLUBEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public String importDataPost(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel, @ModelAttribute(value="importClubList") List<Club> importClubList) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        importClubList.clear();
        try {
            ArrayList clubs = new ArrayList(this.getManagersList().getClubImporter().parseClubs(importDataModel.getFileType(), importDataModel.getFile().getBytes()));
            LinkedList<String> similarClubs = new LinkedList<String>();
            for (int i = 0; i < clubs.size(); ++i) {
                for (int j = i + 1; j < clubs.size(); ++j) {
                    Club club1 = (Club)clubs.get(i);
                    Club club2 = (Club)clubs.get(j);
                    if (!SimilarDataChecker.areClubsSimilar((String)club1.getName(), (String)club2.getName())) continue;
                    similarClubs.add("'" + club1.getName() + "' - '" + club2.getName() + "'");
                }
            }
            if (similarClubs.isEmpty()) {
                this.getManagersList().getClubImporter().importClubs(this.getUserData().getCompetition(), clubs);
                return "redirect:/data/clubs?messageCode=4";
            }
            importClubList.addAll(clubs);
            model.addAttribute("similarClubs", similarClubs);
            return "data/club-import-similar";
        }
        catch (DataImportException e) {
            if (e.getErrorType() == DataImportException.ErrorType.NoClubName) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "clubs.error.noClubName"));
                return this.importData(request, model, importDataModel, importClubList);
            }
            LOGGER.error("Error while reading club data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "clubs.error.importError"));
            return this.importData(request, model, importDataModel, importClubList);
        }
        catch (Exception e) {
            LOGGER.error("Error while reading club data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "clubs.error.importError"));
            return this.importData(request, model, importDataModel, importClubList);
        }
    }

    @MethodRight(value={Right.CLUBEDIT})
    @RequestMapping(value={"/import-cached"})
    public String importCachedData(HttpServletRequest request, Model model, @ModelAttribute(value="importClubList") List<Club> importClubList) {
        this.getManagersList().getClubImporter().importClubs(this.getUserData().getCompetition(), importClubList);
        importClubList.clear();
        return "redirect:/data/clubs?messageCode=4";
    }

    @RequestMapping(value={"/export/{fileType}"})
    public void exportData(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable(value="fileType") FileType fileType) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Competition competition = this.getUserData().getCompetition();
        String fileName = competition.getName() + "-" + this.getLanguageText(locale, "clubs.export.fileName");
        if (fileType == FileType.CSV) {
            fileName = fileName + ".csv";
            response.setContentType("text/csv");
        } else if (fileType == FileType.ODS) {
            fileName = fileName + ".ods";
            response.setContentType("application/vnd.oasis.opendocument.spreadsheet");
        } else if (fileType == FileType.XLS) {
            fileName = fileName + ".xls";
            response.setContentType("application/vnd.ms-excel");
        } else if (fileType == FileType.XLSX) {
            fileName = fileName + ".xlsx";
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }
        fileName = Normalizer.normalize(fileName, Normalizer.Form.NFD).replaceAll("[^\\p{Alnum}\\x20\\x2B\\x2D\\x2E\\x5F]", "");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        String[] header = new String[]{this.getLanguageText(locale, "clubs.export.club"), this.getLanguageText(locale, "clubs.export.shortName")};
        List clubs = this.getManagersList().getClubManager().getActiveClubForCompetition(competition);
        try {
            byte[] data = this.getManagersList().getClubImporter().exportClubs(fileType, clubs, header);
            response.getOutputStream().write(data);
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("Error writeing to output stream", (Throwable)e);
        }
    }

    @RequestMapping(value={"/competitors/{clubId}"}, method={RequestMethod.GET})
    public String competitorsForClub(HttpServletRequest request, Model model, @PathVariable(value="clubId") Long clubId) {
        Club club = this.getManagersList().getClubManager().getByIdForCompetition(this.getUserData().getCompetition(), clubId);
        model.addAttribute("club", (Object)club);
        List competitors = this.getManagersList().getCompetitorManager().getCompetitorsForClub(club, Competitor.Type.COMPETITOR);
        model.addAttribute("competitors", (Object)competitors);
        for (Competitor competitor : competitors) {
            List categories = this.getManagersList().getCategoryManager().getCategoriesForCompetitor(competitor);
            competitor.setCategories(categories);
        }
        List couples = this.getManagersList().getCompetitorManager().getCompetitorsForClub(club, Competitor.Type.COUPLE);
        model.addAttribute("couples", (Object)couples);
        for (Competitor competitor : couples) {
            List categories = this.getManagersList().getCategoryManager().getCategoriesForCompetitor(competitor);
            competitor.setCategories(categories);
        }
        return "data/club-competitors-list";
    }
}

