/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.common.web.util.ControllerUtil;
import si.nevensrok.jtekma.common.Gender;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryGroup;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.DuoCategory;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.category.WeightCategoryOption;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.tools.SimilarDataChecker;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.data.CategoryModel;
import si.nevensrok.jtekma.server.web.controllers.data.ImportCategoriesModel;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/data/categories"})
@SessionAttributes(value={"categoryListFilter", "importCategoryList"})
public class CategoriesController
extends CoreController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoriesController.class);

    public Map<String, String> getCategoryTypes(Locale locale) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put(Category.Type.CUSTOM.name(), this.getLanguageText(locale, "categories.type." + Category.Type.CUSTOM.name()));
        options.put(Category.Type.FIGHTING.name(), this.getLanguageText(locale, "categories.type." + Category.Type.FIGHTING.name()));
        options.put(Category.Type.DUO.name(), this.getLanguageText(locale, "categories.type." + Category.Type.DUO.name()));
        options.put(Category.Type.DUO_2023.name(), this.getLanguageText(locale, "categories.type." + Category.Type.DUO_2023.name()));
        options.put(Category.Type.NEWAZA.name(), this.getLanguageText(locale, "categories.type." + Category.Type.NEWAZA.name()));
        return options;
    }

    public Map<String, String> getTreeTypes(Locale locale) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put(TreeCategory.TreeType.BEST_OF_3.name(), this.getLanguageText(locale, "categories.treetype." + TreeCategory.TreeType.BEST_OF_3.name()));
        options.put(TreeCategory.TreeType.TABLE2.name(), this.getLanguageText(locale, "categories.treetype." + TreeCategory.TreeType.TABLE2.name()));
        options.put(TreeCategory.TreeType.TABLE3.name(), this.getLanguageText(locale, "categories.treetype." + TreeCategory.TreeType.TABLE3.name()));
        options.put(TreeCategory.TreeType.TABLE4.name(), this.getLanguageText(locale, "categories.treetype." + TreeCategory.TreeType.TABLE4.name()));
        options.put(TreeCategory.TreeType.TABLE5.name(), this.getLanguageText(locale, "categories.treetype." + TreeCategory.TreeType.TABLE5.name()));
        options.put(TreeCategory.TreeType.TREE4.name(), this.getLanguageText(locale, "categories.treetype." + TreeCategory.TreeType.TREE4.name()));
        options.put(TreeCategory.TreeType.TREE6.name(), this.getLanguageText(locale, "categories.treetype." + TreeCategory.TreeType.TREE6.name()));
        options.put(TreeCategory.TreeType.TREE8.name(), this.getLanguageText(locale, "categories.treetype." + TreeCategory.TreeType.TREE8.name()));
        options.put(TreeCategory.TreeType.TREE16.name(), this.getLanguageText(locale, "categories.treetype." + TreeCategory.TreeType.TREE16.name()));
        options.put(TreeCategory.TreeType.TREE32.name(), this.getLanguageText(locale, "categories.treetype." + TreeCategory.TreeType.TREE32.name()));
        options.put(TreeCategory.TreeType.TREE64.name(), this.getLanguageText(locale, "categories.treetype." + TreeCategory.TreeType.TREE64.name()));
        return options;
    }

    public Map<String, String> getRepassageTypes(Locale locale) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put(TreeCategory.RepassageType.NONE.name(), this.getLanguageText(locale, "categories.repassageType." + TreeCategory.RepassageType.NONE.name()));
        options.put(TreeCategory.RepassageType.SINGLE.name(), this.getLanguageText(locale, "categories.repassageType." + TreeCategory.RepassageType.SINGLE.name()));
        options.put(TreeCategory.RepassageType.DOUBLE.name(), this.getLanguageText(locale, "categories.repassageType." + TreeCategory.RepassageType.DOUBLE.name()));
        return options;
    }

    public Map<String, String> getRepassageFromRound(Locale locale) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        for (int i = 1; i <= 5; ++i) {
            options.put(String.valueOf(i), this.getLanguageText(locale, "categories.repassageFromRound." + String.valueOf(i)));
        }
        return options;
    }

    public Map<Long, String> getTreeAdvancements() {
        LinkedHashMap<Long, String> treeAdvancements = new LinkedHashMap<Long, String>();
        TreeAdvancment example = new TreeAdvancment();
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        for (TreeAdvancment treeAdvancment : this.getManagersList().getTreeAdvancmentManager().find((DataFilter)dataFilter).getData()) {
            treeAdvancements.put(treeAdvancment.getTreeAdvancmentId(), treeAdvancment.getName());
        }
        for (TreeAdvancment treeAdvancment : this.getManagersList().getTreeAdvancmentManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter).getData()) {
            treeAdvancements.put(treeAdvancment.getTreeAdvancmentId(), treeAdvancment.getName());
        }
        return treeAdvancements;
    }

    public TreeAdvancment getTreeAdvancementById(Long treeAdvancementId) {
        return this.getManagersList().getTreeAdvancmentManager().getById(treeAdvancementId);
    }

    public Map<Long, String> getWeightCategoryOptions(Locale locale) {
        LinkedHashMap<Long, String> treeAdvancments = new LinkedHashMap<Long, String>();
        WeightCategoryOption example = new WeightCategoryOption();
        example.setStatus(WeightCategoryOption.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("gender", Sort.Field.Direction.ASC));
        dataFilter.getSort().addField(new Sort.Field("isAbsolute", Sort.Field.Direction.ASC));
        dataFilter.getSort().addField(new Sort.Field("weight", Sort.Field.Direction.ASC));
        treeAdvancments.put(0L, "--" + this.getLanguageText(locale, "common.none") + "--");
        for (WeightCategoryOption weightCategoryOption : this.getManagersList().getWeightCategoryOptionManager().find((DataFilter)dataFilter).getData()) {
            String name = this.getLanguageText(locale, "gender." + weightCategoryOption.getGender().name());
            name = weightCategoryOption.getIsAbsolute() == false ? name + " -" + weightCategoryOption.getWeight() : name + " +" + weightCategoryOption.getWeight();
            treeAdvancments.put(weightCategoryOption.getWeightCategoryOptionId(), name);
        }
        return treeAdvancments;
    }

    public WeightCategoryOption getWeightCategoryOptionById(Long weightCategoryOptionId) {
        return this.getManagersList().getWeightCategoryOptionManager().getById(weightCategoryOptionId);
    }

    public Map<Long, String> getAgeCategoryOptions(Locale locale) {
        LinkedHashMap<Long, String> ageCategoryOptions = new LinkedHashMap<Long, String>();
        AgeCategoryOption example = new AgeCategoryOption();
        example.setStatus(AgeCategoryOption.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        ageCategoryOptions.put(0L, "--" + this.getLanguageText(locale, "common.none") + "--");
        for (AgeCategoryOption ageCategoryOption : this.getManagersList().getAgeCategoryOptionManager().find((DataFilter)dataFilter).getData()) {
            ageCategoryOptions.put(ageCategoryOption.getAgeCategoryId(), ageCategoryOption.getName());
        }
        return ageCategoryOptions;
    }

    public AgeCategoryOption getAgeCategoryOptionById(Long ageCategoryOptionId) {
        return this.getManagersList().getAgeCategoryOptionManager().getById(ageCategoryOptionId);
    }

    public Map<String, String> getGenderOptions(Locale locale) {
        LinkedHashMap<String, String> categoryTypes = new LinkedHashMap<String, String>();
        categoryTypes.put(Gender.MALE.name(), this.getLanguageText(locale, "gender." + Gender.MALE.name()));
        categoryTypes.put(Gender.FEMALE.name(), this.getLanguageText(locale, "gender." + Gender.FEMALE.name()));
        categoryTypes.put(Gender.MIX.name(), this.getLanguageText(locale, "gender." + Gender.MIX.name()));
        return categoryTypes;
    }

    public Map<Long, String> getCategoryGroups() {
        LinkedHashMap<Long, String> categoryGroups = new LinkedHashMap<Long, String>();
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        dataFilter.setFetchCount(false);
        PageDataResult dataResult = this.getManagersList().getCategoryGroupManager().findCategoryGroups(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        for (CategoryGroup categoryGroup : dataResult.getData()) {
            categoryGroups.put(categoryGroup.getCategoryGroupId(), categoryGroup.getName());
        }
        return categoryGroups;
    }

    private void addFormOptions(Model model, Locale locale) {
        model.addAttribute("categoryTypes", this.getCategoryTypes(locale));
        model.addAttribute("treeAdvancements", this.getTreeAdvancements());
        model.addAttribute("treeTypes", this.getTreeTypes(locale));
        model.addAttribute("repassageTypes", this.getRepassageTypes(locale));
        model.addAttribute("repassageFromRoundTypes", this.getRepassageFromRound(locale));
        model.addAttribute("weightCategoryOptions", this.getWeightCategoryOptions(locale));
        model.addAttribute("ageCategoryOptions", this.getAgeCategoryOptions(locale));
        model.addAttribute("genders", this.getGenderOptions(locale));
        model.addAttribute("categoryGroupOptions", this.getCategoryGroups());
    }

    @ModelAttribute(value="categoriesActive")
    public Boolean getCategoriesActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="categoryListFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @ModelAttribute(value="importCategoryList")
    public List<Category> getImportCategoryList() {
        return new LinkedList<Category>();
    }

    @ModelAttribute(value="editRights")
    public Boolean getEditRights() {
        return this.hasRights(Right.CATEGORYEDIT);
    }

    @ModelAttribute(value="fileTypes")
    public Map<FileType, String> getFileTypes(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<FileType, String> importType = new LinkedHashMap<FileType, String>();
        importType.put(FileType.CSV, this.getLanguageText(locale, "filetypes.csv"));
        importType.put(FileType.ODS, this.getLanguageText(locale, "filetypes.ods"));
        importType.put(FileType.XLS, this.getLanguageText(locale, "filetypes.xls"));
        importType.put(FileType.XLSX, this.getLanguageText(locale, "filetypes.xlsx"));
        return importType;
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="categoryListFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Category example = new Category();
        example.setName("%" + searchFilter.getSearch().trim() + "%");
        example.setStatus(Category.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        dataFilter.setItemCountPerPage(searchFilter.getShowPerPage().intValue());
        dataFilter.setPage(searchFilter.getPage().intValue());
        PageDataResult dataResult = this.getManagersList().getCategoryManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        model.addAttribute("categories", (Object)dataResult.getData());
        model.addAttribute("totalPages", (Object)dataResult.getPageCount(true));
        Map competitorCount = this.getManagersList().getCategoryManager().getCategoryCompetitorCount(new HashSet(dataResult.getData()));
        model.addAttribute("competitorCount", (Object)competitorCount);
        if (messageCode.equals(1)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "categories.text.added"));
        } else if (messageCode.equals(2)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "categories.text.updated"));
        } else if (messageCode.equals(3)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "categories.text.deleted"));
        } else if (messageCode.equals(4)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "categories.text.imported"));
        } else if (messageCode.equals(5)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "categories.text.emptyRemoved"));
        } else if (messageCode.equals(6)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "categories.text.allRemoved"));
        }
        return "data/category-list";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="category") CategoryModel categoryModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        this.addFormOptions(model, RequestContextUtils.getLocale((HttpServletRequest)request));
        return "data/category-edit";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="category") @Valid CategoryModel categoryModel, BindingResult bindingResult) {
        FightingCategory category;
        AgeCategoryOption ageCategoryOption;
        WeightCategoryOption weightCategoryOption;
        if (categoryModel.getType() == null) {
            bindingResult.rejectValue("type", "common.error.dataNotSelected");
        }
        if (bindingResult.hasErrors()) {
            return this.add(request, model, categoryModel, bindingResult);
        }
        if (categoryModel.getType() == Category.Type.FIGHTING) {
            FightingCategory fightingCategory = new FightingCategory();
            if (categoryModel.getWeightCategoryOptionId() != null && categoryModel.getWeightCategoryOptionId() > 0L) {
                weightCategoryOption = this.getWeightCategoryOptionById(categoryModel.getWeightCategoryOptionId());
                fightingCategory.setWeightCategoryOption(weightCategoryOption);
            }
            if (categoryModel.getAgeCategoryOptionId() != null && categoryModel.getAgeCategoryOptionId() > 0L) {
                ageCategoryOption = this.getAgeCategoryOptionById(categoryModel.getAgeCategoryOptionId());
                fightingCategory.setAgeCategoryOption(ageCategoryOption);
            }
            category = fightingCategory;
            category.setType(Category.Type.FIGHTING);
        } else if (categoryModel.getType() == Category.Type.DUO) {
            DuoCategory duoCategory = new DuoCategory();
            if (categoryModel.getAgeCategoryOptionId() != null && categoryModel.getAgeCategoryOptionId() > 0L) {
                ageCategoryOption = this.getAgeCategoryOptionById(categoryModel.getAgeCategoryOptionId());
                duoCategory.setAgeCategoryOption(ageCategoryOption);
            }
            duoCategory.setGender(categoryModel.getGender());
            category = duoCategory;
            category.setType(Category.Type.DUO);
        } else if (categoryModel.getType() == Category.Type.DUO_2023) {
            Duo2023Category duo2023Category = new Duo2023Category();
            if (categoryModel.getAgeCategoryOptionId() != null && categoryModel.getAgeCategoryOptionId() > 0L) {
                ageCategoryOption = this.getAgeCategoryOptionById(categoryModel.getAgeCategoryOptionId());
                duo2023Category.setAgeCategoryOption(ageCategoryOption);
            }
            duo2023Category.setGender(categoryModel.getGender());
            duo2023Category.setDouble3rdPlace(categoryModel.getDouble3rdPlace());
            duo2023Category.setAdvancedLevel(categoryModel.getAdvancedLevel());
            duo2023Category.setNoviceLevel(categoryModel.getNoviceLevel());
            category = duo2023Category;
            category.setType(Category.Type.DUO);
        } else if (categoryModel.getType() == Category.Type.NEWAZA) {
            NewazaCategory newazaCategory = new NewazaCategory();
            if (categoryModel.getWeightCategoryOptionId() != null && categoryModel.getWeightCategoryOptionId() > 0L) {
                weightCategoryOption = this.getWeightCategoryOptionById(categoryModel.getWeightCategoryOptionId());
                newazaCategory.setWeightCategoryOption(weightCategoryOption);
            }
            if (categoryModel.getAgeCategoryOptionId() != null && categoryModel.getAgeCategoryOptionId() > 0L) {
                ageCategoryOption = this.getAgeCategoryOptionById(categoryModel.getAgeCategoryOptionId());
                newazaCategory.setAgeCategoryOption(ageCategoryOption);
            }
            category = newazaCategory;
            category.setType(Category.Type.NEWAZA);
        } else {
            category = new Category();
            category.setType(Category.Type.CUSTOM);
        }
        if (category instanceof TreeCategory) {
            TreeCategory treeCategory = (TreeCategory)category;
            treeCategory.setTreeType(categoryModel.getTreeType());
            treeCategory.setRepassageType(categoryModel.getRepassageType());
            treeCategory.setDouble3rdPlace(categoryModel.getDouble3rdPlace());
            treeCategory.setRepassageFromRound(categoryModel.getRepassageFromRound());
            TreeAdvancment treeAdvancement = this.getTreeAdvancementById(categoryModel.getTreeAdvancmentId());
            treeCategory.setTreeAdvancment(treeAdvancement);
        }
        ObjectUtil.copyNotNullProperties((Object)categoryModel, (Object)category);
        if (category.getShortName() == null || category.getShortName().isEmpty()) {
            category.setShortName(category.getName());
        }
        category.setCompetition(this.getUserData().getCompetition());
        category.setStatus(Category.Status.ACTIVE);
        category = this.getManagersList().getCategoryManager().createCategory((Category)category);
        LinkedList<CategoryGroup> categoryGroups = new LinkedList<CategoryGroup>();
        for (Long categoryGroupId : categoryModel.getCategoryGroupIds()) {
            CategoryGroup categoryGroup = this.getManagersList().getCategoryGroupManager().getCategoryGroupById(categoryGroupId);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategoryGroup(categoryGroup).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition");
            }
            categoryGroups.add(categoryGroup);
        }
        this.getManagersList().getCategoryGroupManager().setCategoryGroupsForCategory((Category)category, categoryGroups);
        return "redirect:/data/categories?messageCode=1";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/edit/{categoryId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="categoryId") Long categoryId, @ModelAttribute(value="category") CategoryModel categoryModel, BindingResult bindingResult) {
        if (!bindingResult.hasErrors()) {
            Category category = this.getManagersList().getCategoryManager().getFullById(categoryId);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition");
            }
            ObjectUtil.copyNotNullProperties((Object)category, (Object)categoryModel);
            if (category instanceof TreeCategory) {
                TreeCategory treeCategory = (TreeCategory)category;
                categoryModel.setTreeType(treeCategory.getTreeType());
                categoryModel.setRepassageType(treeCategory.getRepassageType());
                categoryModel.setDouble3rdPlace(treeCategory.getDouble3rdPlace());
                categoryModel.setRepassageFromRound(treeCategory.getRepassageFromRound());
                Long treeAdvancmentId = treeCategory.getTreeAdvancment().getTreeAdvancmentId();
                categoryModel.setTreeAdvancmentId(treeAdvancmentId);
            }
            if (category instanceof FightingCategory) {
                FightingCategory fightingCategory = (FightingCategory)category;
                if (fightingCategory.getWeightCategoryOption() != null) {
                    categoryModel.setWeightCategoryOptionId(fightingCategory.getWeightCategoryOption().getWeightCategoryOptionId());
                }
                if (fightingCategory.getAgeCategoryOption() != null) {
                    categoryModel.setAgeCategoryOptionId(fightingCategory.getAgeCategoryOption().getAgeCategoryId());
                }
            }
            if (category instanceof DuoCategory) {
                DuoCategory duoCategory = (DuoCategory)category;
                if (duoCategory.getAgeCategoryOption() != null) {
                    categoryModel.setAgeCategoryOptionId(duoCategory.getAgeCategoryOption().getAgeCategoryId());
                }
                categoryModel.setGender(duoCategory.getGender());
            }
            if (category instanceof Duo2023Category) {
                Duo2023Category duo2023Category = (Duo2023Category)category;
                if (duo2023Category.getAgeCategoryOption() != null) {
                    categoryModel.setAgeCategoryOptionId(duo2023Category.getAgeCategoryOption().getAgeCategoryId());
                }
                categoryModel.setGender(duo2023Category.getGender());
                categoryModel.setDouble3rdPlace(duo2023Category.getDouble3rdPlace());
                categoryModel.setAdvancedLevel(duo2023Category.getAdvancedLevel());
                categoryModel.setNoviceLevel(duo2023Category.getNoviceLevel());
            }
            if (category instanceof NewazaCategory) {
                NewazaCategory newazaCategory = (NewazaCategory)category;
                if (newazaCategory.getWeightCategoryOption() != null) {
                    categoryModel.setWeightCategoryOptionId(newazaCategory.getWeightCategoryOption().getWeightCategoryOptionId());
                }
                if (newazaCategory.getAgeCategoryOption() != null) {
                    categoryModel.setAgeCategoryOptionId(newazaCategory.getAgeCategoryOption().getAgeCategoryId());
                }
            }
            List categoryGroups = this.getManagersList().getCategoryGroupManager().getCategoryGroupsForCategory(category);
            for (CategoryGroup categoryGroup : categoryGroups) {
                categoryModel.getCategoryGroupIds().add(categoryGroup.getCategoryGroupId());
            }
        }
        this.addFormOptions(model, RequestContextUtils.getLocale((HttpServletRequest)request));
        return "data/category-edit";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/edit/{categoryId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="categoryId") Long categoryId, @ModelAttribute(value="category") @Valid CategoryModel categoryModel, BindingResult bindingResult) {
        AgeCategoryOption ageCategoryOption;
        WeightCategoryOption weightCategoryOption;
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, categoryId, categoryModel, bindingResult);
        }
        LOGGER.debug("Category model {}", (Object)categoryModel);
        Category category = this.getManagersList().getCategoryManager().getById(categoryId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)categoryModel, (Object)category);
        if (category.getShortName() == null || category.getShortName().isEmpty()) {
            category.setShortName(category.getName());
        }
        if (category instanceof TreeCategory) {
            TreeCategory treeCategory = (TreeCategory)category;
            treeCategory.setTreeType(categoryModel.getTreeType());
            treeCategory.setRepassageType(categoryModel.getRepassageType());
            treeCategory.setDouble3rdPlace(categoryModel.getDouble3rdPlace());
            treeCategory.setRepassageFromRound(categoryModel.getRepassageFromRound());
            TreeAdvancment treeAdvancment = this.getTreeAdvancementById(categoryModel.getTreeAdvancmentId());
            treeCategory.setTreeAdvancment(treeAdvancment);
        }
        if (category instanceof FightingCategory) {
            FightingCategory fightingCategory = (FightingCategory)category;
            if (categoryModel.getWeightCategoryOptionId() != null && categoryModel.getWeightCategoryOptionId() > 0L) {
                weightCategoryOption = this.getWeightCategoryOptionById(categoryModel.getWeightCategoryOptionId());
                fightingCategory.setWeightCategoryOption(weightCategoryOption);
            }
            if (categoryModel.getAgeCategoryOptionId() != null && categoryModel.getAgeCategoryOptionId() > 0L) {
                ageCategoryOption = this.getAgeCategoryOptionById(categoryModel.getAgeCategoryOptionId());
                fightingCategory.setAgeCategoryOption(ageCategoryOption);
            }
        }
        if (category instanceof DuoCategory) {
            DuoCategory duoCategory = (DuoCategory)category;
            if (categoryModel.getAgeCategoryOptionId() != null && categoryModel.getAgeCategoryOptionId() > 0L) {
                ageCategoryOption = this.getAgeCategoryOptionById(categoryModel.getAgeCategoryOptionId());
                duoCategory.setAgeCategoryOption(ageCategoryOption);
            }
            duoCategory.setGender(categoryModel.getGender());
        }
        if (category instanceof Duo2023Category) {
            Duo2023Category duo2023Category = (Duo2023Category)category;
            if (categoryModel.getAgeCategoryOptionId() != null && categoryModel.getAgeCategoryOptionId() > 0L) {
                ageCategoryOption = this.getAgeCategoryOptionById(categoryModel.getAgeCategoryOptionId());
                duo2023Category.setAgeCategoryOption(ageCategoryOption);
            }
            duo2023Category.setGender(categoryModel.getGender());
            duo2023Category.setDouble3rdPlace(categoryModel.getDouble3rdPlace());
            duo2023Category.setAdvancedLevel(categoryModel.getAdvancedLevel());
            duo2023Category.setNoviceLevel(categoryModel.getNoviceLevel());
        }
        if (category instanceof NewazaCategory) {
            NewazaCategory newazaCategory = (NewazaCategory)category;
            if (categoryModel.getWeightCategoryOptionId() != null && categoryModel.getWeightCategoryOptionId() > 0L) {
                weightCategoryOption = this.getWeightCategoryOptionById(categoryModel.getWeightCategoryOptionId());
                newazaCategory.setWeightCategoryOption(weightCategoryOption);
            }
            if (categoryModel.getAgeCategoryOptionId() != null && categoryModel.getAgeCategoryOptionId() > 0L) {
                ageCategoryOption = this.getAgeCategoryOptionById(categoryModel.getAgeCategoryOptionId());
                newazaCategory.setAgeCategoryOption(ageCategoryOption);
            }
        }
        category = this.getManagersList().getCategoryManager().updateCategoryFull(category);
        LinkedList<CategoryGroup> categoryGroups = new LinkedList<CategoryGroup>();
        for (Long categoryGroupId : categoryModel.getCategoryGroupIds()) {
            CategoryGroup categoryGroup = this.getManagersList().getCategoryGroupManager().getCategoryGroupById(categoryGroupId);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategoryGroup(categoryGroup).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition");
            }
            categoryGroups.add(categoryGroup);
        }
        this.getManagersList().getCategoryGroupManager().setCategoryGroupsForCategory(category, categoryGroups);
        return "redirect:/data/categories?messageCode=2";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/delete/{categoryId}"})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="categoryId") Long categoryId) {
        Category category = this.getManagersList().getCategoryManager().getById(categoryId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        this.getManagersList().getCategoryManager().deleteCategory(category);
        return "redirect:/data/categories?messageCode=3";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/remove-empty"})
    public String removeEmpty(HttpServletRequest request, Model model) {
        this.getManagersList().getCategoryManager().deleteEmptyCategories(this.getUserData().getCompetition());
        return "redirect:/data/categories?messageCode=5";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/remove-all"})
    public String removeAll(HttpServletRequest request, Model model) {
        List categories = this.getManagersList().getCategoryManager().getActiveCategoriesForCompetition(this.getUserData().getCompetition());
        for (Category category : categories) {
            this.getManagersList().getCategoryManager().deleteCategory(category);
        }
        return "redirect:/data/categories?messageCode=6";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.GET})
    public String importData(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportCategoriesModel importCategoriesModel, @ModelAttribute(value="importCategoryList") List<Category> importCategoryList) {
        importCategoryList.clear();
        this.addFormOptions(model, RequestContextUtils.getLocale((HttpServletRequest)request));
        return "data/category-import";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public String importDataPost(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportCategoriesModel importCategoriesModel, @ModelAttribute(value="importCategoryList") List<Category> importCategoryList) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        importCategoryList.clear();
        try {
            Competition competition = this.getUserData().getCompetition();
            Category.Type defaultType = importCategoriesModel.getType();
            TreeCategory.RepassageType repassageType = importCategoriesModel.getRepassageType();
            boolean double3rdPlace = importCategoriesModel.getDouble3rdPlace();
            int repassageFromRound = importCategoriesModel.getRepassageFromRound();
            boolean advancedLevel = importCategoriesModel.getAdvancedLevel();
            boolean noviceLevel = importCategoriesModel.getNoviceLevel();
            TreeAdvancment treeAdvancment = this.getTreeAdvancementById(importCategoriesModel.getTreeAdvancementId());
            LinkedHashMap errors = new LinkedHashMap();
            ArrayList categories = new ArrayList(this.getManagersList().getCategoryImporter().parseCategories(importCategoriesModel.getFileType(), importCategoriesModel.getFile().getBytes(), competition, defaultType, repassageType, double3rdPlace, repassageFromRound, advancedLevel, noviceLevel, treeAdvancment, errors));
            if (!errors.isEmpty()) {
                LinkedList<String> errorMessages = new LinkedList<String>();
                for (Map.Entry entry : errors.entrySet()) {
                    if (entry.getValue() == DataImportException.ErrorType.CategoryTypeInvalid) {
                        errorMessages.add(this.getLanguageText(locale, "categories.error.categoryTypeInvalid", new String[]{(String)entry.getKey()}));
                        continue;
                    }
                    if (entry.getValue() == DataImportException.ErrorType.CategoryTypeEmpty) {
                        errorMessages.add(this.getLanguageText(locale, "categories.error.categoryTypeEmpty", new String[]{(String)entry.getKey()}));
                        continue;
                    }
                    if (entry.getValue() == DataImportException.ErrorType.AgeCategoryInvalid) {
                        errorMessages.add(this.getLanguageText(locale, "categories.error.ageCategoryInvalid", new String[]{(String)entry.getKey()}));
                        continue;
                    }
                    if (entry.getValue() != DataImportException.ErrorType.WeightCategoryInvalid) continue;
                    errorMessages.add(this.getLanguageText(locale, "categories.error.weightCategoryInvalid", new String[]{(String)entry.getKey()}));
                }
                model.addAttribute("errorMessages", errorMessages);
                return this.importData(request, model, importCategoriesModel, importCategoryList);
            }
            LinkedList<String> similarCategories = new LinkedList<String>();
            for (int i = 0; i < categories.size(); ++i) {
                for (int j = i + 1; j < categories.size(); ++j) {
                    Category category1 = (Category)categories.get(i);
                    Category category2 = (Category)categories.get(j);
                    if (!SimilarDataChecker.areCategoriesSimilar((String)category1.getName(), (String)category2.getName())) continue;
                    similarCategories.add("'" + category1.getName() + "' - '" + category2.getName() + "'");
                }
            }
            if (similarCategories.isEmpty()) {
                this.getManagersList().getCategoryImporter().importCategories(this.getUserData().getCompetition(), categories);
                return "redirect:/data/categories?messageCode=4";
            }
            importCategoryList.addAll(categories);
            model.addAttribute("similarCategories", similarCategories);
            return "data/category-import-similar";
        }
        catch (DataImportException e) {
            if (e.getErrorType() == DataImportException.ErrorType.NoCategoryName) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "categories.error.noCategoryName"));
                return this.importData(request, model, importCategoriesModel, importCategoryList);
            }
            if (e.getErrorType() == DataImportException.ErrorType.NoCategoryType) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "categories.error.noCategoryType"));
                return this.importData(request, model, importCategoriesModel, importCategoryList);
            }
            LOGGER.error("Error while reading category data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "categories.error.importError"));
            return this.importData(request, model, importCategoriesModel, importCategoryList);
        }
        catch (Exception e) {
            LOGGER.error("Error while reading category data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "categories.error.importError"));
            return this.importData(request, model, importCategoriesModel, importCategoryList);
        }
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/import-cached"})
    public String importCachedData(HttpServletRequest request, Model model, @ModelAttribute(value="importCategoryList") List<Category> importCategoryList) {
        this.getManagersList().getCategoryImporter().importCategories(this.getUserData().getCompetition(), importCategoryList);
        importCategoryList.clear();
        return "redirect:/data/categories?messageCode=4";
    }

    @RequestMapping(value={"/export/{fileType}"})
    public void exportData(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable(value="fileType") FileType fileType) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Competition competition = this.getUserData().getCompetition();
        String fileName = competition.getName() + "-" + this.getLanguageText(locale, "categories.export.fileName");
        if (fileType == FileType.CSV) {
            fileName = fileName + ".csv";
            response.setContentType("text/csv");
        } else if (fileType == FileType.ODS) {
            fileName = fileName + ".ods";
            response.setContentType("application/vnd.oasis.opendocument.spreadsheet");
        } else if (fileType == FileType.XLS) {
            fileName = fileName + ".xls";
            response.setContentType("application/vnd.ms-excel");
        } else if (fileType == FileType.XLSX) {
            fileName = fileName + ".xlsx";
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }
        ControllerUtil.addContentDispositionHeader((HttpServletResponse)response, (String)fileName);
        String[] header = new String[]{this.getLanguageText(locale, "categories.export.category"), this.getLanguageText(locale, "categories.export.shortName"), this.getLanguageText(locale, "categories.export.type"), this.getLanguageText(locale, "categories.export.ageCategory"), this.getLanguageText(locale, "categories.export.weightCategory"), this.getLanguageText(locale, "categories.export.categoryGroup")};
        List categories = this.getManagersList().getCategoryManager().getActiveCategoriesForCompetition(competition);
        for (Category category : categories) {
            category.setCategoryGroups(this.getManagersList().getCategoryGroupManager().getCategoryGroupsForCategory(category));
        }
        try {
            byte[] data = this.getManagersList().getCategoryImporter().exportCategories(fileType, categories, header);
            response.getOutputStream().write(data);
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("Error writing to output stream", (Throwable)e);
        }
    }

    @RequestMapping(value={"/competitors/{categoryId}"}, method={RequestMethod.GET})
    public String competitorsForCategory(HttpServletRequest request, Model model, @PathVariable(value="categoryId") Long categoryId) {
        List couples;
        Category category = this.getManagersList().getCategoryManager().getById(categoryId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        model.addAttribute("category", (Object)category);
        List competitors = this.getManagersList().getCompetitorManager().getCompetitorsForCategory(category, Competitor.Type.COMPETITOR);
        if (!competitors.isEmpty()) {
            model.addAttribute("competitors", (Object)competitors);
        }
        if (!(couples = this.getManagersList().getCompetitorManager().getCompetitorsForCategory(category, Competitor.Type.COUPLE)).isEmpty()) {
            model.addAttribute("couples", (Object)couples);
        }
        return "data/category-competitors-list";
    }
}

