/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.competition;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.common.web.util.ControllerUtil;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiHistory;
import si.nevensrok.jtekma.server.web.common.CommonResponse;
import si.nevensrok.jtekma.server.web.common.competition.Event;
import si.nevensrok.jtekma.server.web.common.competition.Match;
import si.nevensrok.jtekma.server.web.common.competition.TatamiFight;
import si.nevensrok.jtekma.server.web.common.competition.TatamiHistoryEvent;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;

@Controller
@RequestMapping(value={"/competition/data"})
public class CompetitionDataTatamiController
extends CoreController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompetitionDataTatamiController.class);

    @RequestMapping(value={"/tatami"}, method={RequestMethod.GET})
    @ResponseBody
    public List<si.nevensrok.jtekma.server.web.common.competition.Tatami> getTatamis(HttpServletResponse response) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setItemLimit(Integer.valueOf(1000));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        LinkedList<si.nevensrok.jtekma.server.web.common.competition.Tatami> tatamis = new LinkedList<si.nevensrok.jtekma.server.web.common.competition.Tatami>();
        for (Tatami tatami : this.getManagersList().getTatamiManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter).getData()) {
            tatamis.add(new si.nevensrok.jtekma.server.web.common.competition.Tatami(tatami));
        }
        return tatamis;
    }

    @RequestMapping(value={"/tatami-fights"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TatamiFight> getTatamiFights(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="tatamiId") Long tatamiId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        LinkedList<TatamiFight> tatamiFights = new LinkedList<TatamiFight>();
        for (FightOrder fightOrder : this.getManagersList().getTatamiManager().getFightOrderForTatami(tatami)) {
            Set points;
            Category category;
            si.nevensrok.jtekma.common.matches.Match match = fightOrder.getMatch();
            DuoPresentation duoPresentation = fightOrder.getDuoPresentation();
            if (match != null) {
                match = this.getManagersList().getMatchManager().getByIdWithCompetitors(match.getMatchId());
                fightOrder.setMatch(match);
                category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
                match.setCategory(category);
            }
            if (duoPresentation != null) {
                duoPresentation = this.getManagersList().getDuoPresentationManager().getByIdWithCompetitor(duoPresentation.getDuoPresentationId());
                fightOrder.setDuoPresentation(duoPresentation);
                category = this.getManagersList().getCategoryManager().getCategoryForDuoPresentation(duoPresentation);
                duoPresentation.setCategory(category);
            }
            TatamiFight tatamiFight = new TatamiFight(fightOrder);
            if (match != null) {
                TreeCategory treeCategory = null;
                if (match.getCategory() instanceof TreeCategory) {
                    treeCategory = (TreeCategory)match.getCategory();
                }
                if (treeCategory != null) {
                    tatamiFight.getMatch().setName(this.getTools().getMatchTool().getMatchName(locale, treeCategory, match));
                    tatamiFight.getMatch().setShortName(this.getTools().getMatchTool().getMatchShortName(treeCategory, match));
                }
                points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
                tatamiFight.getMatch().setPoints1(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points)));
                tatamiFight.getMatch().setPoints2(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points)));
            }
            if (duoPresentation != null) {
                Duo2023Category duo2023Category = null;
                if (duoPresentation.getCategory() instanceof Duo2023Category) {
                    duo2023Category = (Duo2023Category)duoPresentation.getCategory();
                }
                if (duo2023Category != null) {
                    tatamiFight.getDuoPresentation().setName(this.getTools().getMatchTool().generateDuoPresentationName(locale, duoPresentation));
                    tatamiFight.getDuoPresentation().setShortName(this.getTools().getMatchTool().generateDuoPresentationShortName(locale, duoPresentation));
                }
                points = this.getManagersList().getDuoPresentationManager().getDuoPresentationPointsForDuoPresentation(duoPresentation);
                tatamiFight.getDuoPresentation().setPoints(Float.valueOf(competitionRules.sumDuoPresentationPoints(points)));
            }
            tatamiFights.add(tatamiFight);
        }
        return tatamiFights;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/add-fight-to-tatami/{tatamiId}/{matchId}"})
    @ResponseBody
    public CommonResponse addMatchToTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean added = this.getManagersList().getTatamiFightsManager().addMatchToTatami(match, tatami);
            return new CommonResponse(added);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/remove-fight-from-tatami/{tatamiId}/{matchId}"})
    @ResponseBody
    public CommonResponse removeMatchFromTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean removed = this.getManagersList().getTatamiFightsManager().removeMatchFromTatami(match, tatami);
            return new CommonResponse(removed);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/moveup-fight-tatami/{tatamiId}/{matchId}"})
    @ResponseBody
    public CommonResponse moveUpMatchOnTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean moved = this.getManagersList().getTatamiFightsManager().moveMatchOnTatamiUp(match, tatami);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/movedown-fight-tatami/{tatamiId}/{matchId}"})
    @ResponseBody
    public CommonResponse moveDownMatchOnTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="matchId") Long matchId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean moved = this.getManagersList().getTatamiFightsManager().moveMatchOnTatamiDown(match, tatami);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/move-fight-tatami/{tatamiId}/{matchId}/{moveToSpot}"})
    @ResponseBody
    public CommonResponse moveMatchCustomOnTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="matchId") Long matchId, @PathVariable(value="moveToSpot") Integer moveToSpot) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.matches.Match match = this.getManagersList().getMatchManager().getById(matchId);
        if (match != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean moved = this.getManagersList().getTatamiFightsManager().moveMatchOnTatamiToSpot(match, tatami, moveToSpot);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @RequestMapping(value={"/event"}, method={RequestMethod.GET})
    @ResponseBody
    public Event getEvent(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="eventId") Long eventId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getLanguageText(locale, "dateformat.full"));
        si.nevensrok.jtekma.common.tatami.Event event = this.getManagersList().getEventManager().getById(eventId);
        if (event != null) {
            Tatami tatami = this.getManagersList().getTatamiManager().getTatamiForEvent(event);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for tatami");
            }
            Event eventResponse = new Event(event);
            if (event.getRemoveAt() != null) {
                eventResponse.setRemoveAt(dateFormat.format(event.getRemoveAt().getTime()));
            }
            return eventResponse;
        }
        return null;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/event"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse setEvent(HttpServletRequest request, HttpServletResponse response, @RequestBody Event eventData, @RequestParam(value="eventId", required=false) Long eventId, @RequestParam(value="tatamiId", required=false) Long tatamiId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getLanguageText(locale, "dateformat.full"));
        if (eventId == null && tatamiId != null) {
            Tatami tatami = this.getManagersList().getTatamiManager().getById(tatamiId);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for tatami");
            }
            si.nevensrok.jtekma.common.tatami.Event event = new si.nevensrok.jtekma.common.tatami.Event();
            event.setText(eventData.getText());
            event.setAutoRemove(eventData.getAutoRemove());
            if (StringUtil.isNotBlank((String)eventData.getRemoveAt())) {
                try {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(dateFormat.parse(eventData.getRemoveAt().trim()));
                    event.setRemoveAt(calendar);
                }
                catch (Exception e) {
                    LOGGER.debug("Error parsing date", (Throwable)e);
                }
            }
            boolean added = this.getManagersList().getTatamiFightsManager().addEventToTatami(event, tatami);
            return new CommonResponse(added);
        }
        si.nevensrok.jtekma.common.tatami.Event event = this.getManagersList().getEventManager().getById(eventId);
        if (event != null) {
            Tatami tatami = this.getManagersList().getTatamiManager().getTatamiForEvent(event);
            Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for tatami");
            }
            event.setText(eventData.getText());
            event.setAutoRemove(eventData.getAutoRemove());
            if (StringUtil.isNotBlank((String)eventData.getRemoveAt())) {
                try {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(dateFormat.parse(eventData.getRemoveAt().trim()));
                    event.setRemoveAt(calendar);
                }
                catch (Exception e) {
                    LOGGER.debug("Error parsing date", (Throwable)e);
                }
            }
            this.getManagersList().getEventManager().updateEvent(event);
            return new CommonResponse(true);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/remove-event-from-tatami/{tatamiId}/{eventId}"})
    @ResponseBody
    public CommonResponse removeEventFromTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="eventId") Long eventId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.tatami.Event event = this.getManagersList().getEventManager().getById(eventId);
        if (event != null) {
            boolean removed = this.getManagersList().getTatamiFightsManager().removeEventFromTatami(event, tatami);
            return new CommonResponse(removed);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/moveup-event-tatami/{tatamiId}/{eventId}"})
    @ResponseBody
    public CommonResponse moveUpEventOnTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="eventId") Long eventId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.tatami.Event event = this.getManagersList().getEventManager().getById(eventId);
        if (event != null) {
            boolean moved = this.getManagersList().getTatamiFightsManager().moveEventOnTatamiUp(event, tatami);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/movedown-event-tatami/{tatamiId}/{eventId}"})
    @ResponseBody
    public CommonResponse moveDownEventOnTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="eventId") Long eventId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.tatami.Event event = this.getManagersList().getEventManager().getById(eventId);
        if (event != null) {
            boolean moved = this.getManagersList().getTatamiFightsManager().moveEventOnTatamiDown(event, tatami);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/move-event-tatami/{tatamiId}/{eventId}/{moveToSpot}"})
    @ResponseBody
    public CommonResponse moveEventOnTatamiToSpot(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="eventId") Long eventId, @PathVariable(value="moveToSpot") Integer moveToSpot) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        si.nevensrok.jtekma.common.tatami.Event event = this.getManagersList().getEventManager().getById(eventId);
        if (event != null) {
            boolean moved = this.getManagersList().getTatamiFightsManager().moveEventOnTatamiToSpot(event, tatami, moveToSpot);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @RequestMapping(value={"/tatami-history"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TatamiHistoryEvent> getTatamiHistory(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="tatamiId") Long tatamiId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        LinkedList<TatamiHistoryEvent> tatamiHistoryEvents = new LinkedList<TatamiHistoryEvent>();
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setItemLimit(Integer.valueOf(20));
        dataFilter.setFetchCount(false);
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("eventDate", Sort.Field.Direction.DESC));
        PageDataResult dataResult = this.getManagersList().getTatamiHistoryManager().findTatamiHistory(tatami, (DataFilter)dataFilter);
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getLanguageText(locale, "dateformat.full"));
        for (TatamiHistory tatamiHistory : dataResult.getData()) {
            Category category;
            si.nevensrok.jtekma.common.matches.Match match = tatamiHistory.getMatch();
            DuoPresentation duoPresentation = tatamiHistory.getDuoPresentation();
            if (match != null) {
                match = this.getManagersList().getMatchManager().getByIdWithCompetitors(match.getMatchId());
                category = this.getManagersList().getCategoryManager().getCategoryForMatch(match);
                match.setCategory(category);
            }
            if (duoPresentation != null) {
                duoPresentation = this.getManagersList().getDuoPresentationManager().getByIdWithCompetitor(duoPresentation.getDuoPresentationId());
                category = this.getManagersList().getCategoryManager().getCategoryForDuoPresentation(duoPresentation);
                duoPresentation.setCategory(category);
            }
            TatamiHistoryEvent tatamiHistoryEvent = new TatamiHistoryEvent();
            tatamiHistoryEvent.setEventDate(tatamiHistory.getEventDate());
            tatamiHistoryEvent.setEventDateText(dateFormat.format(tatamiHistory.getEventDate()));
            tatamiHistoryEvent.setEventType(tatamiHistory.getEventType());
            if (match != null) {
                tatamiHistoryEvent.setMatch(new Match(match));
                TreeCategory treeCategory = null;
                if (match.getCategory() instanceof TreeCategory) {
                    treeCategory = (TreeCategory)match.getCategory();
                }
                if (treeCategory != null) {
                    tatamiHistoryEvent.getMatch().setName(this.getTools().getMatchTool().getMatchName(locale, treeCategory, match));
                    tatamiHistoryEvent.getMatch().setShortName(this.getTools().getMatchTool().getMatchShortName(treeCategory, match));
                }
                if (tatamiHistory.getEventType() == TatamiHistory.EventType.PUSHMATCH) {
                    Set points = this.getManagersList().getMatchManager().getMatchPointsForMatch(match);
                    tatamiHistoryEvent.getMatch().setPoints1(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points)));
                    tatamiHistoryEvent.getMatch().setPoints2(Float.valueOf(competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points)));
                }
            }
            if (duoPresentation != null) {
                tatamiHistoryEvent.setDuoPresentation(new si.nevensrok.jtekma.server.web.common.competition.DuoPresentation(duoPresentation));
                if (duoPresentation.getCategory() instanceof Duo2023Category) {
                    tatamiHistoryEvent.getDuoPresentation().setName(this.getTools().getMatchTool().generateDuoPresentationName(locale, duoPresentation));
                    tatamiHistoryEvent.getDuoPresentation().setShortName(this.getTools().getMatchTool().generateDuoPresentationShortName(locale, duoPresentation));
                }
                if (tatamiHistory.getEventType() == TatamiHistory.EventType.PUSHMATCH) {
                    Set points = this.getManagersList().getDuoPresentationManager().getDuoPresentationPointsForDuoPresentation(duoPresentation);
                    tatamiHistoryEvent.getDuoPresentation().setPoints(Float.valueOf(competitionRules.sumDuoPresentationPoints(points)));
                }
            }
            tatamiHistoryEvents.add(tatamiHistoryEvent);
        }
        return tatamiHistoryEvents;
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/add-duo-presentation-to-tatami/{tatamiId}/{duoPresentationId}"})
    @ResponseBody
    public CommonResponse addDuoPresentationToTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="duoPresentationId") Long duoPresentationId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        DuoPresentation duoPresentation = this.getManagersList().getDuoPresentationManager().getById(duoPresentationId);
        if (duoPresentation != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForDuoPresentation(duoPresentation);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean added = this.getManagersList().getTatamiFightsManager().addDuoPresentationToTatami(duoPresentation, tatami);
            return new CommonResponse(added);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/remove-duo-presentation-from-tatami/{tatamiId}/{duoPresentationId}"})
    @ResponseBody
    public CommonResponse removeDuoPresentationFromTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="duoPresentationId") Long duoPresentationId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        DuoPresentation duoPresentation = this.getManagersList().getDuoPresentationManager().getById(duoPresentationId);
        if (duoPresentation != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForDuoPresentation(duoPresentation);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean removed = this.getManagersList().getTatamiFightsManager().removeDuoPresentationFromTatami(duoPresentation, tatami);
            return new CommonResponse(removed);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/moveup-duo-presentation-tatami/{tatamiId}/{duoPresentationId}"})
    @ResponseBody
    public CommonResponse moveUpDuoPresentationOnTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="duoPresentationId") Long duoPresentationId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        DuoPresentation duoPresentation = this.getManagersList().getDuoPresentationManager().getById(duoPresentationId);
        if (duoPresentation != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForDuoPresentation(duoPresentation);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean moved = this.getManagersList().getTatamiFightsManager().moveDuoPresentationOnTatamiUp(duoPresentation, tatami);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/movedown-duo-presentation-tatami/{tatamiId}/{duoPresentationId}"})
    @ResponseBody
    public CommonResponse moveDownDuoPresentationOnTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="duoPresentationId") Long duoPresentationId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        DuoPresentation duoPresentation = this.getManagersList().getDuoPresentationManager().getById(duoPresentationId);
        if (duoPresentation != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForDuoPresentation(duoPresentation);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean moved = this.getManagersList().getTatamiFightsManager().moveDuoPresentationOnTatamiDown(duoPresentation, tatami);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }

    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/move-duo-presentation-tatami/{tatamiId}/{duoPresentationId}/{moveToSpot}"})
    @ResponseBody
    public CommonResponse moveDuoPresentationCustomOnTatami(HttpServletResponse response, @PathVariable(value="tatamiId") Long tatamiId, @PathVariable(value="duoPresentationId") Long duoPresentationId, @PathVariable(value="moveToSpot") Integer moveToSpot) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Tatami tatami = new Tatami();
        tatami.setTatamiId(tatamiId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForTatami(tatami).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for tatami");
        }
        DuoPresentation duoPresentation = this.getManagersList().getDuoPresentationManager().getById(duoPresentationId);
        if (duoPresentation != null) {
            Category category = this.getManagersList().getCategoryManager().getCategoryForDuoPresentation(duoPresentation);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            boolean moved = this.getManagersList().getTatamiFightsManager().moveDuoPresentationOnTatamiToSpot(duoPresentation, tatami, moveToSpot);
            return new CommonResponse(moved);
        }
        return new CommonResponse(false);
    }
}

