/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.objects.ObjectCompare;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryMatchCount;
import si.nevensrok.jtekma.common.category.CategoryNameComparator;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.club.ClubCompetitorPoints;
import si.nevensrok.jtekma.common.club.ClubPlacing;
import si.nevensrok.jtekma.common.competition.AgeCategoryKey;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competition.CompetitionDuration;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.server.web.common.AgeCategoryStatus;
import si.nevensrok.jtekma.server.web.common.CategoryStatus;
import si.nevensrok.jtekma.server.web.controllers.CoreController;

@Controller
@RequestMapping(value={"/"})
public class IndexController
extends CoreController
implements InitializingBean {
    private LogoutHandler logoutHandler;
    private List<String> messages = new LinkedList<String>();

    public void setLogoutHandler(LogoutHandler logoutHandler) {
        this.logoutHandler = logoutHandler;
    }

    public void afterPropertiesSet() throws Exception {
        Properties properties = new Properties();
        properties.load(this.getApplicationContext().getResource("classpath:/si/nevensrok/jtekma/server/web/translations/messages.properties").getInputStream());
        for (Object key : properties.keySet()) {
            this.messages.add(key.toString());
        }
    }

    @RequestMapping
    public String index(HttpServletRequest request, Model model) {
        if (this.getUserData().getLoginedJudge() != null) {
            return "redirect:/app/judge";
        }
        if (this.getUserData().getCompetition() == null) {
            return "redirect:/select-competition";
        }
        Competition competition = this.getManagersList().getCompetitionManager().getById(this.getUserData().getCompetition().getCompetitionId());
        if (competition == null) {
            return "redirect:/select-competition";
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("Competition rules not found");
        }
        Category categoryExample = new Category();
        categoryExample.setStatus(Category.Status.ACTIVE);
        SimpleDataFilter categoryDataFilter = new SimpleDataFilter();
        categoryDataFilter.setFilter((Filter)new ExampleFilter((Object)categoryExample));
        categoryDataFilter.setSort(new Sort());
        categoryDataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        List categories = this.getManagersList().getCategoryManager().find(competition, (DataFilter)categoryDataFilter).getData();
        Collections.sort(categories, new CategoryNameComparator());
        this.addCompetitionStatus(competition, categories, model);
        this.addClubPlacings(competition, categories, competitionRules, model);
        return "index";
    }

    private void addCompetitionStatus(Competition competition, List<Category> categories, Model model) {
        CompetitionDuration competitionDuration = this.getManagersList().getCompetitionDurationCalculationManager().calculateCompetitionDuration(competition);
        ArrayList ageCategories = new ArrayList(competitionDuration.getMatchCountForAgeCategories().keySet());
        Collections.sort(ageCategories, new Comparator<AgeCategoryKey>(){

            @Override
            public int compare(AgeCategoryKey o1, AgeCategoryKey o2) {
                return new ObjectCompare().addValue((Comparable)((Object)o1.getAgeCategoryOption().getName()), (Object)o2.getAgeCategoryOption().getName()).addValue(o1.getCategoryType().ordinal(), o2.getCategoryType().ordinal()).calculateCompare();
            }
        });
        LinkedList<AgeCategoryStatus> ageCategoryStatuses = new LinkedList<AgeCategoryStatus>();
        for (Object ageCategoryKey : ageCategories) {
            AgeCategoryStatus ageCategoryStatus = new AgeCategoryStatus();
            ageCategoryStatuses.add(ageCategoryStatus);
            CategoryMatchCount categoryMatchCount = (CategoryMatchCount)competitionDuration.getMatchCountForAgeCategories().get(ageCategoryKey);
            ageCategoryStatus.setAgeCategoryOption(ageCategoryKey.getAgeCategoryOption());
            ageCategoryStatus.setCategoryType(ageCategoryKey.getCategoryType());
            ageCategoryStatus.setFinished(categoryMatchCount.getFinishedMatches() + categoryMatchCount.getFinishedPresentations());
            ageCategoryStatus.setNotFinished(categoryMatchCount.getNeededMatches() + categoryMatchCount.getNeededPresentations());
            ageCategoryStatus.setTotal(ageCategoryStatus.getFinished() + ageCategoryStatus.getNotFinished());
            ageCategoryStatus.setFinishProcent(Math.round((float)ageCategoryStatus.getFinished().intValue() / (float)ageCategoryStatus.getTotal().intValue() * 100.0f));
            ageCategoryStatus.setTimeRequired((Integer)competitionDuration.getTimeRequiredForAgeCategories().get(ageCategoryKey));
            ageCategoryStatus.setPredictedTimeRequired((Integer)competitionDuration.getPredictedTimeRequiredForAgeCategories().get(ageCategoryKey));
            int avgMatchTime = 0;
            if (categoryMatchCount.getFinishedMatches() > 0 || categoryMatchCount.getFinishedPresentations() > 0) {
                int totalTime = categoryMatchCount.getAverageMatchTime() * categoryMatchCount.getFinishedMatches() + categoryMatchCount.getAveragePresentationTime() * categoryMatchCount.getFinishedPresentations();
                int totalMatchNum = 0;
                if (categoryMatchCount.getAverageMatchTime() > 0 && categoryMatchCount.getFinishedMatches() > 0) {
                    totalMatchNum += categoryMatchCount.getFinishedMatches().intValue();
                }
                if (categoryMatchCount.getAveragePresentationTime() > 0 && categoryMatchCount.getFinishedPresentations() > 0) {
                    totalMatchNum += categoryMatchCount.getFinishedPresentations().intValue();
                }
                if (totalMatchNum > 0) {
                    avgMatchTime = totalTime / totalMatchNum;
                }
            }
            ageCategoryStatus.setAverageMatchTime(avgMatchTime);
        }
        LinkedList<CategoryStatus> categoryStatuses = new LinkedList<CategoryStatus>();
        for (Category category : categories) {
            CategoryStatus categoryStatus = new CategoryStatus();
            categoryStatuses.add(categoryStatus);
            CategoryMatchCount categoryMatchCount = (CategoryMatchCount)competitionDuration.getMatchCountForCategories().get(category);
            categoryStatus.setCategory(category);
            categoryStatus.setFinished(categoryMatchCount.getFinishedMatches() + categoryMatchCount.getFinishedPresentations());
            categoryStatus.setNotFinished(categoryMatchCount.getNeededMatches() + categoryMatchCount.getNeededPresentations());
            categoryStatus.setTotal(categoryStatus.getFinished() + categoryStatus.getNotFinished());
            categoryStatus.setFinishProcent(Math.round((float)categoryStatus.getFinished().intValue() / (float)categoryStatus.getTotal().intValue() * 100.0f));
            categoryStatus.setTimeRequired((Integer)competitionDuration.getTimeRequiredForCategories().get(category));
            categoryStatus.setPredictedTimeRequired((Integer)competitionDuration.getPredictedTimeRequiredForCategories().get(category));
            int avgMatchTime = 0;
            if (categoryMatchCount.getFinishedMatches() > 0 || categoryMatchCount.getFinishedPresentations() > 0) {
                int totalTime = categoryMatchCount.getAverageMatchTime() * categoryMatchCount.getFinishedMatches() + categoryMatchCount.getAveragePresentationTime() * categoryMatchCount.getFinishedPresentations();
                int totalMatchNum = 0;
                if (categoryMatchCount.getAverageMatchTime() > 0 && categoryMatchCount.getFinishedMatches() > 0) {
                    totalMatchNum += categoryMatchCount.getFinishedMatches().intValue();
                }
                if (categoryMatchCount.getAveragePresentationTime() > 0 && categoryMatchCount.getFinishedPresentations() > 0) {
                    totalMatchNum += categoryMatchCount.getFinishedPresentations().intValue();
                }
                if (totalMatchNum > 0) {
                    avgMatchTime = totalTime / totalMatchNum;
                }
            }
            categoryStatus.setAverageMatchTime(avgMatchTime);
        }
        model.addAttribute("totalTimeRequired", (Object)competitionDuration.getTotalTimeRequired());
        model.addAttribute("totalTimeRequiredAdj", (Object)competitionDuration.getPredictedTotalTimeRequired());
        int timeRequiredPerTatami = competitionDuration.getTotalTimeRequired();
        int timeRequiredAdjPerTatami = competitionDuration.getPredictedTotalTimeRequired();
        Integer tatamiCount = this.getManagersList().getTatamiManager().getTatamiCount(competition);
        if (tatamiCount != null && tatamiCount > 0) {
            timeRequiredPerTatami /= tatamiCount.intValue();
            timeRequiredAdjPerTatami /= tatamiCount.intValue();
        }
        model.addAttribute("ageCategoryStatuses", ageCategoryStatuses);
        model.addAttribute("categoryStatuses", categoryStatuses);
        int matchFinished = competitionDuration.getTotalMatchCount().getFinishedMatches() + competitionDuration.getTotalMatchCount().getFinishedPresentations();
        int matchNotFinished = competitionDuration.getTotalMatchCount().getNeededMatches() + competitionDuration.getTotalMatchCount().getNeededPresentations();
        int matchTotal = competitionDuration.getTotalMatchCount().getTotalMatches() + competitionDuration.getTotalMatchCount().getTotalPresentations();
        model.addAttribute("matchCountFinished", (Object)matchFinished);
        model.addAttribute("matchCountNotFinished", (Object)matchNotFinished);
        model.addAttribute("matchCountTotal", (Object)matchTotal);
        model.addAttribute("matchFinishProcent", (Object)Math.round((float)matchFinished / (float)matchTotal * 100.0f));
        model.addAttribute("timeRequired", (Object)timeRequiredPerTatami);
        model.addAttribute("timeRequiredAdj", (Object)timeRequiredAdjPerTatami);
        Calendar competitionFinishedAt = Calendar.getInstance();
        competitionFinishedAt.add(13, timeRequiredPerTatami);
        model.addAttribute("competitionFinishedAt", (Object)competitionFinishedAt.getTime());
        Calendar competitionFinishedAtAdj = Calendar.getInstance();
        competitionFinishedAtAdj.add(13, timeRequiredAdjPerTatami);
        model.addAttribute("competitionFinishedAtAdj", (Object)competitionFinishedAtAdj.getTime());
    }

    private void addClubPlacings(Competition competition, List<Category> categories, CompetitionRules competitionRules, Model model) {
        Map competitionSettings = this.getManagersList().getCompetitionManager().getCompetitionSettings(competition);
        HashMap<Integer, Integer> pointsForPlace = new HashMap<Integer, Integer>();
        for (int i = 1; i <= 7; ++i) {
            if (competitionSettings.get("clubPlacing.points." + i) == null) continue;
            pointsForPlace.put(i, ((Long)competitionSettings.get("clubPlacing.points." + i)).intValue());
        }
        boolean includeOneCompetitor = (Boolean)ObjectUtil.ifNull((Object)((Boolean)competitionSettings.get("clubPlacing.includeOneCompetitor")), (Object)Boolean.TRUE);
        boolean includeSameClub = (Boolean)ObjectUtil.ifNull((Object)((Boolean)competitionSettings.get("clubPlacing.includeSameClub")), (Object)Boolean.TRUE);
        boolean includeAllCompetitors = (Boolean)ObjectUtil.ifNull((Object)((Boolean)competitionSettings.get("clubPlacing.includeAllCompetitors")), (Object)Boolean.FALSE);
        Club clubExample = new Club();
        clubExample.setStatus(Club.Status.ACTIVE);
        clubExample.setCountForClubPlacings(Boolean.TRUE);
        SimpleDataFilter clubDataFilter = new SimpleDataFilter();
        clubDataFilter.setFilter((Filter)new ExampleFilter((Object)clubExample));
        clubDataFilter.setItemLimit(Integer.valueOf(1000));
        clubDataFilter.setSort(new Sort());
        clubDataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        ArrayList<ClubPlacing> clubPlacings = new ArrayList<ClubPlacing>();
        for (Club club : this.getManagersList().getClubManager().find(competition, (DataFilter)clubDataFilter).getData()) {
            ClubPlacing clubPlacing = new ClubPlacing();
            clubPlacing.setClub(club);
            clubPlacing.setPoints(Integer.valueOf(0));
            clubPlacings.add(clubPlacing);
        }
        for (Category category : categories) {
            ClubCompetitorPoints clubCompetitorPoints;
            Map competitorPlacings;
            if (category.getCountForClubPlacings().booleanValue() && category instanceof TreeCategory) {
                competitorPlacings = this.getManagersList().getCategoryManager().getPlacings(category);
                if (competitorPlacings == null) continue;
                for (ClubPlacing clubPlacing : clubPlacings) {
                    clubCompetitorPoints = competitionRules.getPointsForClub(clubPlacing.getClub(), competitorPlacings, pointsForPlace, includeOneCompetitor, includeSameClub, includeAllCompetitors);
                    if (clubCompetitorPoints.getTopPlace() == 1) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_1() + 1));
                    } else if (clubCompetitorPoints.getTopPlace() == 2) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_2() + 1));
                    } else if (clubCompetitorPoints.getTopPlace() == 3) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_3() + 1));
                    } else if (clubCompetitorPoints.getTopPlace() == 4) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_4() + 1));
                    } else if (clubCompetitorPoints.getTopPlace() == 5) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_5() + 1));
                    }
                    clubPlacing.setPoints(Integer.valueOf(clubPlacing.getPoints() + clubCompetitorPoints.getPoints()));
                }
                continue;
            }
            if (!category.getCountForClubPlacings().booleanValue() || !(category instanceof Duo2023Category) || (competitorPlacings = this.getManagersList().getCategoryManager().getPlacings(category, Rank.WORLD_LEVEL)) == null) continue;
            for (ClubPlacing clubPlacing : clubPlacings) {
                clubCompetitorPoints = competitionRules.getPointsForClub(clubPlacing.getClub(), competitorPlacings, pointsForPlace, includeOneCompetitor, includeSameClub, includeAllCompetitors);
                if (clubCompetitorPoints.getTopPlace() == 1) {
                    clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_1() + 1));
                } else if (clubCompetitorPoints.getTopPlace() == 2) {
                    clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_2() + 1));
                } else if (clubCompetitorPoints.getTopPlace() == 3) {
                    clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_3() + 1));
                } else if (clubCompetitorPoints.getTopPlace() == 4) {
                    clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_4() + 1));
                } else if (clubCompetitorPoints.getTopPlace() == 5) {
                    clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_5() + 1));
                }
                clubPlacing.setPoints(Integer.valueOf(clubPlacing.getPoints() + clubCompetitorPoints.getPoints()));
            }
        }
        Collections.sort(clubPlacings, new Comparator<ClubPlacing>(){

            @Override
            public int compare(ClubPlacing o1, ClubPlacing o2) {
                return new ObjectCompare().addValue((Comparable)o2.getPoints(), (Object)o1.getPoints()).addValue((Comparable)o2.getPlace_1(), (Object)o1.getPlace_1()).addValue((Comparable)o2.getPlace_2(), (Object)o1.getPlace_2()).addValue((Comparable)o2.getPlace_3(), (Object)o1.getPlace_3()).addValue((Comparable)o2.getPlace_4(), (Object)o1.getPlace_4()).addValue((Comparable)o2.getPlace_5(), (Object)o1.getPlace_5()).calculateCompare();
            }
        });
        int placeNum = 1;
        for (ClubPlacing clubPlacing : clubPlacings) {
            clubPlacing.setPlace(Integer.valueOf(placeNum++));
        }
        model.addAttribute("clubPlacings", clubPlacings);
    }

    @RequestMapping(value={"/login"})
    public String login(Model model) {
        model.addAttribute("loginFailed", (Object)false);
        return "login";
    }

    @RequestMapping(value={"/login"}, params={"success=false"})
    public String login_failed(Model model) {
        model.addAttribute("loginFailed", (Object)true);
        return "login";
    }

    @RequestMapping(value={"/logout"})
    public String logout(HttpServletRequest request, HttpServletResponse response, Model model) {
        this.logoutHandler.logout(request, response, SecurityContextHolder.getContext().getAuthentication());
        SecurityContextHolder.clearContext();
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        return "redirect:/login";
    }

    @RequestMapping(value={"/config.js"})
    public String getJavaScriptConfig(HttpServletResponse response, Model model) {
        response.setContentType("text/javascript");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        return "jsconfig";
    }

    @RequestMapping(value={"/messages.js"})
    public String getMessages(HttpServletResponse response, Model model) {
        response.setContentType("text/javascript");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        model.addAttribute("messages", this.messages);
        return "jsmessages";
    }
}

