/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.servlet.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.web.filter.GenericFilterBean;
import si.nevensrok.common.web.servlet.security.AdditionalSecurityProvider;
import si.nevensrok.common.web.util.ServletUtil;

public class AdditionalSecurityFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdditionalSecurityFilter.class);
    private static final String ATTRIBUTEPREFIX = "ASF_";
    private AdditionalSecurityProvider additionalSecurityProvider;
    private boolean afterNormalAuthentication = true;
    private String loginPage;
    private String successPage = "/";
    private String failurePage;
    private String codeParameter = "securityCode";
    private String[] allowPages;
    private String[] protectPages;
    private RememberMeServices rememberMeServices;

    public AdditionalSecurityProvider getAdditionalSecurityProvider() {
        return this.additionalSecurityProvider;
    }

    public void setAdditionalSecurityProvider(AdditionalSecurityProvider additionalSecurityProvider) {
        this.additionalSecurityProvider = additionalSecurityProvider;
    }

    public boolean isAfterNormalAuthentication() {
        return this.afterNormalAuthentication;
    }

    public void setAfterNormalAuthentication(boolean afterNormalAuthentication) {
        this.afterNormalAuthentication = afterNormalAuthentication;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public String getSuccessPage() {
        return this.successPage;
    }

    public void setSuccessPage(String successPage) {
        this.successPage = successPage;
    }

    public String getFailurePage() {
        return this.failurePage;
    }

    public void setFailurePage(String failurePage) {
        this.failurePage = failurePage;
    }

    public String getCodeParameter() {
        return this.codeParameter;
    }

    public void setCodeParameter(String codeParameter) {
        this.codeParameter = codeParameter;
    }

    public String[] getAllowPages() {
        return this.allowPages;
    }

    public void setAllowPages(String[] allowPages) {
        this.allowPages = allowPages;
    }

    public String[] getProtectPages() {
        return this.protectPages;
    }

    public void setProtectPages(String[] protectPages) {
        this.protectPages = protectPages;
    }

    public RememberMeServices getRememberMeServices() {
        return this.rememberMeServices;
    }

    public void setRememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    public void afterPropertiesSet() throws ServletException {
        if (this.additionalSecurityProvider == null) {
            throw new IllegalArgumentException("Property 'additionalSecurityProvider' is required");
        }
        if (this.loginPage == null) {
            throw new IllegalArgumentException("Property 'loginPage' is required");
        }
        super.afterPropertiesSet();
    }

    public Authentication getAuthentication(ServletRequest request, ServletResponse response, FilterChain chain) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof AnonymousAuthenticationToken) {
            return null;
        }
        return authentication;
    }

    public Object getSessionAttribute(HttpServletRequest request, String attributeName) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return session.getAttribute(attributeName);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String[] allowedPages;
        String filterName = this.getFilterName();
        LOGGER.trace("Do filter: {}", (Object)filterName);
        Authentication authentication = this.getAuthentication(request, response, chain);
        if (authentication == null && this.isAfterNormalAuthentication()) {
            LOGGER.trace("Not checking - normal authentication required");
            chain.doFilter(request, response);
            return;
        }
        if (!authentication.isAuthenticated() && this.isAfterNormalAuthentication()) {
            LOGGER.trace("Not checking - normal authentication required");
            chain.doFilter(request, response);
            return;
        }
        String filterSessionAttributeName = ATTRIBUTEPREFIX + filterName;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        boolean isAuthenticated = false;
        if (this.getSessionAttribute(httpServletRequest, filterSessionAttributeName) != null) {
            isAuthenticated = true;
        }
        LOGGER.trace("Is authenticated: {}", (Object)isAuthenticated);
        String requestURI = httpServletRequest.getRequestURI();
        String contextPath = httpServletRequest.getContextPath();
        if (!contextPath.isEmpty() && requestURI.startsWith(contextPath)) {
            requestURI = requestURI.substring(contextPath.length());
        }
        LOGGER.trace("RequestURI: {}", (Object)requestURI);
        if (this.getLoginPage().equals(requestURI)) {
            if (isAuthenticated) {
                LOGGER.trace("Already authenticated - redirecting to success page");
                httpServletResponse.sendRedirect(contextPath + this.successPage);
                return;
            }
            Object principal = authentication.getPrincipal();
            if (!this.getAdditionalSecurityProvider().isSecurityCheckNeeded(principal)) {
                LOGGER.trace("Security check not needed - redirecting to success page");
                httpServletRequest.getSession().setAttribute(filterSessionAttributeName, (Object)Boolean.TRUE);
                httpServletResponse.sendRedirect(contextPath + this.successPage);
                return;
            }
            if (httpServletRequest.getMethod().equalsIgnoreCase("POST")) {
                LOGGER.trace("Checking security code");
                String securityCode = httpServletRequest.getParameter(this.codeParameter);
                if (this.getAdditionalSecurityProvider().checkSecurityCode(principal, securityCode)) {
                    LOGGER.trace("Correct security code - redirecting to success page");
                    httpServletRequest.getSession().setAttribute(filterSessionAttributeName, (Object)Boolean.TRUE);
                    this.postAuthenticationCallback(httpServletRequest);
                    if (this.getRememberMeServices() != null) {
                        LOGGER.trace("Notifying remember me service");
                        this.getRememberMeServices().loginSuccess(httpServletRequest, httpServletResponse, authentication);
                    }
                    httpServletResponse.sendRedirect(contextPath + this.successPage);
                    return;
                }
                LOGGER.trace("Invalid security code - redirecting to failure page");
                this.getAdditionalSecurityProvider().invalidSecurityCodeEntered(principal);
                if (this.getFailurePage() != null) {
                    httpServletResponse.sendRedirect(contextPath + this.failurePage);
                } else {
                    httpServletResponse.sendRedirect(contextPath + this.getLoginPage());
                }
                return;
            }
            if (httpServletRequest.getMethod().equalsIgnoreCase("GET")) {
                LOGGER.trace("Send security code to user: [{}]", principal);
                this.getAdditionalSecurityProvider().sendSecurityCodeToUser(principal);
                chain.doFilter(request, response);
                return;
            }
        }
        if (!((allowedPages = this.getAllowPages()) != null && ServletUtil.matchesMapping(requestURI, allowedPages) || isAuthenticated)) {
            Object principal = authentication.getPrincipal();
            if (this.getProtectPages() == null || ServletUtil.matchesMapping(requestURI, this.getProtectPages())) {
                if (this.getAdditionalSecurityProvider().isSecurityCheckNeeded(principal)) {
                    LOGGER.trace("Redirecting to login page");
                    httpServletResponse.sendRedirect(contextPath + this.getLoginPage());
                    return;
                }
                if (authentication != null) {
                    httpServletRequest.getSession().setAttribute(filterSessionAttributeName, (Object)Boolean.TRUE);
                }
            }
        }
        chain.doFilter(request, response);
    }

    protected void postAuthenticationCallback(HttpServletRequest request) {
    }

    public void addUserAuthenticatedFlag(HttpServletRequest request) {
        HttpSession httpSession = request.getSession();
        httpSession.setAttribute(ATTRIBUTEPREFIX + this.getFilterName(), (Object)Boolean.TRUE);
        this.postAuthenticationCallback(request);
    }

    public boolean isUserAuthenticated(HttpServletRequest request) {
        HttpSession httpSession = request.getSession();
        return httpSession.getAttribute(ATTRIBUTEPREFIX + this.getFilterName()) != null;
    }
}

