/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.tools;

import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.SelectType;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.rules.TreeAdvancmentItem;
import si.nevensrok.jtekma.common.rules.TreeType;

public final class MatchNumberTool {
    private MatchNumberTool() {
    }

    public static int getTransformedMatchNumber(TreeCategory.TreeType treeType, boolean double3rdPlace, int matchNumber) {
        int transformedMatchNumber = matchNumber;
        if (treeType == TreeCategory.TreeType.TABLE2 || treeType == TreeCategory.TreeType.TABLE3 || treeType == TreeCategory.TreeType.TABLE4 || treeType == TreeCategory.TreeType.TABLE5) {
            return transformedMatchNumber;
        }
        if (treeType == TreeCategory.TreeType.TREE6) {
            if (matchNumber == 10 && double3rdPlace) {
                return 9;
            }
            return transformedMatchNumber;
        }
        if (treeType == TreeCategory.TreeType.TREE4) {
            if (matchNumber >= 117 && matchNumber <= 118) {
                transformedMatchNumber = matchNumber - 117 + 1;
            } else if (matchNumber == 123) {
                transformedMatchNumber = matchNumber - 123 + 3;
            } else if (matchNumber == 124) {
                transformedMatchNumber = matchNumber - 124 + 4;
            }
        } else if (treeType == TreeCategory.TreeType.TREE8) {
            if (matchNumber >= 105 && matchNumber <= 108) {
                transformedMatchNumber = matchNumber - 105 + 1;
            } else if (matchNumber >= 117 && matchNumber <= 122) {
                transformedMatchNumber = matchNumber - 117 + 5;
            } else if (matchNumber == 123) {
                transformedMatchNumber = matchNumber - 123 + 11;
            } else if (matchNumber == 124) {
                transformedMatchNumber = matchNumber - 124 + 11;
                if (!double3rdPlace) {
                    transformedMatchNumber = matchNumber - 124 + 12;
                }
            }
        } else if (treeType == TreeCategory.TreeType.TREE16) {
            if (matchNumber >= 81 && matchNumber <= 88) {
                transformedMatchNumber = matchNumber - 81 + 1;
            } else if (matchNumber >= 105 && matchNumber <= 122) {
                transformedMatchNumber = matchNumber - 105 + 9;
            } else if (matchNumber == 123) {
                transformedMatchNumber = matchNumber - 123 + 27;
            } else if (matchNumber == 124) {
                transformedMatchNumber = matchNumber - 124 + 27;
                if (!double3rdPlace) {
                    transformedMatchNumber = matchNumber - 124 + 28;
                }
            }
        } else if (treeType == TreeCategory.TreeType.TREE32) {
            if (matchNumber >= 33 && matchNumber <= 48) {
                transformedMatchNumber = matchNumber - 33 + 1;
            } else if (matchNumber >= 81 && matchNumber <= 122) {
                transformedMatchNumber = matchNumber - 81 + 17;
            } else if (matchNumber == 123) {
                transformedMatchNumber = matchNumber - 123 + 59;
            } else if (matchNumber == 124) {
                transformedMatchNumber = matchNumber - 124 + 59;
                if (!double3rdPlace) {
                    transformedMatchNumber = matchNumber - 124 + 60;
                }
            }
        } else if (treeType == TreeCategory.TreeType.TREE64 && matchNumber == 124) {
            transformedMatchNumber = matchNumber - 124 + 123;
            if (!double3rdPlace) {
                transformedMatchNumber = matchNumber - 124 + 124;
            }
        }
        return transformedMatchNumber;
    }

    public static int getLowestDrawNumber(int matchNumber, CompetitorType competitorType, TreeAdvancment treeAdvancment) {
        TreeAdvancmentItem treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(matchNumber, competitorType, TreeType.TREE);
        if (treeAdvancmentItem.getSelectType() == SelectType.DRAW) {
            return treeAdvancmentItem.getFromMatch();
        }
        int num1 = MatchNumberTool.getLowestDrawNumber(treeAdvancmentItem.getFromMatch(), CompetitorType.COMPETITOR1, treeAdvancment);
        int num2 = MatchNumberTool.getLowestDrawNumber(treeAdvancmentItem.getFromMatch(), CompetitorType.COMPETITOR2, treeAdvancment);
        return Math.min(num1, num2);
    }

    public static int getRepasagueLooserMatchNum(int matchNumber, CompetitorType competitorType, TreeAdvancment treeAdvancment) {
        TreeAdvancmentItem treeAdvancmentItem = treeAdvancment.getTreeAdvancmentItem(matchNumber, competitorType, TreeType.TREE);
        if (treeAdvancmentItem.getSelectType() == SelectType.DRAW) {
            return 0;
        }
        if (treeAdvancmentItem.getSelectType() == SelectType.LOSER) {
            return treeAdvancmentItem.getFromMatch();
        }
        int num1 = MatchNumberTool.getRepasagueLooserMatchNum(treeAdvancmentItem.getFromMatch(), CompetitorType.COMPETITOR1, treeAdvancment);
        int num2 = MatchNumberTool.getRepasagueLooserMatchNum(treeAdvancmentItem.getFromMatch(), CompetitorType.COMPETITOR2, treeAdvancment);
        return Math.max(num1, num2);
    }
}

