/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.reports.impl;

import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import si.nevensrok.common.comparators.IntegerComparator;
import si.nevensrok.common.documents.common.Alignment;
import si.nevensrok.common.documents.common.BorderMargin;
import si.nevensrok.common.documents.common.Content;
import si.nevensrok.common.documents.common.Document;
import si.nevensrok.common.documents.common.Heading;
import si.nevensrok.common.documents.common.Image;
import si.nevensrok.common.documents.common.PageBreak;
import si.nevensrok.common.documents.common.PageDirection;
import si.nevensrok.common.documents.common.PageSize;
import si.nevensrok.common.documents.common.Paragraph;
import si.nevensrok.common.documents.common.Table;
import si.nevensrok.common.documents.common.TableCell;
import si.nevensrok.common.documents.common.TableRow;
import si.nevensrok.common.documents.common.VerticalAlignment;
import si.nevensrok.common.messagesource.MessageLoader;
import si.nevensrok.common.utils.CollectionUtil;
import si.nevensrok.common.utils.MapUtil;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competitors.CompetitorRanking;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.server.reports.impl.CategoryData;
import si.nevensrok.jtekma.server.reports.impl.CategoryPlacingData;
import si.nevensrok.jtekma.server.reports.impl.CompetitorPlacingData;
import si.nevensrok.jtekma.server.reports.impl.MatchData;
import si.nevensrok.jtekma.server.reports.impl.MatchTreeImageGenerator;
import si.nevensrok.jtekma.server.reports.impl.MedalsCount;
import si.nevensrok.jtekma.server.reports.impl.PlacingData;

public class DocumentGenerator {
    private static final DecimalFormat COMPETITOR_RANKING_POINTS_FORMAT;
    private MessageLoader messageLoader;
    private MatchTreeImageGenerator matchTreeImageGenerator;

    public void setMessageLoader(MessageLoader messageLoader) {
        this.messageLoader = messageLoader;
    }

    public void setMatchTreeImageGenerator(MatchTreeImageGenerator matchTreeImageGenerator) {
        this.matchTreeImageGenerator = matchTreeImageGenerator;
    }

    public Document generateClubPlacingsDocument(Locale locale, List<PlacingData> placings) {
        Document document = new Document();
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "clubPlacing.title"), Heading.HeadingType.H1));
        for (PlacingData placingData : placings) {
            StringBuilder line = new StringBuilder();
            line.append(placingData.getPlacing());
            line.append(". ");
            line.append(placingData.getName());
            line.append(", ");
            line.append(placingData.getPoints());
            line.append(" ");
            line.append(this.messageLoader.getMessage(locale, "clubPlacing.points"));
            Paragraph paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        return document;
    }

    public Document generateCompetitorPlacingsDocument(Locale locale, List<CategoryPlacingData> categoryPlacingDataList, boolean oneCategoryPerPage) {
        Document document = new Document();
        boolean firstCategory = true;
        for (CategoryPlacingData categoryPlacingData : categoryPlacingDataList) {
            if (firstCategory) {
                firstCategory = false;
            } else if (oneCategoryPerPage) {
                document.addContent((Content)new PageBreak());
            }
            document.addContent((Content)new Heading(categoryPlacingData.getCategoryName(), Heading.HeadingType.H1));
            if (CollectionUtil.isNotEmpty(categoryPlacingData.getPlacingDatas())) {
                for (PlacingData placingData : categoryPlacingData.getPlacingDatas()) {
                    StringBuilder line = new StringBuilder();
                    line.append(placingData.getPlacing());
                    line.append(". ");
                    line.append(placingData.getName());
                    Paragraph paragraph = new Paragraph(line.toString());
                    paragraph.setMargin(new BorderMargin());
                    document.addContent((Content)paragraph);
                }
                continue;
            }
            if (!MapUtil.isNotEmpty(categoryPlacingData.getPlacingsForRanks())) continue;
            for (Map.Entry entry : categoryPlacingData.getPlacingsForRanks().entrySet()) {
                Rank rank = (Rank)entry.getKey();
                if (rank == Rank.WORLD_LEVEL) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.worldLevel"), Heading.HeadingType.H3));
                } else if (rank == Rank.ADVANCED) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.advancedLevel"), Heading.HeadingType.H3));
                } else if (rank == Rank.NOVICE) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.noviceLevel"), Heading.HeadingType.H3));
                }
                for (PlacingData placingData : (List)entry.getValue()) {
                    StringBuilder line = new StringBuilder();
                    line.append(placingData.getPlacing());
                    line.append(". ");
                    line.append(placingData.getName());
                    Paragraph paragraph = new Paragraph(line.toString());
                    paragraph.setMargin(new BorderMargin());
                    document.addContent((Content)paragraph);
                }
            }
        }
        return document;
    }

    public Document generateTreeReport(Locale locale, List<CategoryData> categoryDatas, boolean empty) {
        Document document = new Document();
        boolean firstCategory = true;
        for (CategoryData categoryData : categoryDatas) {
            Paragraph pointsParagraph;
            TableCell pointsTableCell;
            Paragraph fiWinsParagraph;
            TableCell fiWinsTableCell;
            Paragraph winsParagraph;
            TableCell winsTableCell;
            Paragraph matchParagraph;
            TableCell matchTableCell;
            Paragraph competitorParagraph;
            TableCell competitorTableCell;
            TableRow tableRow;
            Paragraph pointsParagraph2;
            TableCell pointsTableCell2;
            Paragraph fiWinsParagraph2;
            TableCell fiWinsTableCell2;
            Paragraph winsParagraph2;
            Paragraph matchParagraph2;
            TableCell matchTableCell2;
            String[][] tableRow2;
            float fontSize;
            Table table;
            int columns;
            if (firstCategory) {
                firstCategory = false;
            } else if (categoryData.getMatchDatas().size() == 28) {
                document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
            } else {
                document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
            }
            document.addContent((Content)new Heading(categoryData.getCategoryName(), Heading.HeadingType.H1));
            String[][] table1Content = categoryData.getTable1Content();
            String[][] table2Content = categoryData.getTable2Content();
            if (categoryData.getTreeType() == TreeCategory.TreeType.TREE6) {
                document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.table1"), Heading.HeadingType.H3));
            }
            if (table1Content != null && (categoryData.getTreeType() == TreeCategory.TreeType.TABLE2 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE3 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE4 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE5 || categoryData.getTreeType() == TreeCategory.TreeType.TREE6)) {
                columns = table1Content[0].length;
                table = new Table();
                document.addContent((Content)table);
                fontSize = 8.0f;
                tableRow2 = new TableRow();
                table.addTableRow((TableRow)tableRow2);
                TableCell competitorTableCell2 = new TableCell();
                competitorTableCell2.setWidth(7.0f);
                Paragraph competitorParagraph2 = new Paragraph(this.messageLoader.getMessage(locale, "table.competitor"));
                competitorParagraph2.setFontSize(Float.valueOf(fontSize));
                competitorParagraph2.setBold(Boolean.TRUE);
                competitorTableCell2.addContent(competitorParagraph2);
                tableRow2.addTableCell(competitorTableCell2);
                for (int i = 1; i <= columns - 4; ++i) {
                    matchTableCell2 = new TableCell();
                    matchTableCell2.setWidth(3.0f);
                    matchTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                    matchParagraph2 = new Paragraph(this.messageLoader.getMessage(locale, "table.match") + " " + i);
                    matchParagraph2.setFontSize(Float.valueOf(fontSize));
                    matchParagraph2.setBold(Boolean.TRUE);
                    matchParagraph2.setAlignment(Alignment.CENTER);
                    matchTableCell2.addContent(matchParagraph2);
                    tableRow2.addTableCell(matchTableCell2);
                }
                TableCell winsTableCell2 = new TableCell();
                winsTableCell2.setWidth(3.0f);
                winsTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                winsParagraph2 = new Paragraph(this.messageLoader.getMessage(locale, "table.wins"));
                winsParagraph2.setFontSize(Float.valueOf(fontSize));
                winsParagraph2.setBold(Boolean.TRUE);
                winsParagraph2.setAlignment(Alignment.CENTER);
                winsTableCell2.addContent(winsParagraph2);
                tableRow2.addTableCell(winsTableCell2);
                fiWinsTableCell2 = new TableCell();
                fiWinsTableCell2.setWidth(3.0f);
                fiWinsTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                fiWinsParagraph2 = new Paragraph(this.messageLoader.getMessage(locale, "table.fiWins"));
                fiWinsParagraph2.setFontSize(Float.valueOf(fontSize));
                fiWinsParagraph2.setBold(Boolean.TRUE);
                fiWinsParagraph2.setAlignment(Alignment.CENTER);
                fiWinsTableCell2.addContent(fiWinsParagraph2);
                tableRow2.addTableCell(fiWinsTableCell2);
                pointsTableCell2 = new TableCell();
                pointsTableCell2.setWidth(3.0f);
                pointsTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                pointsParagraph2 = new Paragraph(this.messageLoader.getMessage(locale, "table.points"));
                pointsParagraph2.setFontSize(Float.valueOf(fontSize));
                pointsParagraph2.setBold(Boolean.TRUE);
                pointsParagraph2.setAlignment(Alignment.CENTER);
                pointsTableCell2.addContent(pointsParagraph2);
                tableRow2.addTableCell(pointsTableCell2);
                for (String[] row : table1Content) {
                    tableRow = new TableRow();
                    table.addTableRow(tableRow);
                    competitorTableCell = new TableCell();
                    competitorTableCell.setWidth(7.0f);
                    competitorParagraph = new Paragraph(row[0]);
                    competitorParagraph.setFontSize(Float.valueOf(fontSize));
                    competitorTableCell.addContent(competitorParagraph);
                    tableRow.addTableCell(competitorTableCell);
                    for (int i = 1; i <= columns - 4; ++i) {
                        matchTableCell = new TableCell();
                        matchTableCell.setWidth(3.0f);
                        matchParagraph = new Paragraph(row[i]);
                        matchParagraph.setFontSize(Float.valueOf(fontSize));
                        matchParagraph.setAlignment(Alignment.CENTER);
                        matchTableCell.addContent(matchParagraph);
                        tableRow.addTableCell(matchTableCell);
                    }
                    winsTableCell = new TableCell();
                    winsTableCell.setWidth(3.0f);
                    winsParagraph = new Paragraph(row[columns - 3]);
                    winsParagraph.setFontSize(Float.valueOf(fontSize));
                    winsParagraph.setAlignment(Alignment.CENTER);
                    winsTableCell.addContent(winsParagraph);
                    tableRow.addTableCell(winsTableCell);
                    fiWinsTableCell = new TableCell();
                    fiWinsTableCell.setWidth(3.0f);
                    fiWinsParagraph = new Paragraph(row[columns - 2]);
                    fiWinsParagraph.setFontSize(Float.valueOf(fontSize));
                    fiWinsParagraph.setAlignment(Alignment.CENTER);
                    fiWinsTableCell.addContent(fiWinsParagraph);
                    tableRow.addTableCell(fiWinsTableCell);
                    pointsTableCell = new TableCell();
                    pointsTableCell.setWidth(3.0f);
                    pointsParagraph = new Paragraph(row[columns - 1]);
                    pointsParagraph.setFontSize(Float.valueOf(fontSize));
                    pointsParagraph.setAlignment(Alignment.CENTER);
                    pointsTableCell.addContent(pointsParagraph);
                    tableRow.addTableCell(pointsTableCell);
                }
            }
            if (categoryData.getTreeType() == TreeCategory.TreeType.TREE6) {
                document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.table2"), Heading.HeadingType.H3));
            }
            if (table2Content != null && categoryData.getTreeType() == TreeCategory.TreeType.TREE6) {
                columns = table2Content[0].length;
                table = new Table();
                document.addContent((Content)table);
                fontSize = 8.0f;
                tableRow2 = new TableRow();
                table.addTableRow((TableRow)tableRow2);
                TableCell competitorTableCell3 = new TableCell();
                competitorTableCell3.setWidth(7.0f);
                Paragraph competitorParagraph3 = new Paragraph(this.messageLoader.getMessage(locale, "table.competitor"));
                competitorParagraph3.setFontSize(Float.valueOf(fontSize));
                competitorParagraph3.setBold(Boolean.TRUE);
                competitorTableCell3.addContent(competitorParagraph3);
                tableRow2.addTableCell(competitorTableCell3);
                for (int i = 1; i <= columns - 4; ++i) {
                    matchTableCell2 = new TableCell();
                    matchTableCell2.setWidth(3.0f);
                    matchTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                    matchParagraph2 = new Paragraph(this.messageLoader.getMessage(locale, "table.match") + " " + i);
                    matchParagraph2.setFontSize(Float.valueOf(fontSize));
                    matchParagraph2.setBold(Boolean.TRUE);
                    matchParagraph2.setAlignment(Alignment.CENTER);
                    matchTableCell2.addContent(matchParagraph2);
                    tableRow2.addTableCell(matchTableCell2);
                }
                TableCell winsTableCell3 = new TableCell();
                winsTableCell3.setWidth(3.0f);
                winsTableCell3.setVerticalAlignment(VerticalAlignment.MIDDLE);
                winsParagraph2 = new Paragraph(this.messageLoader.getMessage(locale, "table.wins"));
                winsParagraph2.setFontSize(Float.valueOf(fontSize));
                winsParagraph2.setBold(Boolean.TRUE);
                winsParagraph2.setAlignment(Alignment.CENTER);
                winsTableCell3.addContent(winsParagraph2);
                tableRow2.addTableCell(winsTableCell3);
                fiWinsTableCell2 = new TableCell();
                fiWinsTableCell2.setWidth(3.0f);
                fiWinsTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                fiWinsParagraph2 = new Paragraph(this.messageLoader.getMessage(locale, "table.fiWins"));
                fiWinsParagraph2.setFontSize(Float.valueOf(fontSize));
                fiWinsParagraph2.setBold(Boolean.TRUE);
                fiWinsParagraph2.setAlignment(Alignment.CENTER);
                fiWinsTableCell2.addContent(fiWinsParagraph2);
                tableRow2.addTableCell(fiWinsTableCell2);
                pointsTableCell2 = new TableCell();
                pointsTableCell2.setWidth(3.0f);
                pointsTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                pointsParagraph2 = new Paragraph(this.messageLoader.getMessage(locale, "table.points"));
                pointsParagraph2.setFontSize(Float.valueOf(fontSize));
                pointsParagraph2.setBold(Boolean.TRUE);
                pointsParagraph2.setAlignment(Alignment.CENTER);
                pointsTableCell2.addContent(pointsParagraph2);
                tableRow2.addTableCell(pointsTableCell2);
                for (String[] row : table2Content) {
                    tableRow = new TableRow();
                    table.addTableRow(tableRow);
                    competitorTableCell = new TableCell();
                    competitorTableCell.setWidth(7.0f);
                    competitorParagraph = new Paragraph(row[0]);
                    competitorParagraph.setFontSize(Float.valueOf(fontSize));
                    competitorTableCell.addContent(competitorParagraph);
                    tableRow.addTableCell(competitorTableCell);
                    for (int i = 1; i <= columns - 4; ++i) {
                        matchTableCell = new TableCell();
                        matchTableCell.setWidth(3.0f);
                        matchParagraph = new Paragraph(row[i]);
                        matchParagraph.setFontSize(Float.valueOf(fontSize));
                        matchParagraph.setAlignment(Alignment.CENTER);
                        matchTableCell.addContent(matchParagraph);
                        tableRow.addTableCell(matchTableCell);
                    }
                    winsTableCell = new TableCell();
                    winsTableCell.setWidth(3.0f);
                    winsParagraph = new Paragraph(row[columns - 3]);
                    winsParagraph.setFontSize(Float.valueOf(fontSize));
                    winsParagraph.setAlignment(Alignment.CENTER);
                    winsTableCell.addContent(winsParagraph);
                    tableRow.addTableCell(winsTableCell);
                    fiWinsTableCell = new TableCell();
                    fiWinsTableCell.setWidth(3.0f);
                    fiWinsParagraph = new Paragraph(row[columns - 2]);
                    fiWinsParagraph.setFontSize(Float.valueOf(fontSize));
                    fiWinsParagraph.setAlignment(Alignment.CENTER);
                    fiWinsTableCell.addContent(fiWinsParagraph);
                    tableRow.addTableCell(fiWinsTableCell);
                    pointsTableCell = new TableCell();
                    pointsTableCell.setWidth(3.0f);
                    pointsParagraph = new Paragraph(row[columns - 1]);
                    pointsParagraph.setFontSize(Float.valueOf(fontSize));
                    pointsParagraph.setAlignment(Alignment.CENTER);
                    pointsTableCell.addContent(pointsParagraph);
                    tableRow.addTableCell(pointsTableCell);
                }
            }
            boolean duoTableAdded = false;
            String[][] duoTable = categoryData.getDuoTableContent();
            if (duoTable != null) {
                duoTableAdded = true;
                Table table2 = new Table();
                document.addContent((Content)table2);
                float fontSize2 = 8.0f;
                String[][] tableRow3 = new TableRow();
                table2.addTableRow((TableRow)tableRow3);
                TableCell competitorTableCell4 = new TableCell();
                competitorTableCell4.setWidth(7.0f);
                Paragraph competitorParagraph4 = new Paragraph(this.messageLoader.getMessage(locale, "table.competitor"));
                competitorParagraph4.setFontSize(Float.valueOf(fontSize2));
                competitorParagraph4.setBold(Boolean.TRUE);
                competitorTableCell4.addContent(competitorParagraph4);
                tableRow3.addTableCell(competitorTableCell4);
                TableCell round1pointsTableCell = new TableCell();
                round1pointsTableCell.setWidth(3.0f);
                round1pointsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph round1pointsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.round1points"));
                round1pointsParagraph.setFontSize(Float.valueOf(fontSize2));
                round1pointsParagraph.setBold(Boolean.TRUE);
                round1pointsParagraph.setAlignment(Alignment.CENTER);
                round1pointsTableCell.addContent(round1pointsParagraph);
                tableRow3.addTableCell(round1pointsTableCell);
                TableCell round2pointsTableCell = new TableCell();
                round2pointsTableCell.setWidth(3.0f);
                round2pointsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph round2pointsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.round2points"));
                round2pointsParagraph.setFontSize(Float.valueOf(fontSize2));
                round2pointsParagraph.setBold(Boolean.TRUE);
                round2pointsParagraph.setAlignment(Alignment.CENTER);
                round2pointsTableCell.addContent(round2pointsParagraph);
                tableRow3.addTableCell(round2pointsTableCell);
                TableCell round3pointsTableCell = new TableCell();
                round3pointsTableCell.setWidth(3.0f);
                round3pointsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph round3pointsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.round3points"));
                round3pointsParagraph.setFontSize(Float.valueOf(fontSize2));
                round3pointsParagraph.setBold(Boolean.TRUE);
                round3pointsParagraph.setAlignment(Alignment.CENTER);
                round3pointsTableCell.addContent(round3pointsParagraph);
                tableRow3.addTableCell(round3pointsTableCell);
                TableCell varietyPointsTableCell = new TableCell();
                varietyPointsTableCell.setWidth(3.0f);
                varietyPointsTableCell.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph varietyPointsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "table.varietyPoints"));
                varietyPointsParagraph.setFontSize(Float.valueOf(fontSize2));
                varietyPointsParagraph.setBold(Boolean.TRUE);
                varietyPointsParagraph.setAlignment(Alignment.CENTER);
                varietyPointsTableCell.addContent(varietyPointsParagraph);
                tableRow3.addTableCell(varietyPointsTableCell);
                TableCell pointsTableCell3 = new TableCell();
                pointsTableCell3.setWidth(3.0f);
                pointsTableCell3.setVerticalAlignment(VerticalAlignment.MIDDLE);
                Paragraph pointsParagraph3 = new Paragraph(this.messageLoader.getMessage(locale, "table.points"));
                pointsParagraph3.setFontSize(Float.valueOf(fontSize2));
                pointsParagraph3.setBold(Boolean.TRUE);
                pointsParagraph3.setAlignment(Alignment.CENTER);
                pointsTableCell3.addContent(pointsParagraph3);
                tableRow3.addTableCell(pointsTableCell3);
                for (String[] row : duoTable) {
                    TableRow tableRow4 = new TableRow();
                    table2.addTableRow(tableRow4);
                    TableCell competitorTableCell5 = new TableCell();
                    competitorTableCell5.setWidth(7.0f);
                    Paragraph competitorParagraph5 = new Paragraph(row[0]);
                    competitorParagraph5.setFontSize(Float.valueOf(fontSize2));
                    competitorTableCell5.addContent(competitorParagraph5);
                    tableRow4.addTableCell(competitorTableCell5);
                    TableCell round1pointsTableCell2 = new TableCell();
                    round1pointsTableCell2.setWidth(3.0f);
                    round1pointsTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                    Paragraph round1pointsParagraph2 = new Paragraph(row[1]);
                    round1pointsParagraph2.setFontSize(Float.valueOf(fontSize2));
                    round1pointsParagraph2.setAlignment(Alignment.CENTER);
                    round1pointsTableCell2.addContent(round1pointsParagraph2);
                    tableRow4.addTableCell(round1pointsTableCell2);
                    TableCell round2pointsTableCell2 = new TableCell();
                    round2pointsTableCell2.setWidth(3.0f);
                    round2pointsTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                    Paragraph round2pointsParagraph2 = new Paragraph(row[2]);
                    round2pointsParagraph2.setFontSize(Float.valueOf(fontSize2));
                    round2pointsParagraph2.setAlignment(Alignment.CENTER);
                    round2pointsTableCell2.addContent(round2pointsParagraph2);
                    tableRow4.addTableCell(round2pointsTableCell2);
                    TableCell round3pointsTableCell2 = new TableCell();
                    round3pointsTableCell2.setWidth(3.0f);
                    round3pointsTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                    Paragraph round3pointsParagraph2 = new Paragraph(row[3]);
                    round3pointsParagraph2.setFontSize(Float.valueOf(fontSize2));
                    round3pointsParagraph2.setAlignment(Alignment.CENTER);
                    round3pointsTableCell2.addContent(round3pointsParagraph2);
                    tableRow4.addTableCell(round3pointsTableCell2);
                    TableCell varietyPointsTableCell2 = new TableCell();
                    varietyPointsTableCell2.setWidth(3.0f);
                    varietyPointsTableCell2.setVerticalAlignment(VerticalAlignment.MIDDLE);
                    Paragraph varietyPointsParagraph2 = new Paragraph(row[4]);
                    varietyPointsParagraph2.setFontSize(Float.valueOf(fontSize2));
                    varietyPointsParagraph2.setAlignment(Alignment.CENTER);
                    varietyPointsTableCell2.addContent(varietyPointsParagraph2);
                    tableRow4.addTableCell(varietyPointsTableCell2);
                    TableCell pointsTableCell4 = new TableCell();
                    pointsTableCell4.setWidth(3.0f);
                    Paragraph pointsParagraph4 = new Paragraph(row[5]);
                    pointsParagraph4.setFontSize(Float.valueOf(fontSize2));
                    pointsParagraph4.setAlignment(Alignment.CENTER);
                    pointsTableCell4.addContent(pointsParagraph4);
                    tableRow4.addTableCell(pointsTableCell4);
                }
            }
            if (MapUtil.isNotEmpty(categoryData.getMatchDataForRank())) {
                if (duoTableAdded) {
                    document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                }
                document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "competitors.knockout"), Heading.HeadingType.H2));
                for (Map.Entry<Rank, List<MatchData>> entry : categoryData.getMatchDataForRank().entrySet()) {
                    if (entry.getKey() == Rank.WORLD_LEVEL) {
                        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.worldLevel"), Heading.HeadingType.H3));
                    } else if (entry.getKey() == Rank.ADVANCED) {
                        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.advancedLevel"), Heading.HeadingType.H3));
                    } else if (entry.getKey() == Rank.NOVICE) {
                        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.noviceLevel"), Heading.HeadingType.H3));
                    }
                    BufferedImage image = this.matchTreeImageGenerator.generateDuoKnockoutMatches(entry.getValue(), categoryData.isDisplay3rdPlaceMatch());
                    Image imageContent = new Image(image, Alignment.CENTER);
                    imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                    document.addContent((Content)imageContent);
                }
            }
            if (CollectionUtil.isNotEmpty(categoryData.getMatchDatas())) {
                if (!categoryData.isCustom()) {
                    if (categoryData.getTreeType() == TreeCategory.TreeType.BEST_OF_3) {
                        BufferedImage image = this.matchTreeImageGenerator.generateBestOf3Fights(categoryData.getMatchDatas());
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TABLE2 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE3 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE4 || categoryData.getTreeType() == TreeCategory.TreeType.TABLE5) {
                        BufferedImage image = this.matchTreeImageGenerator.generateTableFights(categoryData.getMatchDatas());
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE4) {
                        boolean display3rdplace = categoryData.isDisplay3rdPlaceMatch();
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.NONE) {
                            display3rdplace = false;
                        }
                        BufferedImage image = this.matchTreeImageGenerator.generateTree4Fights(categoryData.getMatchDatas(), display3rdplace);
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE6) {
                        boolean display3rdplace = categoryData.isDisplay3rdPlaceMatch();
                        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "matches.groupStage"), Heading.HeadingType.H3));
                        BufferedImage image = this.matchTreeImageGenerator.generateTree6GroupStageFights(categoryData.getMatchDatas());
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent);
                        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "matches.knockout"), Heading.HeadingType.H3));
                        image = this.matchTreeImageGenerator.generateTree6KnockoutStageFights(categoryData.getMatchDatas(), display3rdplace);
                        imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE8) {
                        boolean displayRepassage = categoryData.getRepassageType() != TreeCategory.RepassageType.NONE;
                        BufferedImage image = this.matchTreeImageGenerator.generateTree8Fights(categoryData.getMatchDatas(), displayRepassage, categoryData.isDisplay3rdPlaceMatch());
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 1.0f));
                        document.addContent((Content)imageContent);
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE16) {
                        BufferedImage image = this.matchTreeImageGenerator.generateTree16Fights(categoryData.getMatchDatas());
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            document.addContent((Content)new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassage")));
                            BufferedImage imageRepasague = this.matchTreeImageGenerator.generateTree16RepassageFights(categoryData.getMatchDatas(), categoryData.isDisplay3rdPlaceMatch());
                            imageContent = new Image(imageRepasague, Alignment.CENTER);
                            imageContent.setMargin(new BorderMargin(0.0f, 0.0f, 0.0f, 1.0f));
                            document.addContent((Content)imageContent);
                        }
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE32) {
                        BufferedImage image = this.matchTreeImageGenerator.generateTree32Fights(categoryData.getMatchDatas());
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.LANDSCAPE));
                            Paragraph repassageParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassage"));
                            repassageParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)repassageParagraph);
                            BufferedImage imageRepasague = this.matchTreeImageGenerator.generateTree32RepassageFights(categoryData.getMatchDatas(), categoryData.isDisplay3rdPlaceMatch());
                            imageContent = new Image(imageRepasague, Alignment.CENTER);
                            document.addContent((Content)imageContent);
                        }
                    } else if (categoryData.getTreeType() == TreeCategory.TreeType.TREE64) {
                        Paragraph firstPartParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.firstPart"));
                        firstPartParagraph.setBold(Boolean.TRUE);
                        document.addContent((Content)firstPartParagraph);
                        BufferedImage image = this.matchTreeImageGenerator.generateTree64_1Fights(categoryData.getMatchDatas());
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                        document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                        Paragraph secondPartParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.secondPart"));
                        secondPartParagraph.setBold(Boolean.TRUE);
                        document.addContent((Content)secondPartParagraph);
                        image = this.matchTreeImageGenerator.generateTree64_2Fights(categoryData.getMatchDatas());
                        imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.LANDSCAPE));
                            Paragraph repassageParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassageFirstPart"));
                            repassageParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)repassageParagraph);
                            BufferedImage imageRepasague = this.matchTreeImageGenerator.generateTree64_1RepassageFights(categoryData.getMatchDatas());
                            imageContent = new Image(imageRepasague, Alignment.CENTER);
                            imageContent.setMargin(new BorderMargin(0.0f, 0.0f, 0.0f, 1.0f));
                            document.addContent((Content)imageContent);
                            document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.LANDSCAPE));
                            repassageParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.repassageSecondPart"));
                            repassageParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)repassageParagraph);
                            imageRepasague = this.matchTreeImageGenerator.generateTree64_2RepassageFights(categoryData.getMatchDatas());
                            imageContent = new Image(imageRepasague, Alignment.CENTER);
                            imageContent.setMargin(new BorderMargin(0.0f, 0.0f, 0.0f, 1.0f));
                            document.addContent((Content)imageContent);
                        }
                        document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                        if (categoryData.getRepassageType() == TreeCategory.RepassageType.SINGLE || categoryData.getRepassageType() == TreeCategory.RepassageType.DOUBLE) {
                            Paragraph forThirdParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.forThirdPlace"));
                            forThirdParagraph.setBold(Boolean.TRUE);
                            document.addContent((Content)forThirdParagraph);
                            image = this.matchTreeImageGenerator.generateTree64ForThirdFights(categoryData.getMatchDatas(), categoryData.isDisplay3rdPlaceMatch());
                            imageContent = new Image(image, Alignment.LEFT);
                            imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                            document.addContent((Content)imageContent);
                        }
                        Paragraph finalsParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.finals"));
                        finalsParagraph.setBold(Boolean.TRUE);
                        document.addContent((Content)finalsParagraph);
                        image = this.matchTreeImageGenerator.generateTree64FinalsFights(categoryData.getMatchDatas());
                        imageContent = new Image(image, Alignment.LEFT);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                    }
                } else {
                    LinkedList<MatchData> matchesLeft = new LinkedList<MatchData>(categoryData.getMatchDatas());
                    LinkedList<MatchData> matchesToAdd = new LinkedList<MatchData>();
                    while (!matchesLeft.isEmpty()) {
                        matchesToAdd.add(matchesLeft.poll());
                        if (matchesToAdd.size() != 3) continue;
                        BufferedImage image = this.matchTreeImageGenerator.generateMatchRowFights(matchesToAdd);
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                        matchesToAdd.clear();
                    }
                    if (!matchesToAdd.isEmpty()) {
                        BufferedImage image = this.matchTreeImageGenerator.generateMatchRowFights(matchesToAdd);
                        Image imageContent = new Image(image, Alignment.CENTER);
                        imageContent.setMargin(new BorderMargin(0.0f, 1.0f, 0.0f, 0.0f));
                        document.addContent((Content)imageContent);
                    }
                }
            }
            if (CollectionUtil.isNotEmpty(categoryData.getPlacingDatas())) {
                if (categoryData.getPlacingDatas().size() > 16 && categoryData.getPlacingDatas().size() < 33) {
                    document.addContent((Content)new PageBreak(PageSize.A4, PageDirection.PORTRAIT));
                }
                Paragraph placingParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.placing"));
                placingParagraph.setBold(Boolean.TRUE);
                document.addContent((Content)placingParagraph);
                for (PlacingData placingData : categoryData.getPlacingDatas()) {
                    StringBuilder line = new StringBuilder();
                    line.append(placingData.getPlacing());
                    line.append(". ");
                    line.append(placingData.getName());
                    Paragraph paragraph = new Paragraph(line.toString());
                    paragraph.setMargin(new BorderMargin());
                    document.addContent((Content)paragraph);
                }
                continue;
            }
            if (!MapUtil.isNotEmpty(categoryData.getPlacingsForRanks())) continue;
            Paragraph placingParagraph = new Paragraph(this.messageLoader.getMessage(locale, "competitors.placing"));
            placingParagraph.setBold(Boolean.TRUE);
            document.addContent((Content)placingParagraph);
            for (Map.Entry<Rank, List<PlacingData>> entry : categoryData.getPlacingsForRanks().entrySet()) {
                Rank rank = entry.getKey();
                if (CollectionUtil.isEmpty((Collection)entry.getValue())) continue;
                if (rank == Rank.WORLD_LEVEL) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.worldLevel"), Heading.HeadingType.H3));
                } else if (rank == Rank.ADVANCED) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.advancedLevel"), Heading.HeadingType.H3));
                } else if (rank == Rank.NOVICE) {
                    document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "table.noviceLevel"), Heading.HeadingType.H3));
                }
                for (PlacingData placingData : entry.getValue()) {
                    StringBuilder line = new StringBuilder();
                    line.append(placingData.getPlacing());
                    line.append(". ");
                    line.append(placingData.getName());
                    Paragraph paragraph = new Paragraph(line.toString());
                    paragraph.setMargin(new BorderMargin());
                    document.addContent((Content)paragraph);
                }
            }
        }
        return document;
    }

    public Document generateCompetitorRankingDocument(Locale locale, List<CompetitorRanking> fightingCompetitorRankings, List<CompetitorRanking> newazaCompetitorRankings, List<CompetitorRanking> coupleRankings) {
        Paragraph paragraph;
        StringBuilder line;
        PersonCompetitor personCompetitor;
        Document document = new Document();
        if (!fightingCompetitorRankings.isEmpty()) {
            document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "fightingCompetitorRanking.title"), Heading.HeadingType.H1));
            for (CompetitorRanking competitorRanking : fightingCompetitorRankings) {
                personCompetitor = (PersonCompetitor)competitorRanking.getCompetitor();
                line = new StringBuilder();
                line.append(competitorRanking.getPlace());
                line.append(". ");
                line.append(personCompetitor.getName() + " " + personCompetitor.getSurname() + " / " + personCompetitor.getClub().getName());
                line.append(", ");
                line.append(COMPETITOR_RANKING_POINTS_FORMAT.format(competitorRanking.getPoints()));
                line.append(" ");
                line.append(this.messageLoader.getMessage(locale, "competitorRanking.points"));
                paragraph = new Paragraph(line.toString());
                paragraph.setMargin(new BorderMargin());
                document.addContent((Content)paragraph);
            }
        }
        if (!newazaCompetitorRankings.isEmpty()) {
            document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "newazaCompetitorRanking.title"), Heading.HeadingType.H1));
            for (CompetitorRanking competitorRanking : newazaCompetitorRankings) {
                personCompetitor = (PersonCompetitor)competitorRanking.getCompetitor();
                line = new StringBuilder();
                line.append(competitorRanking.getPlace());
                line.append(". ");
                line.append(personCompetitor.getName() + " " + personCompetitor.getSurname() + " / " + personCompetitor.getClub().getName());
                line.append(", ");
                line.append(COMPETITOR_RANKING_POINTS_FORMAT.format(competitorRanking.getPoints()));
                line.append(" ");
                line.append(this.messageLoader.getMessage(locale, "competitorRanking.points"));
                paragraph = new Paragraph(line.toString());
                paragraph.setMargin(new BorderMargin());
                document.addContent((Content)paragraph);
            }
        }
        if (!coupleRankings.isEmpty()) {
            document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "coupleRanking.title"), Heading.HeadingType.H1));
            for (CompetitorRanking competitorRanking : coupleRankings) {
                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitorRanking.getCompetitor();
                line = new StringBuilder();
                line.append(competitorRanking.getPlace());
                line.append(". ");
                line.append(coupleCompetitor.getName1() + " " + coupleCompetitor.getSurname1() + ", " + coupleCompetitor.getName2() + " " + coupleCompetitor.getSurname2() + " / " + coupleCompetitor.getClub().getName());
                line.append(", ");
                line.append(COMPETITOR_RANKING_POINTS_FORMAT.format(competitorRanking.getPoints()));
                line.append(" ");
                line.append(this.messageLoader.getMessage(locale, "competitorRanking.points"));
                paragraph = new Paragraph(line.toString());
                paragraph.setMargin(new BorderMargin());
                document.addContent((Content)paragraph);
            }
        }
        return document;
    }

    public Document generateResultsForClubDocument(Locale locale, List<CompetitorPlacingData> competitorPlacingDataList, Map<Integer, Integer> placingCount) {
        Document document = new Document();
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "resultsForClub.title"), Heading.HeadingType.H1));
        for (CompetitorPlacingData competitorPlacingData : competitorPlacingDataList) {
            StringBuilder line = new StringBuilder();
            line.append(competitorPlacingData.getCategory().getName());
            line.append(" - ");
            if (competitorPlacingData.getRank() != null) {
                if (competitorPlacingData.getRank() == Rank.WORLD_LEVEL) {
                    line.append(this.messageLoader.getMessage(locale, "table.worldLevel"));
                } else if (competitorPlacingData.getRank() == Rank.ADVANCED) {
                    line.append(this.messageLoader.getMessage(locale, "table.advancedLevel"));
                } else if (competitorPlacingData.getRank() == Rank.NOVICE) {
                    line.append(this.messageLoader.getMessage(locale, "table.noviceLevel"));
                }
                line.append(" ");
            }
            line.append(competitorPlacingData.getPlacing());
            line.append(". ");
            if (competitorPlacingData.getCompetitor() instanceof PersonCompetitor) {
                PersonCompetitor personCompetitor = (PersonCompetitor)competitorPlacingData.getCompetitor();
                line.append(personCompetitor.getName() + " " + personCompetitor.getSurname() + " / " + personCompetitor.getClub().getName());
            } else if (competitorPlacingData.getCompetitor() instanceof CoupleCompetitor) {
                CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitorPlacingData.getCompetitor();
                line.append(coupleCompetitor.getName1() + " " + coupleCompetitor.getSurname1() + ", " + coupleCompetitor.getName2() + " " + coupleCompetitor.getSurname2() + " / " + coupleCompetitor.getClub().getName());
            }
            Paragraph paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "resultsForClub.placingsCount"), Heading.HeadingType.H1));
        ArrayList<Integer> placingList = new ArrayList<Integer>(placingCount.keySet());
        Collections.sort(placingList, new IntegerComparator());
        for (Integer placing : placingList) {
            StringBuilder line = new StringBuilder();
            line.append(placing);
            line.append(". ");
            line.append(this.messageLoader.getMessage(locale, "resultsForClub.placing"));
            line.append(" - ");
            line.append(placingCount.get(placing));
            Paragraph paragraph = new Paragraph(line.toString());
            paragraph.setMargin(new BorderMargin());
            document.addContent((Content)paragraph);
        }
        return document;
    }

    public Document generateMedalsForClubsDocument(Locale locale, List<MedalsCount> medalsCountList) {
        Document document = new Document();
        document.addContent((Content)new Heading(this.messageLoader.getMessage(locale, "medalsForClubs.title"), Heading.HeadingType.H1));
        Table table = new Table();
        TableRow header = new TableRow();
        header.addTableCell(DocumentGenerator.geenrateTableCell("", Alignment.CENTER, 3.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.club"), Alignment.LEFT, 10.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.firstPlace"), Alignment.CENTER, 7.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.secondPlace"), Alignment.CENTER, 7.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.thirdPlace"), Alignment.CENTER, 7.0f));
        header.addTableCell(DocumentGenerator.geenrateTableCell(this.messageLoader.getMessage(locale, "medalsForClubs.total"), Alignment.CENTER, 7.0f));
        table.addTableRow(header);
        for (MedalsCount medalsCount : medalsCountList) {
            TableRow tableRow = new TableRow();
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getPlacing()), Alignment.CENTER, 3.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(medalsCount.getClub().getName(), Alignment.LEFT, 10.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getFirstPlace()), Alignment.CENTER, 7.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getSecondPlace()), Alignment.CENTER, 7.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getThirdPlace()), Alignment.CENTER, 7.0f));
            tableRow.addTableCell(DocumentGenerator.geenrateTableCell(String.valueOf(medalsCount.getTotal()), Alignment.CENTER, 7.0f));
            table.addTableRow(tableRow);
        }
        document.addContent((Content)table);
        return document;
    }

    private static TableCell geenrateTableCell(String text, Alignment alignment, float width) {
        TableCell tableCell = new TableCell(text, alignment);
        tableCell.setWidth(width);
        return tableCell;
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        COMPETITOR_RANKING_POINTS_FORMAT = new DecimalFormat("0.00#");
    }
}

