/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.updaters;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.SelectType;
import si.nevensrok.jtekma.common.rules.Table;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.rules.TreeAdvancmentItem;
import si.nevensrok.jtekma.common.rules.TreeType;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.TatamiManager;
import si.nevensrok.jtekma.server.management.TreeAdvancmentManager;
import si.nevensrok.jtekma.server.management.updaters.Tree6TableCalculator;
import si.nevensrok.jtekma.server.management.updaters.TreePlacingsCalculator;

public class TreeUpdater {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeUpdater.class);
    private CompetitionManager competitionManager;
    private RulesManager rulesManager;
    private MatchManager matchManager;
    private TreeAdvancmentManager treeAdvancmentManager;
    private CategoryManager categoryManager;
    private TreePlacingsCalculator treePlacingsCalculator;
    private TatamiManager tatamiManager;
    private Tree6TableCalculator tree6TableCalculator;

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setTreeAdvancmentManager(TreeAdvancmentManager treeAdvancmentManager) {
        this.treeAdvancmentManager = treeAdvancmentManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setTreePlacingsCalculator(TreePlacingsCalculator treePlacingsCalculator) {
        this.treePlacingsCalculator = treePlacingsCalculator;
    }

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setTree6TableCalculator(Tree6TableCalculator tree6TableCalculator) {
        this.tree6TableCalculator = tree6TableCalculator;
    }

    public void updateTreeCategory(TreeCategory treeCategory) {
        TreeAdvancmentItem treeAdvancmentItem2;
        TreeAdvancmentItem treeAdvancmentItem1;
        Object match;
        Competition competition = this.competitionManager.getCompetitionForCategory((Category)treeCategory);
        CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
        HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
        HashMap matchPoints = new HashMap();
        for (Match match2 : this.matchManager.getMatchesForCategory((Category)treeCategory)) {
            matches.put(match2.getFightNumber(), match2);
        }
        for (Map.Entry entry : this.matchManager.getMatchPointsForMatches(new HashSet(matches.values())).entrySet()) {
            matchPoints.put(((Match)entry.getKey()).getFightNumber(), entry.getValue());
        }
        TreeAdvancment treeAdvancment = this.treeAdvancmentManager.getForCategory(treeCategory);
        Map map = this.categoryManager.getDrawAsNumber((Category)treeCategory);
        if (treeCategory.getTreeType() == TreeCategory.TreeType.BEST_OF_3) {
            Match match1 = (Match)matches.get(1);
            match1.setCompetitor1((Competitor)map.get(1));
            match1.setCompetitor2((Competitor)map.get(2));
            match1.setNotNeeded(Boolean.valueOf(false));
            match1.setMatchEmpty(Boolean.valueOf(false));
            Competitor winner1 = competitionRules.getMatchWinner(match1, (Set)matchPoints.get(match1.getFightNumber()));
            Match match2 = (Match)matches.get(2);
            match2.setCompetitor1((Competitor)map.get(2));
            match2.setCompetitor2((Competitor)map.get(1));
            match2.setNotNeeded(Boolean.valueOf(false));
            match2.setMatchEmpty(Boolean.valueOf(false));
            Competitor winner2 = competitionRules.getMatchWinner(match2, (Set)matchPoints.get(match2.getFightNumber()));
            Match match3 = (Match)matches.get(3);
            match3.setCompetitor1((Competitor)map.get(1));
            match3.setCompetitor2((Competitor)map.get(2));
            match3.setMatchEmpty(Boolean.valueOf(false));
            if (winner1 != null && winner2 != null && winner1.equals((Object)winner2)) {
                match3.setNotNeeded(Boolean.valueOf(true));
            } else {
                match3.setNotNeeded(Boolean.valueOf(false));
            }
            for (int i = 4; i <= 124; ++i) {
                this.setMatchAsEmpty((Match)matches.get(i));
            }
        } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE5) {
            int i;
            for (i = 1; i <= 10; ++i) {
                match = (Match)matches.get(i);
                treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR1, TreeType.TABLE);
                treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR2, TreeType.TABLE);
                match.setCompetitor1((Competitor)map.get(treeAdvancmentItem1.getFromMatch()));
                match.setCompetitor2((Competitor)map.get(treeAdvancmentItem2.getFromMatch()));
                if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 && (treeAdvancmentItem1.getFromMatch() == 1 && treeAdvancmentItem2.getFromMatch() == 2 || treeAdvancmentItem1.getFromMatch() == 2 && treeAdvancmentItem2.getFromMatch() == 1) || match.getCompetitor1() != null && match.getCompetitor2() != null) {
                    match.setNotNeeded(Boolean.valueOf(false));
                    match.setMatchEmpty(Boolean.valueOf(false));
                    continue;
                }
                match.setNotNeeded(Boolean.valueOf(true));
                match.setMatchEmpty(Boolean.valueOf(false));
            }
            for (i = 11; i <= 124; ++i) {
                this.setMatchAsEmpty((Match)matches.get(i));
            }
        } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE6) {
            Competitor looser;
            Competitor winner;
            Competitor[] competitors;
            Table table1 = new Table();
            Table.Row[] rows1 = new Table.Row[3];
            table1.setRows(rows1);
            Table table2 = new Table();
            Table.Row[] rows2 = new Table.Row[3];
            table2.setRows(rows2);
            for (int i = 0; i < 3; ++i) {
                rows1[i] = new Table.Row();
                rows1[i].setMatches(new Table.Row.Match[3]);
                rows2[i] = new Table.Row();
                rows2[i].setMatches(new Table.Row.Match[3]);
            }
            rows1[0].setCompetitor((Competitor)map.get(1));
            rows1[1].setCompetitor((Competitor)map.get(3));
            rows1[2].setCompetitor((Competitor)map.get(5));
            rows2[0].setCompetitor((Competitor)map.get(2));
            rows2[1].setCompetitor((Competitor)map.get(4));
            rows2[2].setCompetitor((Competitor)map.get(6));
            LinkedList<Match> tableMatches = new LinkedList<Match>();
            boolean table1finished = true;
            boolean table2finished = true;
            Match match3 = (Match)matches.get(1);
            match3.setCompetitor1((Competitor)map.get(1));
            match3.setCompetitor2((Competitor)map.get(5));
            this.setMatchFlags(match3);
            tableMatches.add(match3);
            table1finished &= match3.getStatus() == Match.Status.FINISHED || match3.getNotNeeded() != false;
            match3 = (Match)matches.get(2);
            match3.setCompetitor1((Competitor)map.get(2));
            match3.setCompetitor2((Competitor)map.get(6));
            this.setMatchFlags(match3);
            tableMatches.add(match3);
            table2finished &= match3.getStatus() == Match.Status.FINISHED || match3.getNotNeeded() != false;
            match3 = (Match)matches.get(3);
            match3.setCompetitor1((Competitor)map.get(1));
            match3.setCompetitor2((Competitor)map.get(3));
            this.setMatchFlags(match3);
            tableMatches.add(match3);
            table1finished &= match3.getStatus() == Match.Status.FINISHED || match3.getNotNeeded() != false;
            match3 = (Match)matches.get(4);
            match3.setCompetitor1((Competitor)map.get(2));
            match3.setCompetitor2((Competitor)map.get(4));
            this.setMatchFlags(match3);
            tableMatches.add(match3);
            table2finished &= match3.getStatus() == Match.Status.FINISHED || match3.getNotNeeded() != false;
            match3 = (Match)matches.get(5);
            match3.setCompetitor1((Competitor)map.get(3));
            match3.setCompetitor2((Competitor)map.get(5));
            this.setMatchFlags(match3);
            tableMatches.add(match3);
            table1finished &= match3.getStatus() == Match.Status.FINISHED || match3.getNotNeeded() != false;
            match3 = (Match)matches.get(6);
            match3.setCompetitor1((Competitor)map.get(4));
            match3.setCompetitor2((Competitor)map.get(6));
            this.setMatchFlags(match3);
            tableMatches.add(match3);
            table2finished &= match3.getStatus() == Match.Status.FINISHED || match3.getNotNeeded() != false;
            for (int i = 0; i < 3; ++i) {
                this.tree6TableCalculator.processTree6GroupStageMatches(i + 1, rows1[i], tableMatches, competitionRules);
                this.tree6TableCalculator.processTree6GroupStageMatches(i + 1, rows2[i], tableMatches, competitionRules);
            }
            Match halfFinals1 = (Match)matches.get(7);
            Match halfFinals2 = (Match)matches.get(8);
            Match for3rdPlace = (Match)matches.get(9);
            Match finals = (Match)matches.get(10);
            if (table1finished) {
                competitionRules.setPlacingsInTable(table1);
                competitors = TreeUpdater.getCompetitorsByPlacings(table1.getRows());
                halfFinals1.setCompetitor1(competitors[0]);
                halfFinals2.setCompetitor2(competitors[1]);
            } else {
                halfFinals1.setCompetitor1(null);
                halfFinals1.setNotNeeded(Boolean.valueOf(false));
                halfFinals1.setMatchEmpty(Boolean.valueOf(false));
                halfFinals2.setCompetitor2(null);
                halfFinals2.setNotNeeded(Boolean.valueOf(false));
                halfFinals2.setMatchEmpty(Boolean.valueOf(false));
            }
            if (table2finished) {
                competitionRules.setPlacingsInTable(table2);
                competitors = TreeUpdater.getCompetitorsByPlacings(table2.getRows());
                halfFinals2.setCompetitor1(competitors[0]);
                halfFinals1.setCompetitor2(competitors[1]);
            } else {
                halfFinals2.setCompetitor1(null);
                halfFinals2.setNotNeeded(Boolean.valueOf(false));
                halfFinals2.setMatchEmpty(Boolean.valueOf(false));
                halfFinals1.setCompetitor2(null);
                halfFinals1.setNotNeeded(Boolean.valueOf(false));
                halfFinals1.setMatchEmpty(Boolean.valueOf(false));
            }
            if (table1finished && table2finished) {
                this.setMatchFlags(halfFinals1);
                this.setMatchFlags(halfFinals2);
            } else {
                halfFinals1.setNotNeeded(Boolean.valueOf(false));
                halfFinals1.setMatchEmpty(Boolean.valueOf(false));
                halfFinals2.setNotNeeded(Boolean.valueOf(false));
                halfFinals2.setMatchEmpty(Boolean.valueOf(false));
            }
            boolean halfFinals1done = false;
            boolean halfFinals2done = false;
            if (halfFinals1.getMatchEmpty().booleanValue()) {
                finals.setCompetitor1(null);
                halfFinals1done = true;
            } else if (halfFinals1.getNotNeeded().booleanValue()) {
                winner = halfFinals1.getCompetitor1();
                if (winner == null) {
                    winner = halfFinals1.getCompetitor2();
                }
                finals.setCompetitor1(winner);
                halfFinals1done = true;
            } else if (halfFinals1.getStatus() == Match.Status.FINISHED) {
                winner = competitionRules.getMatchWinner(halfFinals1, (Set)matchPoints.get(halfFinals1.getFightNumber()));
                finals.setCompetitor1(winner);
                if (!treeCategory.getDouble3rdPlace().booleanValue()) {
                    looser = competitionRules.getMatchLoser(halfFinals1, (Set)matchPoints.get(halfFinals1.getFightNumber()));
                    for3rdPlace.setCompetitor1(looser);
                }
                halfFinals1done = true;
            }
            if (halfFinals2.getMatchEmpty().booleanValue()) {
                finals.setCompetitor2(null);
                halfFinals2done = true;
            } else if (halfFinals2.getNotNeeded().booleanValue()) {
                winner = halfFinals2.getCompetitor1();
                if (winner == null) {
                    winner = halfFinals2.getCompetitor2();
                }
                finals.setCompetitor2(winner);
                halfFinals2done = true;
            } else if (halfFinals2.getStatus() == Match.Status.FINISHED) {
                winner = competitionRules.getMatchWinner(halfFinals2, (Set)matchPoints.get(halfFinals2.getFightNumber()));
                finals.setCompetitor2(winner);
                if (!treeCategory.getDouble3rdPlace().booleanValue()) {
                    looser = competitionRules.getMatchLoser(halfFinals2, (Set)matchPoints.get(halfFinals2.getFightNumber()));
                    for3rdPlace.setCompetitor2(looser);
                }
                halfFinals2done = true;
            }
            if (halfFinals1done && halfFinals2done) {
                this.setMatchFlags(finals);
            } else {
                finals.setNotNeeded(Boolean.valueOf(false));
                finals.setMatchEmpty(Boolean.valueOf(false));
            }
            if (treeCategory.getDouble3rdPlace().booleanValue()) {
                this.setMatchAsEmpty(for3rdPlace);
            } else if (halfFinals1done && halfFinals2done) {
                this.setMatchFlags(for3rdPlace);
            } else {
                for3rdPlace.setNotNeeded(Boolean.valueOf(false));
                for3rdPlace.setMatchEmpty(Boolean.valueOf(false));
            }
            for (int i = 11; i <= 124; ++i) {
                this.setMatchAsEmpty((Match)matches.get(i));
            }
        } else {
            for (int i = 1; i <= 124; ++i) {
                match = (Match)matches.get(i);
                LOGGER.trace("Calculating for match num {}, match={}", (Object)i, match);
                treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR1, TreeType.TREE);
                treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(i, CompetitorType.COMPETITOR2, TreeType.TREE);
                Match fromMatch1 = (Match)matches.get(treeAdvancmentItem1.getFromMatch());
                Match fromMatch2 = (Match)matches.get(treeAdvancmentItem2.getFromMatch());
                Competitor competitor1 = null;
                Competitor competitor2 = null;
                if (treeAdvancmentItem1.getSelectType() == SelectType.DRAW) {
                    competitor1 = (Competitor)map.get(treeAdvancmentItem1.getFromMatch());
                } else if (treeAdvancmentItem1.getSelectType() == SelectType.WINNER) {
                    if (fromMatch1.getNotNeeded().booleanValue()) {
                        if (fromMatch1.getCompetitor1() != null) {
                            competitor1 = fromMatch1.getCompetitor1();
                        } else if (fromMatch1.getCompetitor2() != null) {
                            competitor1 = fromMatch1.getCompetitor2();
                        }
                    } else if (fromMatch1.getStatus() == Match.Status.FINISHED && !fromMatch1.getNoWinner().booleanValue()) {
                        competitor1 = competitionRules.getMatchWinner(fromMatch1, (Set)matchPoints.get(fromMatch1.getFightNumber()));
                    }
                } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER && !fromMatch1.getNotNeeded().booleanValue() && fromMatch1.getStatus() == Match.Status.FINISHED && !fromMatch1.getNoWinner().booleanValue()) {
                    competitor1 = competitionRules.getMatchLoser(fromMatch1, (Set)matchPoints.get(fromMatch1.getFightNumber()));
                }
                if (treeAdvancmentItem2.getSelectType() == SelectType.DRAW) {
                    competitor2 = (Competitor)map.get(treeAdvancmentItem2.getFromMatch());
                } else if (treeAdvancmentItem2.getSelectType() == SelectType.WINNER) {
                    if (fromMatch2.getNotNeeded().booleanValue()) {
                        if (fromMatch2.getCompetitor1() != null) {
                            competitor2 = fromMatch2.getCompetitor1();
                        } else if (fromMatch2.getCompetitor2() != null) {
                            competitor2 = fromMatch2.getCompetitor2();
                        }
                    } else if (fromMatch2.getStatus() == Match.Status.FINISHED && !fromMatch2.getNoWinner().booleanValue()) {
                        competitor2 = competitionRules.getMatchWinner(fromMatch2, (Set)matchPoints.get(fromMatch2.getFightNumber()));
                    }
                } else if (treeAdvancmentItem2.getSelectType() == SelectType.LOSER && !fromMatch2.getNotNeeded().booleanValue() && fromMatch2.getStatus() == Match.Status.FINISHED && !fromMatch2.getNoWinner().booleanValue()) {
                    competitor2 = competitionRules.getMatchLoser(fromMatch2, (Set)matchPoints.get(fromMatch2.getFightNumber()));
                }
                if (treeAdvancmentItem1.getSelectType() == SelectType.DRAW || treeAdvancmentItem2.getSelectType() == SelectType.DRAW) {
                    if (competitor1 == null && competitor2 == null) {
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(true));
                    } else if (competitor1 == null || competitor2 == null) {
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(false));
                    } else {
                        match.setNotNeeded(Boolean.valueOf(false));
                        match.setMatchEmpty(Boolean.valueOf(false));
                    }
                } else if ((fromMatch1.getMatchEmpty().booleanValue() || treeAdvancmentItem1.getSelectType() == SelectType.LOSER && fromMatch1.getNotNeeded().booleanValue()) && (fromMatch2.getMatchEmpty().booleanValue() || treeAdvancmentItem2.getSelectType() == SelectType.LOSER && fromMatch2.getNotNeeded().booleanValue())) {
                    match.setNotNeeded(Boolean.valueOf(true));
                    match.setMatchEmpty(Boolean.valueOf(true));
                } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER && fromMatch1.getNotNeeded().booleanValue() || treeAdvancmentItem2.getSelectType() == SelectType.LOSER && fromMatch2.getNotNeeded().booleanValue()) {
                    match.setNotNeeded(Boolean.valueOf(true));
                    match.setMatchEmpty(Boolean.valueOf(false));
                } else if (fromMatch1.getMatchEmpty().booleanValue() || fromMatch2.getMatchEmpty().booleanValue()) {
                    match.setNotNeeded(Boolean.valueOf(true));
                    match.setMatchEmpty(Boolean.valueOf(false));
                } else {
                    match.setNotNeeded(Boolean.valueOf(false));
                    match.setMatchEmpty(Boolean.valueOf(false));
                }
                if (i >= 49 && i <= 64) {
                    if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 1) {
                        competitor1 = null;
                        competitor2 = null;
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(true));
                    }
                } else if (i >= 65 && i <= 80) {
                    if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 2) {
                        competitor1 = null;
                        competitor2 = null;
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(true));
                    }
                } else if (i >= 89 && i <= 104) {
                    if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 3) {
                        competitor1 = null;
                        competitor2 = null;
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(true));
                    }
                } else if (i >= 109 && i <= 116) {
                    if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 4) {
                        competitor1 = null;
                        competitor2 = null;
                        match.setNotNeeded(Boolean.valueOf(true));
                        match.setMatchEmpty(Boolean.valueOf(true));
                    }
                } else if (i >= 119 && i <= 122 && (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getRepassageType() == TreeCategory.RepassageType.SINGLE && treeCategory.getRepassageFromRound() > 5)) {
                    competitor1 = null;
                    competitor2 = null;
                    match.setNotNeeded(Boolean.valueOf(true));
                    match.setMatchEmpty(Boolean.valueOf(true));
                }
                match.setCompetitor1(competitor1);
                match.setCompetitor2(competitor2);
            }
            if (treeCategory.getRepassageType() == TreeCategory.RepassageType.NONE || treeCategory.getDouble3rdPlace().booleanValue()) {
                ((Match)matches.get(123)).setNotNeeded(Boolean.valueOf(true));
                ((Match)matches.get(123)).setMatchEmpty(Boolean.valueOf(true));
                ((Match)matches.get(123)).setCompetitor1(null);
                ((Match)matches.get(123)).setCompetitor2(null);
            } else {
                ((Match)matches.get(123)).setNotNeeded(Boolean.valueOf(false));
                ((Match)matches.get(123)).setMatchEmpty(Boolean.valueOf(false));
            }
        }
        LinkedList<Match> matchesToUpdateStatus = new LinkedList<Match>();
        for (Match match4 : matches.values()) {
            Tatami tatami;
            if (match4.getStatus() == Match.Status.INPROGRESS) {
                tatami = this.tatamiManager.getTatamiForMatch(match4);
                if (tatami != null) continue;
                match4.setStatus(Match.Status.WAITING);
                matchesToUpdateStatus.add(match4);
                continue;
            }
            if (match4.getStatus() != Match.Status.INQUEUE || (tatami = this.tatamiManager.getTatamiForMatch(match4)) != null) continue;
            match4.setStatus(Match.Status.WAITING);
            matchesToUpdateStatus.add(match4);
        }
        this.matchManager.updateMatchTreeAdvancmentData(matches.values());
        for (Match match3 : matchesToUpdateStatus) {
            this.matchManager.setMatchStatus(match3, match3.getStatus());
        }
        Map<Competitor, Integer> placings = this.treePlacingsCalculator.getPlacings(treeCategory);
        this.categoryManager.setPlacings((Category)treeCategory, placings);
    }

    private void setMatchAsEmpty(Match match) {
        match.setCompetitor1(null);
        match.setCompetitor2(null);
        match.setNotNeeded(Boolean.valueOf(true));
        match.setMatchEmpty(Boolean.valueOf(true));
    }

    private void setMatchFlags(Match match) {
        if (match.getCompetitor1() == null && match.getCompetitor2() == null) {
            match.setNotNeeded(Boolean.valueOf(true));
            match.setMatchEmpty(Boolean.valueOf(true));
        } else if (match.getCompetitor1() == null || match.getCompetitor2() == null) {
            match.setNotNeeded(Boolean.valueOf(true));
            match.setMatchEmpty(Boolean.valueOf(false));
        } else {
            match.setNotNeeded(Boolean.valueOf(false));
            match.setMatchEmpty(Boolean.valueOf(false));
        }
    }

    public static Competitor[] getCompetitorsByPlacings(Table.Row[] rows) {
        Competitor[] competitors = new Competitor[3];
        for (Table.Row row : rows) {
            if (row.getPlacing() == null || row.getCompetitor() == null) continue;
            if (row.getPlacing() == 1) {
                if (competitors[0] == null) {
                    competitors[0] = row.getCompetitor();
                    continue;
                }
                if (competitors[1] == null) {
                    competitors[1] = row.getCompetitor();
                    continue;
                }
                if (competitors[2] != null) continue;
                competitors[2] = row.getCompetitor();
                continue;
            }
            if (row.getPlacing() == 2) {
                if (competitors[1] == null) {
                    competitors[1] = row.getCompetitor();
                    continue;
                }
                if (competitors[2] != null) continue;
                competitors[2] = row.getCompetitor();
                continue;
            }
            if (row.getPlacing() != 3) continue;
            competitors[2] = row.getCompetitor();
        }
        return competitors;
    }
}

