/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.updaters;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.Table;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.MatchManager;

public class Tree6TableCalculator {
    private CompetitionManager competitionManager;
    private RulesManager rulesManager;
    private MatchManager matchManager;
    private CategoryManager categoryManager;

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public Table getTable(TreeCategory treeCategory, int num) {
        int i;
        if (num != 1 && num != 2) {
            return null;
        }
        Competition competition = this.competitionManager.getCompetitionForCategory((Category)treeCategory);
        CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
        HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
        HashMap matchPoints = new HashMap();
        for (Match match : this.matchManager.getMatchesForCategory((Category)treeCategory)) {
            matches.put(match.getFightNumber(), match);
        }
        for (Map.Entry entry : this.matchManager.getMatchPointsForMatches(new HashSet(matches.values())).entrySet()) {
            matchPoints.put(((Match)entry.getKey()).getFightNumber(), entry.getValue());
        }
        Map draw = this.categoryManager.getDrawAsNumber((Category)treeCategory);
        LinkedList<Match> linkedList = new LinkedList<Match>();
        if (num == 1) {
            linkedList.add((Match)matches.get(1));
            linkedList.add((Match)matches.get(3));
            linkedList.add((Match)matches.get(5));
        } else {
            linkedList.add((Match)matches.get(2));
            linkedList.add((Match)matches.get(4));
            linkedList.add((Match)matches.get(6));
        }
        Table table = new Table();
        Table.Row[] rows = new Table.Row[3];
        table.setRows(rows);
        for (i = 0; i < 3; ++i) {
            rows[i] = new Table.Row();
            rows[i].setMatches(new Table.Row.Match[3]);
        }
        if (num == 1) {
            rows[0].setCompetitor((Competitor)draw.get(1));
            rows[1].setCompetitor((Competitor)draw.get(3));
            rows[2].setCompetitor((Competitor)draw.get(5));
        } else {
            rows[0].setCompetitor((Competitor)draw.get(2));
            rows[1].setCompetitor((Competitor)draw.get(4));
            rows[2].setCompetitor((Competitor)draw.get(6));
        }
        for (i = 0; i < 3; ++i) {
            this.processTree6GroupStageMatches(i + 1, rows[i], linkedList, competitionRules);
        }
        return table;
    }

    public void processTree6GroupStageMatches(int groupPos, Table.Row row, Collection<Match> matches, CompetitionRules competitionRules) {
        Competitor competitor = row.getCompetitor();
        if (competitor == null) {
            return;
        }
        int matchNum = 0;
        for (Match match : matches) {
            CompetitorType competitorType = null;
            if (match.getCompetitor1() != null && match.getCompetitor1().getId().equals(competitor.getId())) {
                competitorType = CompetitorType.COMPETITOR1;
            } else {
                if (match.getCompetitor2() == null || !match.getCompetitor2().getId().equals(competitor.getId())) continue;
                competitorType = CompetitorType.COMPETITOR2;
            }
            ++matchNum;
            Set points = this.matchManager.getMatchPointsForMatch(match);
            Competitor winner = competitionRules.getMatchWinner(match, points);
            Competitor looser = competitionRules.getMatchLoser(match, points);
            Boolean amIWinner = winner == null ? null : Boolean.valueOf(winner.getCompetitorId().equals(competitor.getCompetitorId()));
            Boolean amILooser = looser == null ? null : Boolean.valueOf(looser.getCompetitorId().equals(competitor.getCompetitorId()));
            boolean isFullIpponWin = false;
            boolean isFullIpponLoose = false;
            float myPoints = 0.0f;
            float otherPoints = 0.0f;
            float myIppons = 0.0f;
            float otherIppons = 0.0f;
            Match.Type matchType = match.getType();
            if (competitorType == CompetitorType.COMPETITOR1) {
                isFullIpponWin = competitionRules.isFullIpponFor(CompetitorType.COMPETITOR1, points) || competitionRules.isFinishingMove(CompetitorType.COMPETITOR1, points) || competitionRules.isDisqualificationFor(matchType, CompetitorType.COMPETITOR2, points);
                isFullIpponLoose = competitionRules.isFullIpponFor(CompetitorType.COMPETITOR2, points) || competitionRules.isFinishingMove(CompetitorType.COMPETITOR2, points) || competitionRules.isDisqualificationFor(matchType, CompetitorType.COMPETITOR1, points);
                myPoints = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points);
                otherPoints = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points);
                myIppons = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR1, points);
                otherIppons = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR2, points);
            } else {
                isFullIpponWin = competitionRules.isFullIpponFor(CompetitorType.COMPETITOR2, points) || competitionRules.isFinishingMove(CompetitorType.COMPETITOR2, points) || competitionRules.isDisqualificationFor(matchType, CompetitorType.COMPETITOR1, points);
                isFullIpponLoose = competitionRules.isFullIpponFor(CompetitorType.COMPETITOR1, points) || competitionRules.isFinishingMove(CompetitorType.COMPETITOR1, points) || competitionRules.isDisqualificationFor(matchType, CompetitorType.COMPETITOR2, points);
                myPoints = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR2, points);
                otherPoints = competitionRules.sumPointsFor(match.getType(), CompetitorType.COMPETITOR1, points);
                myIppons = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR2, points);
                otherIppons = competitionRules.sumIpponsFor(CompetitorType.COMPETITOR1, points);
            }
            if (!match.getNoWinner().booleanValue() && match.getStatus() == Match.Status.FINISHED) {
                if (amIWinner != null && amIWinner.booleanValue()) {
                    row.setWins(Integer.valueOf(row.getWins() + 1));
                }
                if (amILooser != null && amILooser.booleanValue()) {
                    row.setLooses(Integer.valueOf(row.getLooses() + 1));
                }
                if (isFullIpponWin) {
                    row.setFullIpponWins(Integer.valueOf(row.getFullIpponWins() + 1));
                }
                if (isFullIpponLoose) {
                    row.setFullIpponLooses(Integer.valueOf(row.getFullIpponLooses() + 1));
                }
                row.setPointsGained(Float.valueOf(row.getPointsGained().floatValue() + myPoints));
                row.setPointsAgainst(Float.valueOf(row.getPointsAgainst().floatValue() + otherPoints));
                row.setIpponsGained(Float.valueOf(row.getIpponsGained().floatValue() + myIppons));
                row.setIpponsAgainst(Float.valueOf(row.getIpponsAgainst().floatValue() + otherIppons));
            }
            int otherNum = 0;
            if (groupPos == 1) {
                if (matchNum == 1) {
                    otherNum = 2;
                } else if (matchNum == 2) {
                    otherNum = 1;
                }
            } else if (groupPos == 2) {
                if (matchNum == 1) {
                    otherNum = 0;
                } else if (matchNum == 2) {
                    otherNum = 2;
                }
            } else if (groupPos == 3) {
                if (matchNum == 1) {
                    otherNum = 0;
                } else if (matchNum == 2) {
                    otherNum = 1;
                }
            }
            row.getMatches()[otherNum] = new Table.Row.Match();
            row.getMatches()[otherNum].setMyPoints(Float.valueOf(myPoints));
            row.getMatches()[otherNum].setOtherPoints(Float.valueOf(otherPoints));
            row.getMatches()[otherNum].setAmIWinner(Boolean.valueOf(amIWinner == null ? false : amIWinner));
        }
    }
}

